/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CleanroomMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class CleanroomLogic
extends RecipeLogic
implements IWorkable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CleanroomLogic.class, RecipeLogic.MANAGED_FIELD_HOLDER);
    public static final int BASE_CLEAN_AMOUNT = 2;
    @Nullable
    private IMaintenanceMachine maintenanceMachine;
    @Nullable
    private IEnergyContainer energyContainer;
    @Persisted
    private boolean isActiveAndNeedsUpdate;

    public CleanroomLogic(CleanroomMachine machine) {
        super(machine);
    }

    @Override
    public CleanroomMachine getMachine() {
        return (CleanroomMachine)this.machine;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void serverTick() {
        if (this.duration > 0) {
            EnvironmentalHazardSavedData environmentalHazards = EnvironmentalHazardSavedData.getOrCreate((ServerLevel)this.getMachine().getLevel());
            EnvironmentalHazardSavedData.HazardZone zone = environmentalHazards.getZoneByContainedPos(this.getMachine().getPos());
            if (this.maintenanceMachine == null || this.maintenanceMachine.getNumMaintenanceProblems() < 6 || zone != null) {
                if (!this.consumeEnergy()) {
                    if (this.progress > 0 && this.machine.regressWhenWaiting()) {
                        this.progress = 1;
                    }
                    if (this.machine.self().getOffsetTimer() % (long)this.duration == 0L) {
                        this.adjustCleanAmount(true);
                    }
                    this.setWaiting((Component)Component.translatable((String)"gtceu.recipe_logic.insufficient_in").append(": ").append((Component)EURecipeCapability.CAP.getName()));
                    return;
                }
                this.setStatus(RecipeLogic.Status.WORKING);
                if (this.progress++ < this.getMaxProgress()) {
                    if (!this.machine.onWorking()) {
                        this.interruptRecipe();
                    }
                    return;
                }
                this.progress = 0;
                if (!this.machine.beforeWorking(null)) {
                    return;
                }
                this.adjustCleanAmount(false);
            } else {
                if (this.progress > 0) {
                    --this.progress;
                }
                if (this.machine.self().getOffsetTimer() % (long)this.duration == 0L) {
                    this.adjustCleanAmount(true);
                }
                this.setStatus(RecipeLogic.Status.IDLE);
                this.machine.afterWorking();
            }
        }
    }

    protected void adjustCleanAmount(boolean declined) {
        int amountToClean = 2 + 3 * (this.getTierDifference() + 1);
        if (declined) {
            amountToClean *= -1;
        }
        if (this.maintenanceMachine != null) {
            amountToClean -= this.maintenanceMachine.getNumMaintenanceProblems();
        }
        this.getMachine().adjustCleanAmount(amountToClean);
    }

    protected boolean consumeEnergy() {
        long resultEnergy;
        long energyToDrain;
        CleanroomMachine cleanroom = this.getMachine();
        int tier = Mth.clamp((int)cleanroom.getTier(), (int)0, (int)14);
        long l = energyToDrain = cleanroom.isClean() ? Math.max(8L, 3L * GTValues.V[tier] / 16L) : (long)GTValues.VA[tier];
        if (this.energyContainer != null && (resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain) >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            this.energyContainer.removeEnergy(energyToDrain);
            return true;
        }
        return false;
    }

    protected int getTierDifference() {
        int minEnergyTier = 1;
        return Math.max(0, this.getMachine().getTier() - minEnergyTier);
    }

    public void setDuration(int max) {
        this.duration = max;
    }

    @Generated
    public void setMaintenanceMachine(@Nullable IMaintenanceMachine maintenanceMachine) {
        this.maintenanceMachine = maintenanceMachine;
    }

    @Generated
    public void setEnergyContainer(@Nullable IEnergyContainer energyContainer) {
        this.energyContainer = energyContainer;
    }

    @Generated
    public boolean isActiveAndNeedsUpdate() {
        return this.isActiveAndNeedsUpdate;
    }

    @Generated
    public void setActiveAndNeedsUpdate(boolean isActiveAndNeedsUpdate) {
        this.isActiveAndNeedsUpdate = isActiveAndNeedsUpdate;
    }
}

