/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.common.machine.electric.ConverterMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.energy.IEnergyStorage;

public class ConverterTrait
extends NotifiableEnergyContainer {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ConverterTrait.class, NotifiableEnergyContainer.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean feToEu;
    private final int amps;
    private final long voltage;
    private final FEContainer feContainer;

    public ConverterTrait(ConverterMachine machine, int amps) {
        super(machine, GTValues.V[machine.getTier()] * 16L * (long)amps, GTValues.V[machine.getTier()], amps, GTValues.V[machine.getTier()], amps);
        this.amps = amps;
        this.voltage = GTValues.V[machine.getTier()];
        this.setSideInputCondition(side -> !this.feToEu && side != this.getMachine().getFrontFacing());
        this.setSideOutputCondition(side -> this.feToEu && side == this.getMachine().getFrontFacing());
        this.feContainer = new FEContainer(machine);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void setFeToEu(boolean feToEu) {
        this.feToEu = feToEu;
        this.setRenderState((MachineRenderState)((Object)this.getRenderState().setValue((Property)GTMachineModelProperties.IS_FE_TO_EU, Boolean.valueOf(feToEu))));
        this.machine.notifyBlockUpdate();
    }

    @Override
    public void checkOutputSubscription() {
        this.outputSubs = this.getMachine().subscribeServerTick(this.outputSubs, this::serverTick);
    }

    @Override
    public void serverTick() {
        if (this.feToEu) {
            super.serverTick();
        } else {
            long energyUsed;
            Direction fontFacing = this.machine.getFrontFacing();
            IEnergyStorage energyContainer = GTCapabilityHelper.getForgeEnergy(this.machine.getLevel(), this.machine.getPos().relative(fontFacing), fontFacing.getOpposite());
            if (energyContainer != null && energyContainer.canReceive() && (energyUsed = FeCompat.insertEu(energyContainer, Math.min(this.getEnergyStored(), this.voltage * (long)this.amps), false)) > 0L) {
                this.setEnergyStored(this.getEnergyStored() - energyUsed);
            }
        }
    }

    @Generated
    public boolean isFeToEu() {
        return this.feToEu;
    }

    @Generated
    public int getAmps() {
        return this.amps;
    }

    @Generated
    public long getVoltage() {
        return this.voltage;
    }

    @Generated
    public FEContainer getFeContainer() {
        return this.feContainer;
    }

    private class FEContainer
    extends MachineTrait
    implements IEnergyStorage {
        protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FEContainer.class);

        public FEContainer(MetaMachine machine) {
            super(machine);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!ConverterTrait.this.feToEu || maxReceive <= 0) {
                return 0;
            }
            int received = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), maxReceive);
            received -= received % FeCompat.ratio(true);
            if (!simulate) {
                ConverterTrait.this.addEnergy(FeCompat.toEu(received, FeCompat.ratio(true)));
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return FeCompat.toFeBounded(ConverterTrait.this.getEnergyStored(), FeCompat.ratio(ConverterTrait.this.feToEu), Integer.MAX_VALUE);
        }

        public int getMaxEnergyStored() {
            return FeCompat.toFeBounded(ConverterTrait.this.getEnergyCapacity(), FeCompat.ratio(ConverterTrait.this.feToEu), Integer.MAX_VALUE);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return ConverterTrait.this.feToEu;
        }

        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }
    }
}

