/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.customlogic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArcFurnaceLogic
extends Enum<ArcFurnaceLogic>
implements GTRecipeType.ICustomRecipeLogic {
    public static final /* enum */ ArcFurnaceLogic INSTANCE = new ArcFurnaceLogic();
    private static final /* synthetic */ ArcFurnaceLogic[] $VALUES;

    public static ArcFurnaceLogic[] values() {
        return (ArcFurnaceLogic[])$VALUES.clone();
    }

    public static ArcFurnaceLogic valueOf(String name) {
        return Enum.valueOf(ArcFurnaceLogic.class, name);
    }

    @Override
    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        List<IRecipeHandler<?>> recipeHandlers = holder.getCapabilitiesFlat(IO.IN, ItemRecipeCapability.CAP);
        for (IRecipeHandler<?> handler : recipeHandlers) {
            for (Object content : handler.getContents()) {
                GTRecipe recipe;
                ItemStack stack;
                if (!(content instanceof ItemStack) || (stack = (ItemStack)content).isEmpty() || (recipe = this.search(stack)) == null) continue;
                return recipe;
            }
        }
        return null;
    }

    @Nullable
    private GTRecipe search(ItemStack stack) {
        IGTTool tool;
        TurbineRotorBehaviour turbineBehaviour = TurbineRotorBehaviour.getBehaviour(stack);
        if (turbineBehaviour != null) {
            float durability = 1.0f - (float)turbineBehaviour.getPartDamage(stack) / (float)turbineBehaviour.getPartMaxDurability(stack);
            return this.applyDurabilityRecipe("rotor_decomp", stack, turbineBehaviour.getPartMaterial(stack), (float)(TagPrefix.turbineBlade.materialAmount() * 8L) / 3628800.0f, durability, GTValues.VH[4], 1);
        }
        Item item = stack.getItem();
        if (item instanceof IGTTool && !(tool = (IGTTool)item).isElectric()) {
            float durability = (float)(tool.getTotalMaxDurability(stack) - stack.getDamageValue() + 1) / (float)(tool.getTotalMaxDurability(stack) + 1);
            return this.applyDurabilityRecipe("tool_decomp", stack, tool.getMaterial(), tool.getToolType().materialAmount / 3628800L, durability, GTValues.VH[1], 2);
        }
        return null;
    }

    @Nullable
    public GTRecipe applyDurabilityRecipe(String id, ItemStack inputStack, @NotNull Material mat, float fullAmount, float durability, long voltage, int durationFactor) {
        if (!mat.hasProperty(PropertyKey.INGOT)) {
            return null;
        }
        IngotProperty material = mat.getProperty(PropertyKey.INGOT);
        Material materialArc = material.getArcSmeltingInto();
        float outputAmount = durability * fullAmount;
        int dustAmount = (int)outputAmount;
        int leftover = (int)((outputAmount - (float)dustAmount) * 9.0f);
        if (dustAmount == 0 && leftover == 0) {
            return null;
        }
        GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder(id + "/" + mat.getName()).inputItems(inputStack).inputFluids(GTMaterials.Oxygen.getFluid((int)((float)materialArc.getMass() * outputAmount) * durationFactor)).EUt(voltage).duration((int)((float)materialArc.getMass() * outputAmount) * durationFactor);
        if (dustAmount > 0) {
            builder.outputItems(TagPrefix.ingot, materialArc, dustAmount);
        }
        if (leftover > 0) {
            builder.outputItems(TagPrefix.nugget, materialArc, leftover);
        }
        return builder.buildRawRecipe();
    }

    @Override
    public void buildRepresentativeRecipes() {
        ItemStack stack = GTItems.TURBINE_ROTOR.asStack();
        stack.setHoverName((Component)Component.translatable((String)"gtceu.auto_decomp.rotor"));
        float durability = 0.69f;
        TurbineRotorBehaviour turbineBehaviour = TurbineRotorBehaviour.getBehaviour(stack);
        assert (turbineBehaviour != null) : "Default Turbine Stack doesn't have Turbine Behaviour";
        turbineBehaviour.setPartMaterial(stack, GTMaterials.Iron);
        turbineBehaviour.setPartDamage(stack, 8928);
        GTRecipe rotorRecipe = this.applyDurabilityRecipe("rotor_decomp", stack, turbineBehaviour.getPartMaterial(stack), (float)(TagPrefix.turbineBlade.materialAmount() * 8L) / 3628800.0f, durability, GTValues.VH[4], 1);
        assert (rotorRecipe != null) : "Default Turbine Decomp recipe couldn't be generated";
        rotorRecipe.setId(rotorRecipe.getId().withPrefix("/"));
        stack = ((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)GTMaterials.Iron, (Object)GTToolType.PICKAXE)).asStack();
        stack.setHoverName((Component)Component.translatable((String)"gtceu.auto_decomp.tool"));
        stack.setDamageValue(79);
        GTRecipe pickaxeRecipe = this.applyDurabilityRecipe("tool_decomp", stack, GTMaterials.Iron, GTToolType.PICKAXE.materialAmount / 3628800L, durability, GTValues.VH[1], 2);
        assert (pickaxeRecipe != null) : "Default Tool Decomp recipe couldn't be generated";
        pickaxeRecipe.setId(pickaxeRecipe.getId().withPrefix("/"));
        GTRecipeCategories.ARC_FURNACE_RECYCLING.addRecipe(pickaxeRecipe);
        GTRecipeCategories.ARC_FURNACE_RECYCLING.addRecipe(rotorRecipe);
    }

    private static /* synthetic */ ArcFurnaceLogic[] $values() {
        return new ArcFurnaceLogic[]{INSTANCE};
    }

    static {
        $VALUES = ArcFurnaceLogic.$values();
    }
}

