/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.customlogic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluidHelper;
import com.gregtechceu.gtceu.core.mixins.PotionBrewingAccessor;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BreweryLogic implements GTRecipeType.ICustomRecipeLogic
{
    INSTANCE;

    private static final Function<Fluid, TagKey<Fluid>> FLUID_TAGS;
    private static final Function<PotionBrewing.Mix<Potion>, FluidStack> MIX_INPUTS;
    private static final Function<BrewingRecipe, FluidIngredient> BREW_INGREDIENTS;

    @Override
    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        Object brew;
        List<RecipeHandlerList> handlerLists = holder.getCapabilitiesForIO(IO.IN);
        if (handlerLists.isEmpty()) {
            return null;
        }
        ArrayList<RecipeHandlerList> distinct = new ArrayList<RecipeHandlerList>();
        ArrayList notDistinctItems = new ArrayList();
        ArrayList notDistinctFluids = new ArrayList();
        for (RecipeHandlerList handlerList : handlerLists) {
            if (handlerList.isDistinct()) {
                distinct.add(handlerList);
                continue;
            }
            notDistinctItems.addAll(handlerList.getCapability(ItemRecipeCapability.CAP));
            notDistinctFluids.addAll(handlerList.getCapability(FluidRecipeCapability.CAP));
        }
        if (distinct.isEmpty() && notDistinctItems.isEmpty() && notDistinctFluids.isEmpty()) {
            return null;
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (RecipeHandlerList handlerList : distinct) {
            itemStacks.clear();
            fluidStacks.clear();
            if (!BreweryLogic.collect(handlerList, itemStacks, fluidStacks)) continue;
            for (ItemStack itemStack : itemStacks) {
                for (PotionBrewing.Mix<Potion> mix : PotionBrewingAccessor.getPotionMixes()) {
                    if (!mix.ingredient.test(itemStack)) continue;
                    FluidStack fromFluid = MIX_INPUTS.apply(mix);
                    for (FluidStack fluidStack : fluidStacks) {
                        if (!BreweryLogic.testMixFluid(fluidStack, fromFluid)) continue;
                        return BreweryLogic.vanillaPotionRecipe(mix, fromFluid);
                    }
                }
                for (IBrewingRecipe iBrewingRecipe : BrewingRecipeRegistry.getRecipes()) {
                    if (!(iBrewingRecipe instanceof BrewingRecipe) || !(brew = (BrewingRecipe)iBrewingRecipe).isIngredient(itemStack)) continue;
                    FluidIngredient fluidIngredient = BREW_INGREDIENTS.apply((BrewingRecipe)brew);
                    for (FluidStack fluidStack2 : fluidStacks) {
                        if (!fluidIngredient.test(fluidStack2)) continue;
                        return BreweryLogic.forgePotionRecipe((BrewingRecipe)brew, fluidIngredient);
                    }
                }
            }
        }
        if (notDistinctItems.isEmpty() && notDistinctFluids.isEmpty()) {
            return null;
        }
        itemStacks.clear();
        fluidStacks.clear();
        BreweryLogic.collect(notDistinctItems, notDistinctFluids, itemStacks, fluidStacks);
        if (itemStacks.isEmpty() && fluidStacks.isEmpty()) {
            return null;
        }
        ReferenceOpenHashSet mixesWithIngredient = new ReferenceOpenHashSet();
        ReferenceOpenHashSet brewsWithIngredient = new ReferenceOpenHashSet();
        Reference2ObjectOpenHashMap mixesWithInput = new Reference2ObjectOpenHashMap();
        Reference2ObjectOpenHashMap brewsWithInput = new Reference2ObjectOpenHashMap();
        block7: for (PotionBrewing.Mix mix : PotionBrewingAccessor.getPotionMixes()) {
            for (ItemStack itemStack : itemStacks) {
                if (!mix.ingredient.test(itemStack)) continue;
                mixesWithIngredient.add((Object)mix);
                break;
            }
            for (FluidStack fluidStack : fluidStacks) {
                FluidStack fluidStack2;
                if (!BreweryLogic.testMixFluid(fluidStack, fluidStack2 = MIX_INPUTS.apply((PotionBrewing.Mix<Potion>)mix))) continue;
                if (mixesWithIngredient.contains((Object)mix)) {
                    return BreweryLogic.vanillaPotionRecipe((PotionBrewing.Mix<Potion>)mix, fluidStack2);
                }
                mixesWithInput.put((Object)mix, (Object)fluidStack2);
                continue block7;
            }
        }
        block10: for (IBrewingRecipe iBrewingRecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(iBrewingRecipe instanceof BrewingRecipe)) continue;
            brew = (BrewingRecipe)iBrewingRecipe;
            for (ItemStack itemStack : itemStacks) {
                if (!brew.isIngredient(itemStack)) continue;
                brewsWithIngredient.add(brew);
                break;
            }
            for (FluidStack fluidStack : fluidStacks) {
                FluidIngredient fromFluid = BREW_INGREDIENTS.apply((BrewingRecipe)brew);
                if (!fromFluid.test(fluidStack)) continue;
                if (brewsWithIngredient.contains(brew)) {
                    return BreweryLogic.forgePotionRecipe((BrewingRecipe)brew, fromFluid);
                }
                brewsWithInput.put(brew, (Object)fromFluid);
                continue block10;
            }
        }
        if (mixesWithIngredient.isEmpty() && mixesWithInput.isEmpty() && brewsWithIngredient.isEmpty() && brewsWithInput.isEmpty()) {
            return null;
        }
        for (RecipeHandlerList recipeHandlerList : distinct) {
            itemStacks.clear();
            fluidStacks.clear();
            BreweryLogic.collect(recipeHandlerList, itemStacks, fluidStacks);
            if (!mixesWithInput.isEmpty() || !brewsWithInput.isEmpty()) {
                for (ItemStack itemStack : itemStacks) {
                    Object fluid;
                    for (Reference2ObjectMap.Entry entry : mixesWithInput.reference2ObjectEntrySet()) {
                        PotionBrewing.Mix mix = (PotionBrewing.Mix)entry.getKey();
                        fluid = (FluidStack)entry.getValue();
                        if (!mix.ingredient.test(itemStack)) continue;
                        return BreweryLogic.vanillaPotionRecipe((PotionBrewing.Mix<Potion>)mix, fluid);
                    }
                    for (Reference2ObjectMap.Entry entry : brewsWithInput.reference2ObjectEntrySet()) {
                        BrewingRecipe brew2 = (BrewingRecipe)entry.getKey();
                        fluid = (FluidIngredient)entry.getValue();
                        if (!brew2.isIngredient(itemStack)) continue;
                        return BreweryLogic.forgePotionRecipe(brew2, (FluidIngredient)fluid);
                    }
                }
            }
            if (mixesWithIngredient.isEmpty() && brewsWithIngredient.isEmpty()) continue;
            for (FluidStack fluidStack : fluidStacks) {
                Object fromFluid;
                for (PotionBrewing.Mix mix : mixesWithIngredient) {
                    fromFluid = MIX_INPUTS.apply((PotionBrewing.Mix<Potion>)mix);
                    if (!BreweryLogic.testMixFluid(fluidStack, (FluidStack)fromFluid)) continue;
                    return BreweryLogic.vanillaPotionRecipe((PotionBrewing.Mix<Potion>)mix, (FluidStack)fromFluid);
                }
                for (BrewingRecipe brew3 : brewsWithIngredient) {
                    fromFluid = BREW_INGREDIENTS.apply(brew3);
                    if (!((FluidIngredient)fromFluid).test(fluidStack)) continue;
                    return BreweryLogic.forgePotionRecipe(brew3, (FluidIngredient)fromFluid);
                }
            }
        }
        return null;
    }

    private static boolean testMixFluid(FluidStack fluidStack, FluidStack fromFluid) {
        TagKey<Fluid> fromTag = FLUID_TAGS.apply(fromFluid.getFluid());
        return (fluidStack.getFluid() == fromFluid.getFluid() || fluidStack.getFluid().is(fromTag)) && Objects.equals(fromFluid.getTag(), fluidStack.getTag());
    }

    @NotNull
    private static GTRecipe forgePotionRecipe(BrewingRecipe brew, FluidIngredient fromFluid) {
        FluidStack toFluid = PotionFluidHelper.getFluidFromPotionItem(brew.getOutput(), 750);
        Potion output = PotionUtils.getPotion((ItemStack)brew.getOutput());
        String name = output != Potions.EMPTY ? output.getName("") : toFluid.getFluid().builtInRegistryHolder().key().location().getPath();
        return GTRecipeTypes.BREWING_RECIPES.recipeBuilder("potion_forge_" + name).inputItems(brew.getIngredient()).inputFluids(fromFluid).outputFluids(toFluid).duration(400).EUt(GTValues.VHA[2]).buildRawRecipe();
    }

    @NotNull
    private static GTRecipe vanillaPotionRecipe(PotionBrewing.Mix<Potion> mix, FluidStack fromFluid) {
        FluidStack toFluid = PotionFluidHelper.getFluidFromPotion((Potion)mix.to.get(), 750);
        return GTRecipeTypes.BREWING_RECIPES.recipeBuilder("potion_vanilla_" + ((Potion)mix.to.get()).getName("")).inputItems(mix.ingredient).inputFluids(fromFluid).outputFluids(toFluid).duration(400).EUt(GTValues.VHA[2]).buildRawRecipe();
    }

    private static boolean collect(RecipeHandlerList rhl, List<ItemStack> itemStacks, List<FluidStack> fluidStacks) {
        return BreweryLogic.collect(rhl.getCapability(ItemRecipeCapability.CAP), rhl.getCapability(FluidRecipeCapability.CAP), itemStacks, fluidStacks);
    }

    private static boolean collect(List<IRecipeHandler<?>> itemHandlers, List<IRecipeHandler<?>> fluidHandlers, List<ItemStack> itemStacks, List<FluidStack> fluidStacks) {
        ItemStack stack;
        for (IRecipeHandler<?> handler : itemHandlers) {
            for (Object content : handler.getContents()) {
                if (!(content instanceof ItemStack) || (stack = (ItemStack)content).isEmpty()) continue;
                itemStacks.add(stack);
            }
        }
        for (IRecipeHandler<?> handler : fluidHandlers) {
            for (Object content : handler.getContents()) {
                if (!(content instanceof FluidStack) || (stack = (FluidStack)content).isEmpty()) continue;
                fluidStacks.add((FluidStack)stack);
            }
        }
        return !itemStacks.isEmpty() && !fluidStacks.isEmpty();
    }

    @Override
    public void buildRepresentativeRecipes() {
        int index = 0;
        for (PotionBrewing.Mix<Potion> mix : PotionBrewingAccessor.getPotionMixes()) {
            FluidStack fromFluid = PotionFluidHelper.getFluidFromPotion((Potion)mix.from.get(), 750);
            FluidStack toFluid = PotionFluidHelper.getFluidFromPotion((Potion)mix.to.get(), 750);
            GTRecipe recipe = GTRecipeTypes.BREWING_RECIPES.recipeBuilder("potion_vanilla_" + ((Potion)mix.to.get()).getName("") + "_" + index++).inputItems(mix.ingredient).inputFluids(fromFluid).outputFluids(toFluid).duration(400).EUt(GTValues.VHA[2]).buildRawRecipe();
            recipe.setId(recipe.getId().withPrefix("/"));
            GTRecipeTypes.BREWING_RECIPES.addToMainCategory(recipe);
        }
        for (IBrewingRecipe brewingRecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(brewingRecipe instanceof BrewingRecipe)) continue;
            BrewingRecipe impl = (BrewingRecipe)brewingRecipe;
            FluidIngredient fromFluid = PotionFluidHelper.getPotionFluidIngredientFrom(impl.getInput(), 750);
            FluidStack toFluid = PotionFluidHelper.getFluidFromPotionItem(impl.getOutput(), 750);
            String name = toFluid.getFluid().builtInRegistryHolder().key().location().getPath();
            Potion output = PotionUtils.getPotion((ItemStack)impl.getOutput());
            if (output != null) {
                name = output.getName("");
            }
            GTRecipe recipe = GTRecipeTypes.BREWING_RECIPES.recipeBuilder("potion_forge_" + name + "_" + index++).inputItems(impl.getIngredient()).inputFluids(fromFluid).outputFluids(toFluid).duration(400).EUt(GTValues.VHA[2]).buildRawRecipe();
            recipe.setId(recipe.getId().withPrefix("/"));
            GTRecipeTypes.BREWING_RECIPES.addToMainCategory(recipe);
        }
    }

    static {
        FLUID_TAGS = Util.memoize(fluid -> TagUtil.createFluidTag(BuiltInRegistries.FLUID.getKey(fluid).getPath()));
        MIX_INPUTS = Util.memoize(mix -> PotionFluidHelper.getFluidFromPotion((Potion)mix.from.get(), 750));
        BREW_INGREDIENTS = Util.memoize(brew -> PotionFluidHelper.getPotionFluidIngredientFrom(brew.getInput(), 750));
    }
}

