/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNet;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyRoutePath;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class EnergyNetHandler
implements IEnergyContainer {
    private EnergyNet net;
    private boolean transfer;
    private final CableBlockEntity cable;
    private final Direction facing;

    public EnergyNetHandler(EnergyNet net, CableBlockEntity cable, Direction facing) {
        this.net = Objects.requireNonNull(net);
        this.cable = Objects.requireNonNull(cable);
        this.facing = facing;
    }

    public EnergyNet getNet() {
        return this.net;
    }

    public void updateNetwork(EnergyNet net) {
        this.net = net;
    }

    @Override
    public long getEnergyCanBeInserted() {
        return this.getEnergyCapacity();
    }

    @Override
    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        if (this.transfer) {
            return 0L;
        }
        if (side == null) {
            if (this.facing == null) {
                return 0L;
            }
            side = this.facing;
        }
        long amperesUsed = 0L;
        for (EnergyRoutePath path : this.net.getNetData(this.cable.getPipePos())) {
            Direction facing;
            IEnergyContainer dest;
            if (path.getMaxLoss() >= voltage || this.cable.getPipePos().equals((Object)path.getTargetPipePos()) && side == path.getTargetFacing() || (dest = path.getHandler((Level)this.getNet().getLevel())) == null || !dest.inputsEnergy(facing = path.getTargetFacing().getOpposite()) || dest.getEnergyCanBeInserted() <= 0L) continue;
            long pathVoltage = voltage - path.getMaxLoss();
            boolean cableBroken = false;
            for (CableBlockEntity cable : path.getPath()) {
                if (cable.getMaxVoltage() >= voltage) continue;
                int heat = (int)(Math.log(GTUtil.getTierByVoltage(voltage) - GTUtil.getTierByVoltage(cable.getMaxVoltage())) * 45.0 + 36.5);
                cable.applyHeat(heat);
                cableBroken = cable.isInValid();
                if (cableBroken) break;
                pathVoltage = Math.min(cable.getMaxVoltage(), pathVoltage);
            }
            if (cableBroken) continue;
            this.transfer = true;
            long amps = dest.acceptEnergyFromNetwork(facing, pathVoltage, amperage - amperesUsed);
            this.transfer = false;
            if (amps == 0L) continue;
            amperesUsed += amps;
            long voltageTraveled = voltage;
            for (CableBlockEntity cable : path.getPath()) {
                if ((voltageTraveled -= (long)((WireProperties)cable.getNodeData()).getLossPerBlock()) <= 0L) break;
                if (cable.isInValid()) continue;
                cable.incrementAmperage(amps, voltageTraveled);
            }
            if (amperage != amperesUsed) continue;
            break;
        }
        this.net.addEnergyFluxPerSec(amperesUsed * voltage);
        return amperesUsed;
    }

    private void burnCable(ServerLevel serverLevel, BlockPos pos) {
        serverLevel.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
        if (!this.getNet().getLevel().isClientSide) {
            this.getNet().getLevel().sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5 + this.getNet().getLevel().random.nextInt(3), 0.0, 0.0, 0.0, 0.1);
        }
    }

    @Override
    public long getInputAmperage() {
        return ((WireProperties)this.cable.getNodeData()).getAmperage();
    }

    @Override
    public long getInputVoltage() {
        return ((WireProperties)this.cable.getNodeData()).getVoltage();
    }

    @Override
    public long getEnergyCapacity() {
        return this.getInputVoltage() * this.getInputAmperage();
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        GTCEu.LOGGER.warn("Do not use changeEnergy() for cables! Use acceptEnergyFromNetwork()");
        return this.acceptEnergyFromNetwork(null, energyToAdd / this.getInputAmperage(), energyToAdd / this.getInputVoltage()) * this.getInputVoltage();
    }

    @Override
    public boolean outputsEnergy(Direction side) {
        return true;
    }

    @Override
    public boolean inputsEnergy(Direction side) {
        return true;
    }

    @Override
    public long getEnergyStored() {
        return 0L;
    }

    @Override
    public boolean isOneProbeHidden() {
        return true;
    }
}

