/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import net.minecraft.world.level.Level;

public class PerTickLongCounter {
    private final long defaultValue;
    private long lastUpdatedWorldTime;
    private long lastValue;
    private long currentValue;

    public PerTickLongCounter() {
        this(0L);
    }

    public PerTickLongCounter(long defaultValue) {
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.lastValue = defaultValue;
    }

    private void checkValueState(Level world) {
        if (world == null) {
            return;
        }
        long currentWorldTime = world.getGameTime();
        if (currentWorldTime != this.lastUpdatedWorldTime) {
            this.lastValue = currentWorldTime == this.lastUpdatedWorldTime + 1L ? this.currentValue : this.defaultValue;
            this.lastUpdatedWorldTime = currentWorldTime;
            this.currentValue = this.defaultValue;
        }
    }

    public long get(Level world) {
        this.checkValueState(world);
        return this.currentValue;
    }

    public long getLast(Level world) {
        this.checkValueState(world);
        return this.lastValue;
    }

    public void increment(Level world, long value) {
        this.checkValueState(world);
        this.currentValue += value;
    }

    public void set(Level world, long value) {
        this.checkValueState(world);
        this.currentValue = value;
    }
}

