/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.duct;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IHazardParticleContainer;
import com.gregtechceu.gtceu.api.pipenet.IRoutePath;
import com.gregtechceu.gtceu.common.blockentity.DuctPipeBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeProperties;
import com.gregtechceu.gtceu.utils.FacingPos;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuctRoutePath
implements IRoutePath<IHazardParticleContainer> {
    private final DuctPipeBlockEntity targetPipe;
    @NotNull
    private final Direction targetFacing;
    private final int distance;
    private final DuctPipeProperties properties;

    public DuctRoutePath(DuctPipeBlockEntity targetPipe, @NotNull Direction facing, int distance, DuctPipeProperties properties) {
        this.targetPipe = targetPipe;
        this.targetFacing = facing;
        this.distance = distance;
        this.properties = properties;
    }

    @Override
    @NotNull
    public BlockPos getTargetPipePos() {
        return this.targetPipe.getPipePos();
    }

    @Override
    @Nullable
    public IHazardParticleContainer getHandler(Level world) {
        return GTCapabilityHelper.getHazardContainer(world, this.getTargetPipePos().relative(this.targetFacing), this.targetFacing.getOpposite());
    }

    public FacingPos toFacingPos() {
        return new FacingPos(this.getTargetPipePos(), this.targetFacing);
    }

    @Generated
    public DuctPipeBlockEntity getTargetPipe() {
        return this.targetPipe;
    }

    @Override
    @NotNull
    @Generated
    public Direction getTargetFacing() {
        return this.targetFacing;
    }

    @Override
    @Generated
    public int getDistance() {
        return this.distance;
    }

    @Generated
    public DuctPipeProperties getProperties() {
        return this.properties;
    }
}

