/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.valueprovider;

import com.gregtechceu.gtceu.common.data.GTValueProviderTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;
import org.jetbrains.annotations.NotNull;

public class AddedFloat
extends FloatProvider {
    public static final Codec<AddedFloat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FloatProvider.CODEC.fieldOf("source").forGetter(provider -> provider.source), (App)FloatProvider.CODEC.fieldOf("modifier").forGetter(provider -> provider.modifier)).apply((Applicative)instance, AddedFloat::new));
    private final FloatProvider source;
    private final FloatProvider modifier;

    public static AddedFloat of(FloatProvider source, FloatProvider multiplier) {
        return new AddedFloat(source, multiplier);
    }

    public AddedFloat(FloatProvider source, FloatProvider modifier) {
        this.source = source;
        this.modifier = modifier;
    }

    public float sample(@NotNull RandomSource random) {
        return this.source.sample(random) + this.modifier.sample(random);
    }

    public float getMinValue() {
        return this.source.getMinValue() + this.modifier.getMinValue();
    }

    public float getMaxValue() {
        float f;
        float f2 = this.source.getMaxValue();
        FloatProvider floatProvider = this.modifier;
        if (floatProvider instanceof ConstantFloat) {
            ConstantFloat c = (ConstantFloat)floatProvider;
            f = c.getValue();
        } else {
            f = this.modifier.getMaxValue();
        }
        return f2 + f;
    }

    @NotNull
    public FloatProviderType<?> getType() {
        return (FloatProviderType)GTValueProviderTypes.ADDED.get();
    }
}

