/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.forge.GTClientFluidTypeExtensions;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.BlockBehaviourAccessor;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.Tags;

public class MixinHelpers {
    private static final VanillaBlockLoot BLOCK_LOOT = new VanillaBlockLoot();

    public static <T> void generateGTDynamicTags(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagMap, Registry<T> registry) {
        block9: {
            block10: {
                block8: {
                    if (registry != BuiltInRegistries.ITEM) break block8;
                    ItemMaterialData.MATERIAL_ENTRY_ITEM_MAP.forEach((entry, itemLikes) -> {
                        if (itemLikes.isEmpty()) {
                            return;
                        }
                        Material material = entry.material();
                        if (material.isNull()) {
                            return;
                        }
                        ArrayList entries = itemLikes.stream().map(MixinHelpers::makeItemEntry).collect(MixinHelpers.toArrayList());
                        TagKey<Item>[] prefixTagKeys = entry.tagPrefix().getAllItemTags(material);
                        for (TagKey<Item> prefixTag : prefixTagKeys) {
                            tagMap.computeIfAbsent(prefixTag.location(), path -> new ArrayList()).addAll(entries);
                        }
                        for (TagKey tagKey : material.getItemTags()) {
                            tagMap.computeIfAbsent(tagKey.location(), path -> new ArrayList()).addAll(entries);
                        }
                        if (entry.tagPrefix() == TagPrefix.crushed && material.hasProperty(PropertyKey.ORE)) {
                            OreProperty ore = material.getProperty(PropertyKey.ORE);
                            Material material2 = (Material)ore.getWashedIn().first();
                            if (material2.isNull()) {
                                return;
                            }
                            ResourceLocation generalTag = CustomTags.CHEM_BATH_WASHABLE.location();
                            ResourceLocation specificTag = generalTag.withSuffix("/" + material2.getName());
                            tagMap.computeIfAbsent(generalTag, path -> new ArrayList()).addAll(entries);
                            tagMap.computeIfAbsent(specificTag, path -> new ArrayList()).addAll(entries);
                        }
                    });
                    GTMaterialItems.TOOL_ITEMS.rowMap().forEach((material, map) -> map.values().forEach(item -> {
                        if (item == null) {
                            return;
                        }
                        TagLoader.EntryWithSource entry = MixinHelpers.makeItemEntry((ItemLike)item);
                        for (TagKey<Item> tag : ((IGTTool)item.get()).getToolType().itemTags) {
                            tagMap.computeIfAbsent(tag.location(), path -> new ArrayList()).add(entry);
                        }
                    }));
                    GTMaterialItems.ARMOR_ITEMS.rowMap().forEach((material, map) -> map.forEach((type, item) -> {
                        if (item != null) {
                            TagLoader.EntryWithSource entry = new TagLoader.EntryWithSource(TagEntry.element((ResourceLocation)item.getId()), "GTCEu Custom Tags");
                            tagMap.computeIfAbsent(ItemTags.TRIMMABLE_ARMOR.location(), $ -> new ArrayList()).add(entry);
                            tagMap.computeIfAbsent(switch (type) {
                                default -> throw new IncompatibleClassChangeError();
                                case ArmorItem.Type.HELMET -> Tags.Items.ARMORS_HELMETS.location();
                                case ArmorItem.Type.CHESTPLATE -> Tags.Items.ARMORS_CHESTPLATES.location();
                                case ArmorItem.Type.LEGGINGS -> Tags.Items.ARMORS_LEGGINGS.location();
                                case ArmorItem.Type.BOOTS -> Tags.Items.ARMORS_BOOTS.location();
                            }, $ -> new ArrayList()).add(entry);
                        }
                    }));
                    if (!GTCEu.Mods.isAE2Loaded()) {
                        return;
                    }
                    ResourceLocation p2pFluidAttunements = new ResourceLocation("ae2", "p2p_attunements/fluid_p2p_tunnel");
                    for (Material material2 : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                        FluidProperty property = material2.getProperty(PropertyKey.FLUID);
                        if (property == null) continue;
                        for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                            Fluid fluid = property.get(key);
                            if (fluid == null || fluid.getBucket() == Items.AIR) continue;
                            TagLoader.EntryWithSource entry2 = MixinHelpers.makeItemEntry((ItemLike)fluid.getBucket());
                            tagMap.computeIfAbsent(p2pFluidAttunements, path -> new ArrayList()).add(entry2);
                        }
                    }
                    break block9;
                }
                if (registry != BuiltInRegistries.BLOCK) break block10;
                ItemMaterialData.MATERIAL_ENTRY_BLOCK_MAP.forEach((entry, blocks) -> {
                    if (blocks.isEmpty()) {
                        return;
                    }
                    Material material = entry.material();
                    if (material.isNull()) {
                        return;
                    }
                    ArrayList entries = blocks.stream().map(MixinHelpers::makeBlockEntry).collect(MixinHelpers.toArrayList());
                    TagKey<Block>[] materialTags = entry.tagPrefix().getAllBlockTags(material);
                    for (TagKey<Block> materialTag : materialTags) {
                        tagMap.computeIfAbsent(materialTag.location(), path -> new ArrayList()).addAll(entries);
                    }
                    if (!entry.isIgnored() && !entry.tagPrefix().miningToolTag().isEmpty()) {
                        tagMap.computeIfAbsent(CustomTags.TOOL_TIERS[material.getBlockHarvestLevel()].location(), path -> new ArrayList()).addAll(entries);
                        if (material.hasProperty(PropertyKey.WOOD)) {
                            if (entry.tagPrefix().miningToolTag().contains(CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH)) {
                                tagMap.computeIfAbsent(CustomTags.MINEABLE_WITH_WRENCH.location(), path -> new ArrayList()).addAll(entries);
                                if (!ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) {
                                    tagMap.computeIfAbsent(BlockTags.MINEABLE_WITH_AXE.location(), path -> new ArrayList()).addAll(entries);
                                }
                            } else {
                                tagMap.computeIfAbsent(BlockTags.MINEABLE_WITH_AXE.location(), path -> new ArrayList()).addAll(entries);
                            }
                        } else {
                            for (TagKey tagKey : entry.tagPrefix().miningToolTag()) {
                                tagMap.computeIfAbsent(tagKey.location(), path -> new ArrayList()).addAll(entries);
                            }
                        }
                    }
                    if (entry.tagPrefix() == TagPrefix.frameGt) {
                        tagMap.computeIfAbsent(CustomTags.SLOW_WALKABLE_BLOCKS.location(), path -> new ArrayList()).addAll(entries);
                    }
                });
                GTRegistries.MACHINES.forEach(machine -> tagMap.computeIfAbsent(CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH.location(), path -> new ArrayList()).add(MixinHelpers.makeBlockEntry(machine.getBlock())));
                if (ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) break block9;
                List tagList = tagMap.computeIfAbsent(BlockTags.MINEABLE_WITH_PICKAXE.location(), path -> new ArrayList());
                tagList.add(MixinHelpers.makeTagEntry(CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH));
                tagList.add(MixinHelpers.makeTagEntry(CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WIRE_CUTTER));
                break block9;
            }
            if (registry == BuiltInRegistries.FLUID) {
                for (Material material3 : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                    FluidProperty property = material3.getProperty(PropertyKey.FLUID);
                    if (property == null) continue;
                    for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                        FluidState state;
                        Fluid fluid = property.get(key);
                        if (fluid == null) continue;
                        ItemMaterialData.FLUID_MATERIAL.put(fluid, material3);
                        TagLoader.EntryWithSource entry3 = MixinHelpers.makeFluidEntry(fluid);
                        ResourceLocation fluidIdTag = fluid.builtInRegistryHolder().key().location();
                        fluidIdTag = new ResourceLocation("forge", fluidIdTag.getPath());
                        tagMap.computeIfAbsent(fluidIdTag, path -> new ArrayList()).add(entry3);
                        if (fluid instanceof GTFluid) {
                            GTFluid gtFluid = (GTFluid)fluid;
                            state = gtFluid.getState();
                        } else {
                            state = key.getDefaultFluidState();
                        }
                        tagMap.computeIfAbsent(state.getTagKey().location(), path -> new ArrayList()).add(entry3);
                        if (key.getExtraTag() == null) continue;
                        tagMap.computeIfAbsent(key.getExtraTag().location(), path -> new ArrayList()).add(entry3);
                    }
                }
            }
        }
    }

    private static <T> Collector<T, ?, ArrayList<T>> toArrayList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static TagLoader.EntryWithSource makeItemEntry(Supplier<? extends Item> item) {
        return MixinHelpers.makeItemEntry((ItemLike)item.get());
    }

    public static TagLoader.EntryWithSource makeItemEntry(ItemLike item) {
        return MixinHelpers.makeElementEntry(item.asItem().builtInRegistryHolder().key().location());
    }

    public static TagLoader.EntryWithSource makeBlockEntry(Supplier<? extends Block> block) {
        return MixinHelpers.makeBlockEntry(block.get());
    }

    public static TagLoader.EntryWithSource makeBlockEntry(Block block) {
        return MixinHelpers.makeElementEntry(block.builtInRegistryHolder().key().location());
    }

    public static TagLoader.EntryWithSource makeFluidEntry(Fluid fluid) {
        return MixinHelpers.makeElementEntry(fluid.builtInRegistryHolder().key().location());
    }

    public static TagLoader.EntryWithSource makeElementEntry(ResourceLocation id) {
        return new TagLoader.EntryWithSource(TagEntry.element((ResourceLocation)id), "GTCEu Custom Tags");
    }

    public static TagLoader.EntryWithSource makeTagEntry(TagKey<?> tag) {
        return new TagLoader.EntryWithSource(TagEntry.tag((ResourceLocation)tag.location()), "GTCEu Custom Tags");
    }

    public static void generateGTDynamicLoot(Map<ResourceLocation, LootTable> lootTables) {
        GTMaterialBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> {
            if (TagPrefix.ORES.containsKey(prefix)) {
                TagPrefix.OreType type = TagPrefix.ORES.get(prefix);
                map.forEach((material, blockEntry) -> {
                    ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().getNamespace(), "blocks/" + blockEntry.getId().getPath());
                    Block block = (Block)blockEntry.get();
                    ItemStack dropItem = ChemicalHelper.get(TagPrefix.rawOre, material);
                    if (dropItem.isEmpty()) {
                        dropItem = ChemicalHelper.get(TagPrefix.gem, material);
                    }
                    if (dropItem.isEmpty()) {
                        dropItem = ChemicalHelper.get(TagPrefix.dust, material);
                    }
                    int oreMultiplier = type.isDoubleDrops() ? 2 : 1;
                    LootTable.Builder builder = BlockLootSubProvider.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)BLOCK_LOOT.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)dropItem.getItem()).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)oreMultiplier))))));
                    LootPool.Builder pool = LootPool.lootPool();
                    boolean isEmpty = true;
                    for (MaterialStack secondaryMaterial : prefix.secondaryMaterials()) {
                        if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                        ItemStack dustStack = ChemicalHelper.getGem(secondaryMaterial);
                        pool.add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)dustStack.getItem()).when(BlockLootSubProvider.HAS_NO_SILK_TOUCH)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.range((int)0, (int)2))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()));
                        isEmpty = false;
                    }
                    if (!isEmpty) {
                        builder.withPool(pool);
                    }
                    lootTables.put(lootTableId, builder.setParamSet(LootContextParamSets.BLOCK).build());
                    ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
                });
            } else {
                MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map);
            }
        });
        GTMaterialBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTMaterialBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTMaterialBlocks.ITEM_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTMaterialBlocks.SURFACE_ROCK_BLOCKS.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().getNamespace(), "blocks/" + blockEntry.getId().getPath());
            LootTable.Builder builder = BLOCK_LOOT.createSingleItemTable((ItemLike)ChemicalHelper.get(TagPrefix.dustTiny, material).getItem(), (NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE));
            lootTables.put(lootTableId, builder.setParamSet(LootContextParamSets.BLOCK).build());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
        });
        GTRegistries.MACHINES.forEach(machine -> {
            Block block = machine.getBlock();
            ResourceLocation id = machine.getId();
            ResourceLocation lootTableId = new ResourceLocation(id.getNamespace(), "blocks/" + id.getPath());
            ((BlockBehaviourAccessor)block).setDrops(lootTableId);
            lootTables.put(lootTableId, BLOCK_LOOT.createSingleItemTable((ItemLike)block).setParamSet(LootContextParamSets.BLOCK).build());
        });
    }

    public static void addMaterialBlockLootTables(Map<ResourceLocation, LootTable> lootTables, TagPrefix prefix, Map<Material, ? extends BlockEntry<? extends Block>> map) {
        map.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().getNamespace(), "blocks/" + blockEntry.getId().getPath());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
            lootTables.put(lootTableId, BLOCK_LOOT.createSingleItemTable((ItemLike)blockEntry.get()).setParamSet(LootContextParamSets.BLOCK).build());
        });
    }

    public static void addFluidTexture(Material material, FluidStorage.FluidEntry value) {
        IClientFluidTypeExtensions extensions;
        if (value != null && (extensions = IClientFluidTypeExtensions.of((Fluid)value.getFluid().get())) instanceof GTClientFluidTypeExtensions) {
            GTClientFluidTypeExtensions gtExtensions = (GTClientFluidTypeExtensions)extensions;
            if (value.getBuilder() != null) {
                gtExtensions.setFlowingTexture(value.getBuilder().flowing());
                gtExtensions.setStillTexture(value.getBuilder().still());
            }
        }
    }
}

