/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.pack;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.pack.GTDynamicDataPack;
import com.gregtechceu.gtceu.data.pack.GTDynamicPackContents;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTDynamicResourcePack
implements PackResources {
    protected static final ObjectSet<String> CLIENT_DOMAINS = new ObjectOpenHashSet();
    protected static final GTDynamicPackContents CONTENTS = new GTDynamicPackContents();
    private static final FileToIdConverter ATLAS_ID_CONVERTER = FileToIdConverter.json((String)"atlases");
    private static final FileToIdConverter TEXTURE_ID_CONVERTER = SpriteSource.TEXTURE_ID_CONVERTER;
    private static final FileToIdConverter BLOCKSTATE_ID_CONVERTER = FileToIdConverter.json((String)"blockstates");
    private static final FileToIdConverter BLOCK_MODEL_ID_CONVERTER = FileToIdConverter.json((String)"models/block");
    private static final FileToIdConverter ITEM_MODEL_ID_CONVERTER = FileToIdConverter.json((String)"models/item");
    private final String name;

    public GTDynamicResourcePack(String name) {
        this(name, AddonFinder.getAddons().stream().map(IGTAddon::addonModId).collect(Collectors.toSet()));
    }

    public GTDynamicResourcePack(String name, Collection<String> domains) {
        this.name = name;
        CLIENT_DOMAINS.addAll(domains);
    }

    public static void clearClient() {
        CONTENTS.clearData();
    }

    public static void addResource(ResourceLocation location, JsonElement obj) {
        GTDynamicResourcePack.addResource(location, obj.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void addResource(ResourceLocation location, byte[] data) {
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(location, null, parent, data);
        }
        CONTENTS.addToData(location, data);
    }

    public static void addBlockModel(ResourceLocation loc, JsonElement obj) {
        ResourceLocation l = GTDynamicResourcePack.getBlockModelLocation(loc);
        byte[] modelBytes = obj.toString().getBytes(StandardCharsets.UTF_8);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, modelBytes);
        }
        CONTENTS.addToData(l, modelBytes);
    }

    public static void addBlockModel(ResourceLocation loc, Supplier<JsonElement> obj) {
        GTDynamicResourcePack.addBlockModel(loc, obj.get());
    }

    public static void addItemModel(ResourceLocation loc, JsonElement obj) {
        ResourceLocation l = GTDynamicResourcePack.getItemModelLocation(loc);
        byte[] modelBytes = obj.toString().getBytes(StandardCharsets.UTF_8);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, modelBytes);
        }
        CONTENTS.addToData(l, modelBytes);
    }

    public static void addItemModel(ResourceLocation loc, Supplier<JsonElement> obj) {
        GTDynamicResourcePack.addItemModel(loc, obj.get());
    }

    public static void addBlockState(ResourceLocation loc, JsonElement stateJson) {
        ResourceLocation l = GTDynamicResourcePack.getBlockStateLocation(loc);
        byte[] stateBytes = stateJson.toString().getBytes(StandardCharsets.UTF_8);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, stateBytes);
        }
        CONTENTS.addToData(l, stateBytes);
    }

    public static void addBlockState(ResourceLocation loc, Supplier<JsonElement> generator) {
        GTDynamicResourcePack.addBlockState(loc, generator.get());
    }

    public static void addAtlasSpriteSource(ResourceLocation atlasLoc, SpriteSource source) {
        ResourceLocation l = GTDynamicResourcePack.getAtlasLocation(atlasLoc);
        JsonElement sourceJson = (JsonElement)SpriteSources.FILE_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, Collections.singletonList(source)).getOrThrow(false, error -> GTCEu.LOGGER.error("Failed to encode atlas sprite source. {}", error));
        byte[] sourceBytes = sourceJson.toString().getBytes(StandardCharsets.UTF_8);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, sourceBytes);
        }
        CONTENTS.addToData(l, sourceBytes);
    }

    public static void addAtlasSpriteSourceList(ResourceLocation atlasLoc, List<SpriteSource> sources) {
        ResourceLocation l = GTDynamicResourcePack.getAtlasLocation(atlasLoc);
        JsonElement sourceJson = (JsonElement)SpriteSources.FILE_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, sources).getOrThrow(false, error -> GTCEu.LOGGER.error("Failed to encode atlas sprite source. {}", error));
        byte[] sourceBytes = sourceJson.toString().getBytes(StandardCharsets.UTF_8);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, sourceBytes);
        }
        CONTENTS.addToData(l, sourceBytes);
    }

    public static void addBlockTexture(ResourceLocation loc, byte[] data) {
        ResourceLocation l = GTDynamicResourcePack.getTextureLocation("block", loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicResourcePack.writeByteArray(l, null, parent, data);
        }
        CONTENTS.addToData(l, data);
    }

    public static void addItemTexture(ResourceLocation loc, byte[] data) {
        ResourceLocation l = GTDynamicResourcePack.getTextureLocation("item", loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/assets");
            GTDynamicResourcePack.writeByteArray(l, null, parent, data);
        }
        CONTENTS.addToData(l, data);
    }

    @ApiStatus.Internal
    public static void writeByteArray(ResourceLocation id, @Nullable String subdir, Path parent, byte[] data) {
        try {
            Path file = subdir != null ? parent.resolve(id.getNamespace()).resolve(subdir).resolve(id.getPath() + ".png") : parent.resolve(id.getNamespace()).resolve(id.getPath());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            GTCEu.LOGGER.error("Failed to write JSON export for file {}", (Object)id, (Object)e);
        }
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... elements) {
        if (elements.length > 0 && elements[0].equals("pack.png")) {
            return () -> GTCEu.class.getResourceAsStream("/icon.png");
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        if (type == PackType.CLIENT_RESOURCES) {
            return CONTENTS.getResource(location);
        }
        return null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (packType == PackType.CLIENT_RESOURCES) {
            CONTENTS.listResources(namespace, path, resourceOutput);
        }
    }

    public Set<String> getNamespaces(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? CLIENT_DOMAINS : Set.of();
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> metaReader) {
        if (metaReader == PackMetadataSection.TYPE) {
            return (T)new PackMetadataSection((Component)Component.literal((String)"GTCEu dynamic assets"), SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES));
        }
        return null;
    }

    public String packId() {
        return this.name;
    }

    public boolean isBuiltin() {
        return true;
    }

    public void close() {
    }

    public static ResourceLocation getBlockStateLocation(ResourceLocation blockId) {
        return BLOCKSTATE_ID_CONVERTER.idToFile(blockId);
    }

    public static ResourceLocation getBlockModelLocation(ResourceLocation blockId) {
        return BLOCK_MODEL_ID_CONVERTER.idToFile(blockId);
    }

    public static ResourceLocation getItemModelLocation(ResourceLocation itemId) {
        return ITEM_MODEL_ID_CONVERTER.idToFile(itemId);
    }

    public static ResourceLocation getTextureLocation(@Nullable String path, ResourceLocation textureId) {
        if (path == null) {
            return TEXTURE_ID_CONVERTER.idToFile(textureId);
        }
        return TEXTURE_ID_CONVERTER.idToFile(textureId.withPrefix(path + "/"));
    }

    public static ResourceLocation getAtlasLocation(ResourceLocation atlasId) {
        return ATLAS_ID_CONVERTER.idToFile(atlasId);
    }

    static {
        CLIENT_DOMAINS.addAll((Collection)Sets.newHashSet((Object[])new String[]{"gtceu", "minecraft", "forge", "c"}));
    }
}

