/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTMath;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public final class DecompositionRecipeHandler {
    private DecompositionRecipeHandler() {
    }

    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        DecompositionRecipeHandler.processDecomposition(provider, material);
    }

    private static void processDecomposition(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        GTRecipeBuilder builder;
        if (material.getMaterialComponents().isEmpty() || !material.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) && !material.hasFlag(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING) || material.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION) || material.getMaterialComponents().size() > 6) {
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        long totalInputAmount = 0L;
        for (MaterialStack component : material.getMaterialComponents()) {
            totalInputAmount += component.amount();
            if (component.material().hasProperty(PropertyKey.DUST)) {
                outputs.add(ChemicalHelper.get(TagPrefix.dust, component.material(), (int)component.amount()));
                continue;
            }
            if (!component.material().hasProperty(PropertyKey.FLUID)) continue;
            fluidOutputs.add(component.material().getFluid((int)(1000L * component.amount())));
        }
        boolean hasDust = material.hasProperty(PropertyKey.DUST);
        if (hasDust) {
            LongArrayList materialAmounts = new LongArrayList();
            materialAmounts.add(totalInputAmount);
            outputs.forEach(arg_0 -> DecompositionRecipeHandler.lambda$processDecomposition$0((LongList)materialAmounts, arg_0));
            fluidOutputs.forEach(arg_0 -> DecompositionRecipeHandler.lambda$processDecomposition$1((LongList)materialAmounts, arg_0));
            int highestDivisor = 1;
            long smallestMaterialAmount = materialAmounts.longStream().min().orElse(0L);
            int i = 2;
            while ((long)i <= smallestMaterialAmount) {
                if (DecompositionRecipeHandler.isEveryMaterialReducible(i, (LongList)materialAmounts)) {
                    highestDivisor = i;
                }
                ++i;
            }
            if (highestDivisor != 1) {
                ArrayList<ItemStack> reducedOutputs = new ArrayList<ItemStack>();
                for (ItemStack itemStack : outputs) {
                    ItemStack reducedStack = itemStack.copy();
                    reducedStack.setCount(reducedStack.getCount() / highestDivisor);
                    reducedOutputs.add(reducedStack);
                }
                ArrayList<FluidStack> reducedFluidOutputs = new ArrayList<FluidStack>();
                for (FluidStack fluidStack : fluidOutputs) {
                    FluidStack reducedFluidStack = fluidStack.copy();
                    reducedFluidStack.setAmount(reducedFluidStack.getAmount() / highestDivisor);
                    reducedFluidOutputs.add(reducedFluidStack);
                }
                outputs = reducedOutputs;
                fluidOutputs = reducedFluidOutputs;
                totalInputAmount /= (long)highestDivisor;
            }
        }
        if (material.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING)) {
            long dura = material.getProtons() * totalInputAmount * 2L;
            builder = GTRecipeTypes.ELECTROLYZER_RECIPES.recipeBuilder("decomposition_electrolyzing", material.getName()).duration(GTMath.saturatedCast(dura)).EUt(material.getMaterialComponents().size() <= 2 ? (long)GTValues.VA[1] : 2L * (long)GTValues.VA[1]);
        } else {
            builder = GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("decomposition_centrifuging_", material.getName()).duration((int)Math.ceil((double)(material.getMass() * totalInputAmount) * 1.5)).EUt(GTValues.VA[1]);
        }
        builder.outputItems((ItemStack[])outputs.toArray(ItemStack[]::new));
        builder.outputFluids((FluidStack[])fluidOutputs.toArray(FluidStack[]::new));
        if (hasDust) {
            builder.inputItems(TagPrefix.dust, material, GTMath.saturatedCast(totalInputAmount));
        } else {
            builder.inputFluids(material.getFluid(1000));
        }
        builder.save(provider);
    }

    private static boolean isEveryMaterialReducible(int divisor, LongList materialAmounts) {
        LongListIterator it = materialAmounts.iterator();
        while (it.hasNext()) {
            long amount = it.nextLong();
            if (amount % (long)divisor == 0L) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$processDecomposition$1(LongList materialAmounts, FluidStack fluidStack) {
        materialAmounts.add((long)fluidStack.getAmount() / 1000L);
    }

    private static /* synthetic */ void lambda$processDecomposition$0(LongList materialAmounts, ItemStack itemStack) {
        materialAmounts.add((long)itemStack.getCount());
    }
}

