/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class DecorationRecipes {
    private static final String[] OXIDATION_STAGES = new String[]{"raw", "exposed", "weathered", "oxidized"};

    private DecorationRecipes() {
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        DecorationRecipes.assemblerRecipes(provider);
        DecorationRecipes.dyeRecipes(provider);
        DecorationRecipes.copperOxidationRecipes(provider);
    }

    private static void assemblerRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("metal_sheet_white").inputItems(TagPrefix.block, GTMaterials.Concrete, 5).inputItems(TagPrefix.plate, GTMaterials.Iron, 2).circuitMeta(8).outputItems((Supplier)GTBlocks.METAL_SHEETS.get(DyeColor.WHITE), 32).EUt(4L).duration(20).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("large_metal_sheet_white").inputItems(TagPrefix.block, GTMaterials.Concrete, 5).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(9).outputItems((Supplier)GTBlocks.LARGE_METAL_SHEETS.get(DyeColor.WHITE), 32).EUt(4L).duration(20).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("studs_black").inputItems(TagPrefix.block, GTMaterials.Concrete, 3).inputItems(TagPrefix.plate, GTMaterials.Rubber, 3).circuitMeta(8).outputItems((Supplier)GTBlocks.STUDS.get(DyeColor.BLACK), 32).EUt(4L).duration(20).addMaterialInfo(true).save(provider);
    }

    private static void dyeRecipes(Consumer<FinishedRecipe> provider) {
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            DyeColor color = DyeColor.values()[i];
            String colorName = color.getName();
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("metal_sheet_%s".formatted(colorName)).inputItems(GTBlocks.METAL_SHEETS.get(DyeColor.WHITE).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.METAL_SHEETS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("large_metal_sheet_%s".formatted(colorName)).inputItems(GTBlocks.LARGE_METAL_SHEETS.get(DyeColor.WHITE).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.LARGE_METAL_SHEETS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("studs_%s".formatted(colorName)).inputItems(GTBlocks.STUDS.get(DyeColor.BLACK).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.STUDS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
        }
    }

    private static void copperOxidationRecipes(Consumer<FinishedRecipe> provider) {
        DecorationRecipes.registerOxidationChain(provider, "copper_block", Items.COPPER_BLOCK, Items.EXPOSED_COPPER, Items.WEATHERED_COPPER, Items.OXIDIZED_COPPER);
        DecorationRecipes.registerOxidationChain(provider, "cut_copper", Items.CUT_COPPER, Items.EXPOSED_CUT_COPPER, Items.WEATHERED_CUT_COPPER, Items.OXIDIZED_CUT_COPPER);
        DecorationRecipes.registerOxidationChain(provider, "cut_copper_stairs", Items.CUT_COPPER_STAIRS, Items.EXPOSED_CUT_COPPER_STAIRS, Items.WEATHERED_CUT_COPPER_STAIRS, Items.OXIDIZED_CUT_COPPER_STAIRS);
        DecorationRecipes.registerOxidationChain(provider, "cut_copper_slab", Items.CUT_COPPER_SLAB, Items.EXPOSED_CUT_COPPER_SLAB, Items.WEATHERED_CUT_COPPER_SLAB, Items.OXIDIZED_CUT_COPPER_SLAB);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_copper_block").inputItems(Items.COPPER_BLOCK).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_COPPER_BLOCK).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_exposed_copper").inputItems(Items.EXPOSED_COPPER).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_EXPOSED_COPPER).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_weathered_copper").inputItems(Items.WEATHERED_COPPER).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_WEATHERED_COPPER).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_oxidized_copper").inputItems(Items.OXIDIZED_COPPER).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_OXIDIZED_COPPER).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_cut_copper").inputItems(Items.CUT_COPPER).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_CUT_COPPER).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_exposed_cut_copper").inputItems(Items.EXPOSED_CUT_COPPER).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_EXPOSED_CUT_COPPER).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_weathered_cut_copper").inputItems(Items.WEATHERED_CUT_COPPER).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_WEATHERED_CUT_COPPER).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_oxidized_cut_copper").inputItems(Items.OXIDIZED_CUT_COPPER).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_OXIDIZED_CUT_COPPER).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_cut_copper_stairs").inputItems(Items.CUT_COPPER_STAIRS).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_CUT_COPPER_STAIRS).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_exposed_cut_copper_stairs").inputItems(Items.EXPOSED_CUT_COPPER_STAIRS).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_EXPOSED_CUT_COPPER_STAIRS).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_weathered_cut_copper_stairs").inputItems(Items.WEATHERED_CUT_COPPER_STAIRS).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_WEATHERED_CUT_COPPER_STAIRS).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_oxidized_cut_copper_stairs").inputItems(Items.OXIDIZED_CUT_COPPER_STAIRS).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_OXIDIZED_CUT_COPPER_STAIRS).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_cut_copper_slab").inputItems(Items.CUT_COPPER_SLAB).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_CUT_COPPER_SLAB).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_exposed_cut_copper_slab").inputItems(Items.EXPOSED_CUT_COPPER_SLAB).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_EXPOSED_CUT_COPPER_SLAB).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_weathered_cut_copper_slab").inputItems(Items.WEATHERED_CUT_COPPER_SLAB).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_WEATHERED_CUT_COPPER_SLAB).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_oxidized_cut_copper_slab").inputItems(Items.OXIDIZED_CUT_COPPER_SLAB).inputFluids(GTMaterials.Wax, 72).outputItems(Items.WAXED_OXIDIZED_CUT_COPPER_SLAB).EUt(GTValues.VA[0]).duration(10).save(provider);
    }

    private static void registerOxidationChain(Consumer<FinishedRecipe> provider, String name, Item ... items) {
        for (int i = 0; i < items.length - 1; ++i) {
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("%s_to_%s_%s_oxidation".formatted(OXIDATION_STAGES[i], OXIDATION_STAGES[i + 1], name)).inputItems(items[i]).inputFluids(GTMaterials.Oxygen, 100).outputItems(items[i + 1]).EUt(GTValues.VA[0]).duration(10).save(provider);
        }
    }
}

