/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.StoneTypeEntry;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class StoneMachineRecipes {
    private static List<StoneTypeEntry> DEFAULT_ENTRIES;

    public static void init(Consumer<FinishedRecipe> provider) {
        StoneMachineRecipes.registerStoneRecipes(provider);
    }

    private static List<StoneTypeEntry> getDefaultEntries() {
        if (DEFAULT_ENTRIES == null) {
            String mcModID = "minecraft";
            DEFAULT_ENTRIES = Arrays.asList(new StoneTypeEntry.Builder("minecraft", "stone").stone(Items.STONE).crackedStone(Items.COBBLESTONE).polishedStone(Items.STONE_BRICKS).slab(Items.STONE_SLAB).stair(Items.STONE_STAIRS).button(Items.STONE_BUTTON).pressurePlate(Items.STONE_PRESSURE_PLATE).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "smooth_stone").stone(Items.SMOOTH_STONE).slab(Items.SMOOTH_STONE_SLAB).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "stone_brick").stone(Items.STONE_BRICKS).crackedStone(Items.CRACKED_STONE_BRICKS).chiselStone(Items.CHISELED_STONE_BRICKS).slab(Items.STONE_BRICK_SLAB).stair(Items.STONE_BRICK_STAIRS).wall(Items.STONE_BRICK_WALL).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "andesite").stone(Items.ANDESITE).polishedStone(Items.POLISHED_ANDESITE).slab(Items.ANDESITE_SLAB).stair(Items.ANDESITE_STAIRS).wall(Items.ANDESITE_WALL).material(GTMaterials.Andesite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_andesite").stone(Items.POLISHED_ANDESITE).slab(Items.POLISHED_ANDESITE_SLAB).stair(Items.POLISHED_ANDESITE_STAIRS).material(GTMaterials.Andesite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "granite").stone(Items.GRANITE).polishedStone(Items.POLISHED_GRANITE).slab(Items.GRANITE_SLAB).stair(Items.GRANITE_STAIRS).wall(Items.GRANITE_WALL).material(GTMaterials.Granite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_granite").stone(Items.POLISHED_GRANITE).slab(Items.POLISHED_GRANITE_SLAB).stair(Items.POLISHED_GRANITE_STAIRS).material(GTMaterials.Granite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "diorite").stone(Items.DIORITE).polishedStone(Items.POLISHED_DIORITE).slab(Items.DIORITE_SLAB).stair(Items.DIORITE_STAIRS).wall(Items.DIORITE_WALL).material(GTMaterials.Diorite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_diorite").stone(Items.POLISHED_DIORITE).slab(Items.POLISHED_DIORITE_SLAB).stair(Items.POLISHED_DIORITE_STAIRS).material(GTMaterials.Diorite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "sandstone").stone(Items.SANDSTONE).polishedStone(Items.CUT_SANDSTONE).chiselStone(Items.CHISELED_SANDSTONE).slab(Items.SANDSTONE_SLAB).stair(Items.SANDSTONE_STAIRS).wall(Items.SANDSTONE_WALL).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "smooth_sandstone").stone(Items.SMOOTH_SANDSTONE).slab(Items.SMOOTH_SANDSTONE_SLAB).stair(Items.SMOOTH_SANDSTONE_STAIRS).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "cut_sandstone").stone(Items.CUT_SANDSTONE).slab(Items.CUT_STANDSTONE_SLAB).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "red_sandstone").stone(Items.RED_SANDSTONE).polishedStone(Items.CUT_RED_SANDSTONE).chiselStone(Items.CHISELED_RED_SANDSTONE).slab(Items.RED_SANDSTONE_SLAB).stair(Items.RED_SANDSTONE_STAIRS).wall(Items.RED_SANDSTONE_WALL).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "smooth_red_sandstone").stone(Items.SMOOTH_RED_SANDSTONE).slab(Items.SMOOTH_RED_SANDSTONE_SLAB).stair(Items.SMOOTH_RED_SANDSTONE_STAIRS).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "cut_red_sandstone").stone(Items.CUT_RED_SANDSTONE).slab(Items.CUT_RED_SANDSTONE_SLAB).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "cobblestone").stone(Items.COBBLESTONE).slab(Items.COBBLESTONE_SLAB).stair(Items.COBBLESTONE_STAIRS).wall(Items.COBBLESTONE_WALL).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "mossy_cobblestone").stone(Items.MOSSY_COBBLESTONE).slab(Items.MOSSY_COBBLESTONE_SLAB).stair(Items.MOSSY_COBBLESTONE_STAIRS).wall(Items.MOSSY_COBBLESTONE_WALL).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "mossy_stone_brick").stone(Items.MOSSY_STONE_BRICKS).slab(Items.MOSSY_STONE_BRICK_SLAB).stair(Items.MOSSY_STONE_BRICK_STAIRS).wall(Items.MOSSY_STONE_BRICK_WALL).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "blackstone").stone(Items.BLACKSTONE).polishedStone(Items.POLISHED_BLACKSTONE).slab(Items.BLACKSTONE_SLAB).stair(Items.BLACKSTONE_STAIRS).wall(Items.BLACKSTONE_WALL).material(GTMaterials.Blackstone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_blackstone").stone(Items.POLISHED_BLACKSTONE).polishedStone(Items.POLISHED_BLACKSTONE_BRICKS).chiselStone(Items.CHISELED_POLISHED_BLACKSTONE).crackedStone(Items.CRACKED_POLISHED_BLACKSTONE_BRICKS).slab(Items.POLISHED_BLACKSTONE_SLAB).stair(Items.POLISHED_BLACKSTONE_STAIRS).wall(Items.POLISHED_BLACKSTONE_WALL).pressurePlate(Items.POLISHED_BLACKSTONE_PRESSURE_PLATE).button(Items.POLISHED_BLACKSTONE_BUTTON).material(GTMaterials.Blackstone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_blackstone_brick").stone(Items.POLISHED_BLACKSTONE_BRICKS).slab(Items.POLISHED_BLACKSTONE_BRICK_SLAB).stair(Items.POLISHED_BLACKSTONE_BRICK_STAIRS).wall(Items.POLISHED_BLACKSTONE_BRICK_WALL).material(GTMaterials.Blackstone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "brick").stone(Items.BRICKS).slab(Items.BRICK_SLAB).stair(Items.BRICK_STAIRS).wall(Items.BRICK_WALL).material(GTMaterials.Brick, 14515200L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "mud_brick").stone(Items.MUD_BRICKS).slab(Items.MUD_BRICK_SLAB).stair(Items.MUD_BRICK_STAIRS).wall(Items.MUD_BRICK_WALL).material(GTMaterials.Clay).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "nether_bricks").stone(Items.NETHER_BRICKS).crackedStone(Items.CRACKED_NETHER_BRICKS).chiselStone(Items.CHISELED_NETHER_BRICKS).slab(Items.NETHER_BRICK_SLAB).stair(Items.NETHER_BRICK_STAIRS).wall(Items.NETHER_BRICK_WALL).material(GTMaterials.Netherrack, 14515200L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "red_nether_brick").stone(Items.RED_NETHER_BRICKS).slab(Items.RED_NETHER_BRICK_SLAB).stair(Items.RED_NETHER_BRICK_STAIRS).wall(Items.RED_NETHER_BRICK_WALL).material(GTMaterials.Netherrack).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "quartz").stone(Items.QUARTZ_BLOCK).polishedStone(Items.QUARTZ_BRICKS).chiselStone(Items.CHISELED_QUARTZ_BLOCK).stair(Items.QUARTZ_STAIRS).material(GTMaterials.NetherQuartz, 14515200L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "smooth_quartz").stone(Items.SMOOTH_QUARTZ).slab(Items.SMOOTH_QUARTZ_SLAB).stair(Items.SMOOTH_QUARTZ_STAIRS).material(GTMaterials.NetherQuartz, 14515200L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "cut_copper").stone(Items.CUT_COPPER).slab(Items.CUT_COPPER_SLAB).stair(Items.CUT_COPPER_STAIRS).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "exposed_cut_copper").stone(Items.EXPOSED_CUT_COPPER).slab(Items.EXPOSED_CUT_COPPER_SLAB).stair(Items.EXPOSED_CUT_COPPER_STAIRS).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "oxidized_cut_copper").stone(Items.OXIDIZED_CUT_COPPER).slab(Items.OXIDIZED_CUT_COPPER_SLAB).stair(Items.OXIDIZED_CUT_COPPER_STAIRS).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "weathered_cut_copper").stone(Items.WEATHERED_CUT_COPPER).slab(Items.WEATHERED_CUT_COPPER_SLAB).stair(Items.WEATHERED_CUT_COPPER_STAIRS).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "waxed_cut_copper").stone(Items.WAXED_CUT_COPPER).slab(Items.WAXED_CUT_COPPER_SLAB).stair(Items.WAXED_CUT_COPPER_STAIRS).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "waxed_exposed_cut_copper").stone(Items.WAXED_EXPOSED_CUT_COPPER).slab(Items.WAXED_EXPOSED_CUT_COPPER_SLAB).stair(Items.WAXED_EXPOSED_CUT_COPPER_STAIRS).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "waxed_oxidized_cut_copper").stone(Items.WAXED_OXIDIZED_CUT_COPPER).slab(Items.WAXED_OXIDIZED_CUT_COPPER_SLAB).stair(Items.WAXED_OXIDIZED_CUT_COPPER_STAIRS).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "waxed_weathered_cut_copper").stone(Items.WAXED_WEATHERED_CUT_COPPER).slab(Items.WAXED_WEATHERED_CUT_COPPER_SLAB).stair(Items.WAXED_WEATHERED_CUT_COPPER_STAIRS).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "purpur").stone(Items.PURPUR_BLOCK).chiselStone(Items.PURPUR_PILLAR).slab(Items.PURPUR_SLAB).stair(Items.PURPUR_STAIRS).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "end_stone").stone(Items.END_STONE).polishedStone(Items.END_STONE_BRICKS).slab(Items.END_STONE_BRICK_SLAB).stair(Items.END_STONE_BRICK_STAIRS).wall(Items.END_STONE_BRICK_WALL).material(GTMaterials.Endstone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "prismarine").stone(Items.PRISMARINE).slab(Items.PRISMARINE_SLAB).stair(Items.PRISMARINE_STAIRS).wall(Items.PRISMARINE_WALL).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "dark_prismarine").stone(Items.DARK_PRISMARINE).slab(Items.DARK_PRISMARINE_SLAB).stair(Items.DARK_PRISMARINE_STAIRS).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "prismarine_brick").stone(Items.PRISMARINE_BRICKS).slab(Items.PRISMARINE_BRICK_SLAB).stair(Items.PRISMARINE_BRICK_STAIRS).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "bamboo_mosaic").stone(Items.BAMBOO_MOSAIC).slab(Items.BAMBOO_MOSAIC_SLAB).stair(Items.BAMBOO_MOSAIC_STAIRS).material(GTMaterials.Wood).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "deepslate").stone(Items.DEEPSLATE).crackedStone(Items.COBBLED_DEEPSLATE).build(), new StoneTypeEntry.Builder("minecraft", "cobbled_deepslate").stone(Items.COBBLED_DEEPSLATE).polishedStone(Items.POLISHED_DEEPSLATE).chiselStone(Items.CHISELED_DEEPSLATE).slab(Items.COBBLED_DEEPSLATE_SLAB).stair(Items.COBBLED_DEEPSLATE_STAIRS).wall(Items.COBBLED_DEEPSLATE_WALL).material(GTMaterials.Deepslate).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_deepslate").stone(Items.POLISHED_DEEPSLATE).polishedStone(Items.DEEPSLATE_BRICKS).slab(Items.POLISHED_DEEPSLATE_SLAB).stair(Items.POLISHED_DEEPSLATE_STAIRS).wall(Items.POLISHED_DEEPSLATE_WALL).material(GTMaterials.Deepslate).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "deepslate_bricks").stone(Items.DEEPSLATE_BRICKS).polishedStone(Items.DEEPSLATE_TILES).crackedStone(Items.CRACKED_DEEPSLATE_BRICKS).slab(Items.DEEPSLATE_BRICK_SLAB).stair(Items.DEEPSLATE_BRICK_STAIRS).wall(Items.DEEPSLATE_BRICK_WALL).material(GTMaterials.Deepslate).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "deepslate_tile").stone(Items.DEEPSLATE_TILES).crackedStone(Items.CRACKED_DEEPSLATE_TILES).slab(Items.DEEPSLATE_TILE_SLAB).stair(Items.DEEPSLATE_TILE_STAIRS).wall(Items.DEEPSLATE_TILE_WALL).material(GTMaterials.Deepslate).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "basalt").stone(Items.BASALT).polishedStone(Items.POLISHED_BASALT).material(GTMaterials.Basalt).registerAllMaterialInfo().build());
            return DEFAULT_ENTRIES;
        }
        return DEFAULT_ENTRIES;
    }

    public static void registerMaterialInfo() {
        for (StoneTypeEntry entry : StoneMachineRecipes.getDefaultEntries()) {
            StoneMachineRecipes.registerStoneMaterialInfo(entry);
        }
    }

    public static void registerStoneMaterialInfo(@NotNull StoneTypeEntry entry) {
        if (!entry.material.isNull() && entry.stone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.stone, TagPrefix.block, entry.material);
            }
            if (entry.addStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.stone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.polishedStone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.polishedStone, TagPrefix.block, entry.material);
            }
            if (entry.addPolishedStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.polishedStone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.smeltStone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.smeltStone, TagPrefix.block, entry.material);
            }
            if (entry.addSmeltStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.smeltStone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.chiselStone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.chiselStone, TagPrefix.block, entry.material);
            }
            if (entry.addChiselStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.chiselStone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.crackedStone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.crackedStone, TagPrefix.block, entry.material);
            }
            if (entry.addCrackedStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.crackedStone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.slab != null) {
            if (entry.addSlabOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.slab, TagPrefix.slab, entry.material);
            }
            if (entry.addSlabMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.slab, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount / 2L)));
            }
        }
        if (!entry.material.isNull() && entry.stair != null) {
            if (entry.addStairOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.stair, TagPrefix.stairs, entry.material);
            }
            if (entry.addStairMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.stair, new ItemMaterialInfo(new MaterialStack(entry.material, 3L * entry.materialAmount / 4L)));
            }
        }
        if (!entry.material.isNull() && entry.wall != null) {
            if (entry.addWallOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.wall, TagPrefix.fence, entry.material);
            }
            if (entry.addWallMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.wall, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.pressurePlate != null && entry.addPressurePlateMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.pressurePlate, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount / 4L)));
        }
        if (!entry.material.isNull() && entry.button != null && entry.addButtonMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.button, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount / 6L)));
        }
    }

    private static void registerStoneRecipes(Consumer<FinishedRecipe> provider) {
        for (StoneTypeEntry entry : StoneMachineRecipes.getDefaultEntries()) {
            StoneMachineRecipes.registerStoneTypeRecipes(provider, entry);
        }
    }

    public static void registerStoneTypeRecipes(Consumer<FinishedRecipe> provider, @NotNull StoneTypeEntry entry) {
        if (entry.stone == null) {
            GTCEu.LOGGER.error("Could not find stone form of StoneTypeEntry, id: {}", (Object)entry.stoneName);
            return;
        }
        if (entry.polishedStone != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_polish_hammer", new ItemStack((ItemLike)entry.polishedStone, 4), "hSS", " SS", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + entry.stoneName + "_into_polished").inputItems(entry.stone).circuitMeta(4).outputItems(entry.polishedStone).duration(80).EUt(1L).save(provider);
        }
        if (entry.crackedStone != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_hammer", new ItemStack((ItemLike)entry.crackedStone), "h", "S", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + entry.stoneName + "_into_cracked").inputItems(entry.stone).outputItems(entry.crackedStone).duration(12).EUt(4L).save(provider);
        }
        if (entry.smeltStone != null) {
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + entry.stoneName + "_into_" + String.valueOf(entry.smeltStone), entry.stone, entry.smeltStone, 0.1f);
        }
        if (entry.slab != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_slab_saw", new ItemStack((ItemLike)entry.slab), "sS", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + entry.stoneName + "_into_slab").inputItems(entry.stone).outputItems(entry.slab, 2).duration(40).EUt(8L).addMaterialInfo(true).save(provider);
            if (entry.chiselStone != null) {
                if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                    VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_polished_hammer", new ItemStack((ItemLike)entry.chiselStone), "mSd", " S ", Character.valueOf('S'), entry.slab);
                }
                GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("form_" + entry.stoneName + "_slab_into_pillar").inputItems(entry.slab, 2).outputItems(entry.chiselStone).duration(80).EUt(8L).save(provider);
            }
        }
        if (entry.pressurePlate != null) {
            if (ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes && entry.slab != null) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_pressure_plate", new ItemStack((ItemLike)entry.pressurePlate, 2), "ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), entry.slab, Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron));
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(entry.stoneName + "_pressure_plate").inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(entry.stone, 2).outputItems(entry.pressurePlate, 2).duration(100).EUt(GTValues.VA[0]).save(provider);
            } else if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                // empty if block
            }
        }
        if (entry.button != null) {
            if (ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes && entry.pressurePlate != null) {
                VanillaRecipeHelper.addShapedRecipe(provider, "stone_button", new ItemStack((ItemLike)entry.button, 6), "sP", Character.valueOf('P'), entry.pressurePlate);
            }
            if (entry.pressurePlate != null) {
                GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + entry.stoneName + "slab_into_button").inputItems(entry.pressurePlate).outputItems(entry.button, 3).duration(60).EUt(8L).save(provider);
            } else {
                GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("cut_" + entry.stoneName + "_into_button").inputItems(entry.stone).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_NUGGET).outputItems(entry.button, 6).duration(60).EUt(8L).save(provider);
            }
        }
        if (entry.stair != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_stair_saw", new ItemStack((ItemLike)entry.stair, 3), "Ss ", "SS ", "SSS", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + entry.stoneName + "_into_stair").inputItems(entry.stone, 3).circuitMeta(7).outputItems(entry.stair, 4).duration(80).EUt(8L).addMaterialInfo(true).save(provider);
        }
        if (entry.wall != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_wall_saw", new ItemStack((ItemLike)entry.wall, 2), "sS", " S", " S", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + entry.stoneName + "_into_wall").inputItems(entry.stone).circuitMeta(13).outputItems(entry.wall).duration(100).EUt(8L).addMaterialInfo(true).save(provider);
        }
    }
}

