/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.ProxySlotRecipeHandler;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MEPatternBufferProxyPartMachine
extends TieredIOPartMachine
implements IMachineLife,
IDataStickInteractable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEPatternBufferProxyPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    private final ProxySlotRecipeHandler proxySlotRecipeHandler = new ProxySlotRecipeHandler(this, 27);
    @Persisted
    @DescSynced
    @Nullable
    private BlockPos bufferPos;
    @Nullable
    private MEPatternBufferPartMachine buffer = null;
    private boolean bufferResolved = false;

    public MEPatternBufferProxyPartMachine(IMachineBlockEntity holder) {
        super(holder, 6, IO.IN);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.getServer().tell((Runnable)new TickTask(0, () -> this.setBuffer(this.bufferPos)));
        }
    }

    @Override
    public List<RecipeHandlerList> getRecipeHandlers() {
        return this.proxySlotRecipeHandler.getProxySlotHandlers();
    }

    public void setBuffer(@Nullable BlockPos pos) {
        this.bufferResolved = true;
        Level level = this.getLevel();
        if (level == null || pos == null) {
            this.buffer = null;
        } else {
            MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, pos);
            if (metaMachine instanceof MEPatternBufferPartMachine) {
                MEPatternBufferPartMachine machine = (MEPatternBufferPartMachine)metaMachine;
                this.bufferPos = pos;
                this.buffer = machine;
                machine.addProxy(this);
                if (!this.isRemote()) {
                    this.proxySlotRecipeHandler.updateProxy(machine);
                }
            } else {
                this.buffer = null;
            }
        }
    }

    @Nullable
    public MEPatternBufferPartMachine getBuffer() {
        if (!this.bufferResolved) {
            this.setBuffer(this.bufferPos);
        }
        return this.buffer;
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return this.getBuffer() != null;
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        assert (this.getBuffer() != null);
        return this.getBuffer().createUI(entityPlayer);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onMachineRemoved() {
        MEPatternBufferPartMachine buf = this.getBuffer();
        if (buf != null) {
            buf.removeProxy(this);
            this.proxySlotRecipeHandler.clearProxy();
        }
    }

    @Override
    public InteractionResult onDataStickUse(Player player, ItemStack dataStick) {
        if (dataStick.hasTag()) {
            assert (dataStick.getTag() != null);
            if (dataStick.getTag().contains("pos", 11)) {
                int[] posArray = dataStick.getOrCreateTag().getIntArray("pos");
                BlockPos bufferPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
                this.setBuffer(bufferPos);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Generated
    public ProxySlotRecipeHandler getProxySlotRecipeHandler() {
        return this.proxySlotRecipeHandler;
    }

    @Nullable
    @Generated
    public BlockPos getBufferPos() {
        return this.bufferPos;
    }
}

