/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.emi;

import appeng.menu.me.items.PatternEncodingTermMenu;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTFluids;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMultiMachines;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluid;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluidHelper;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.emi.circuit.GTProgrammedCircuitCategory;
import com.gregtechceu.gtceu.integration.emi.multipage.MultiblockInfoEmiCategory;
import com.gregtechceu.gtceu.integration.emi.oreprocessing.GTOreProcessingEmiCategory;
import com.gregtechceu.gtceu.integration.emi.orevein.GTBedrockFluidEmiCategory;
import com.gregtechceu.gtceu.integration.emi.orevein.GTBedrockOreEmiCategory;
import com.gregtechceu.gtceu.integration.emi.orevein.GTOreVeinEmiCategory;
import com.gregtechceu.gtceu.integration.emi.recipe.Ae2PatternTerminalHandler;
import com.gregtechceu.gtceu.integration.emi.recipe.GTEmiRecipeHandler;
import com.gregtechceu.gtceu.integration.emi.recipe.GTRecipeEMICategory;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import de.mari_023.ae2wtlib.wet.WETMenu;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@EmiEntrypoint
public class GTEMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addCategory((EmiRecipeCategory)MultiblockInfoEmiCategory.CATEGORY);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            registry.addCategory((EmiRecipeCategory)GTOreProcessingEmiCategory.CATEGORY);
        }
        registry.addCategory((EmiRecipeCategory)GTOreVeinEmiCategory.CATEGORY);
        registry.addCategory((EmiRecipeCategory)GTBedrockFluidEmiCategory.CATEGORY);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            registry.addCategory((EmiRecipeCategory)GTBedrockOreEmiCategory.CATEGORY);
        }
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            if (!category.shouldRegisterDisplays()) continue;
            registry.addCategory((EmiRecipeCategory)GTRecipeEMICategory.CATEGORIES.apply(category));
        }
        registry.addRecipeHandler(ModularUIContainer.MENUTYPE, (EmiRecipeHandler)new GTEmiRecipeHandler());
        if (GTCEu.Mods.isAE2Loaded()) {
            registry.addRecipeHandler(PatternEncodingTermMenu.TYPE, new Ae2PatternTerminalHandler());
        }
        if (GTCEu.isModLoaded("ae2wtlib")) {
            registry.addRecipeHandler(WETMenu.TYPE, new Ae2PatternTerminalHandler());
        }
        registry.addCategory((EmiRecipeCategory)GTProgrammedCircuitCategory.CATEGORY);
        MultiblockInfoEmiCategory.registerDisplays(registry);
        GTRecipeEMICategory.registerDisplays(registry);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            GTOreProcessingEmiCategory.registerDisplays(registry);
        }
        GTOreVeinEmiCategory.registerDisplays(registry);
        GTBedrockFluidEmiCategory.registerDisplays(registry);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            GTBedrockOreEmiCategory.registerDisplays(registry);
        }
        GTProgrammedCircuitCategory.registerDisplays(registry);
        GTRecipeEMICategory.registerWorkStations(registry);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            GTOreProcessingEmiCategory.registerWorkStations(registry);
        }
        GTOreVeinEmiCategory.registerWorkStations(registry);
        GTBedrockFluidEmiCategory.registerWorkStations(registry);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            GTBedrockOreEmiCategory.registerWorkStations(registry);
        }
        registry.addWorkstation((EmiRecipeCategory)GTRecipeEMICategory.CATEGORIES.apply(GTRecipeTypes.CHEMICAL_RECIPES.getCategory()), (EmiIngredient)EmiStack.of((ItemStack)GTMultiMachines.LARGE_CHEMICAL_REACTOR.asStack()));
        registry.setDefaultComparison((Object)GTItems.TURBINE_ROTOR.asItem(), Comparison.compareNbt());
        registry.setDefaultComparison((Object)GTItems.PROGRAMMED_CIRCUIT.asItem(), Comparison.compareNbt());
        registry.removeEmiStacks(EmiStack.of((ItemStack)GTItems.PROGRAMMED_CIRCUIT.asStack()));
        registry.addEmiStack(EmiStack.of((ItemStack)IntCircuitBehaviour.stack(0)));
        registry.addWorkstation((EmiRecipeCategory)GTProgrammedCircuitCategory.CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)IntCircuitBehaviour.stack(0)));
        Comparison potionComparison = Comparison.compareData(stack -> PotionUtils.getPotion((CompoundTag)stack.getNbt()));
        PotionFluid potionFluid = (PotionFluid)((Object)GTFluids.POTION.get());
        registry.setDefaultComparison((Object)potionFluid.getSource(), potionComparison);
        registry.setDefaultComparison((Object)potionFluid.getFlowing(), potionComparison);
        for (Potion potion : BuiltInRegistries.POTION) {
            FluidStack stack2 = PotionFluidHelper.getFluidFromPotion(potion, 250);
            registry.addEmiStack(EmiStack.of((Fluid)stack2.getFluid(), (CompoundTag)stack2.getTag()));
        }
    }
}

