/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class CableBlockProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag data;
        BlockEntity be = blockAccessor.getBlockEntity();
        if (be != null && (data = blockAccessor.getServerData().getCompound(this.getUid().toString())).contains("cableData", 10)) {
            CompoundTag tag = data.getCompound("cableData");
            long voltage = tag.getLong("currentVoltage");
            double amperage = tag.getDouble("currentAmperage");
            iTooltip.add((Component)Component.translatable((String)"gtceu.top.cable_voltage"));
            if (voltage != 0L) {
                iTooltip.append((Component)Component.literal((String)GTValues.VNF[GTUtil.getTierByVoltage(voltage)]));
                iTooltip.append((Component)Component.literal((String)" / "));
            }
            iTooltip.append((Component)Component.literal((String)GTValues.VNF[GTUtil.getTierByVoltage(tag.getLong("maxVoltage"))]));
            iTooltip.add((Component)Component.translatable((String)"gtceu.top.cable_amperage"));
            if (amperage != 0.0) {
                iTooltip.append((Component)Component.literal((String)(FormattingUtil.DECIMAL_FORMAT_1F.format(amperage) + "A / ")));
            }
            iTooltip.append((Component)Component.literal((String)(FormattingUtil.DECIMAL_FORMAT_1F.format(tag.getDouble("maxAmperage")) + "A")));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        CableBlock cableBlock;
        CableBlockEntity cable;
        CompoundTag data = compoundTag.getCompound(this.getUid().toString());
        Block block = blockAccessor.getBlock();
        if (block instanceof CableBlock && (cable = (CableBlockEntity)(cableBlock = (CableBlock)block).getPipeTile((BlockGetter)blockAccessor.getLevel(), blockAccessor.getPosition())) != null) {
            CompoundTag cableData = new CompoundTag();
            cableData.putLong("maxVoltage", cable.getMaxVoltage());
            cableData.putLong("currentVoltage", cable.getCurrentMaxVoltage());
            cableData.putDouble("maxAmperage", (double)cable.getMaxAmperage());
            cableData.putDouble("currentAmperage", cable.getAverageAmperage());
            data.put("cableData", (Tag)cableData);
        }
        compoundTag.put(this.getUid().toString(), (Tag)data);
    }

    public ResourceLocation getUid() {
        return GTCEu.id("cable_info");
    }
}

