/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public class MaintenanceBlockProvider
extends CapabilityBlockProvider<IMaintenanceMachine> {
    public MaintenanceBlockProvider() {
        super(GTCEu.id("maintenance_info"));
    }

    @Override
    @Nullable
    protected IMaintenanceMachine getCapability(Level level, BlockPos blockPos, @Nullable Direction direction) {
        IMaintenanceMachine cap = GTCapabilityHelper.getMaintenanceMachine(level, blockPos, direction);
        if (cap != null) {
            return cap;
        }
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof IMultiController) {
            IMultiController controller = (IMultiController)((Object)metaMachine);
            for (IMultiPart part : controller.getParts()) {
                if (!(part instanceof IMaintenanceMachine)) continue;
                IMaintenanceMachine maintenanceMachine = (IMaintenanceMachine)part;
                return maintenanceMachine;
            }
        }
        return null;
    }

    @Override
    protected void write(CompoundTag compoundTag, IMaintenanceMachine maintenanceMachine) {
        compoundTag.putBoolean("hasProblems", maintenanceMachine.hasMaintenanceProblems());
        if (maintenanceMachine.hasMaintenanceProblems()) {
            compoundTag.putInt("maintenanceProblems", (int)maintenanceMachine.getMaintenanceProblems());
        }
    }

    @Override
    protected void addTooltip(CompoundTag compoundTag, ITooltip iTooltip, Player player, BlockAccessor blockAccessor, BlockEntity blockEntity, IPluginConfig iPluginConfig) {
        if (compoundTag.contains("hasProblems", 1)) {
            if (compoundTag.getBoolean("hasProblems")) {
                if (blockAccessor.showDetails()) {
                    int problems = compoundTag.getInt("maintenanceProblems");
                    for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                        if ((problems >> i & 1) != 0) continue;
                        Tuple<ItemStack, MutableComponent> tuple = GTUtil.getMaintenanceText(i);
                        IElementHelper helper = iTooltip.getElementHelper();
                        iTooltip.add(helper.smallItem((ItemStack)tuple.getA()));
                        iTooltip.append((Component)tuple.getB());
                    }
                } else {
                    iTooltip.add((Component)Component.translatable((String)"gtceu.top.maintenance_broken").withStyle(ChatFormatting.RED));
                }
            } else {
                iTooltip.add((Component)Component.translatable((String)"gtceu.top.maintenance_fixed").withStyle(ChatFormatting.GREEN));
            }
        }
    }
}

