/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.integration.jade.GTElementHelper;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.util.FluidTextHelper;

public class RecipeOutputProvider
extends CapabilityBlockProvider<RecipeLogic> {
    public RecipeOutputProvider() {
        super(GTCEu.id("recipe_output_info"));
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getRecipeLogic(level, pos, side);
    }

    @Override
    protected void write(CompoundTag data, RecipeLogic recipeLogic) {
        if (recipeLogic.isWorking()) {
            data.putBoolean("Working", recipeLogic.isWorking());
            GTRecipe recipe = recipeLogic.getLastRecipe();
            if (recipe != null) {
                int recipeTier = RecipeHelper.getPreOCRecipeEuTier(recipe);
                int chanceTier = recipeTier + recipe.ocLevel;
                ChanceBoostFunction function = recipe.getType().getChanceFunction();
                List<Content> itemContents = recipe.getOutputContents(ItemRecipeCapability.CAP);
                List<Content> fluidContents = recipe.getOutputContents(FluidRecipeCapability.CAP);
                int runs = recipe.getTotalRuns();
                ListTag itemTags = new ListTag();
                for (Content item : itemContents) {
                    CompoundTag itemTag;
                    Object object = item.content;
                    if (object instanceof IntProviderIngredient) {
                        IntProviderIngredient provider;
                        IntProviderIngredient chanced = provider = (IntProviderIngredient)((Object)object);
                        if (item.chance < item.maxChance) {
                            double countD = (double)runs * (double)function.getBoostedChance(item, recipeTier, chanceTier) / (double)item.maxChance;
                            chanced = (IntProviderIngredient)ItemRecipeCapability.CAP.copyWithModifier(provider, ContentModifier.multiplier(countD));
                        }
                        itemTag = (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.INSTANCE, chanced.toJson());
                    } else {
                        ItemStack[] stacks = ((Ingredient)ItemRecipeCapability.CAP.of(item.content)).getItems();
                        if (stacks.length == 0 || stacks[0].isEmpty()) continue;
                        ItemStack stack = stacks[0];
                        itemTag = new CompoundTag();
                        GTUtil.saveItemStack(stack, itemTag);
                        if (item.chance < item.maxChance) {
                            int count = stack.getCount();
                            double countD = (double)count * (double)runs * (double)function.getBoostedChance(item, recipeTier, chanceTier) / (double)item.maxChance;
                            count = Math.max(1, (int)Math.round(countD));
                            itemTag.putInt("Count", count);
                        }
                    }
                    itemTags.add((Object)itemTag);
                }
                if (!itemTags.isEmpty()) {
                    data.put("OutputItems", (Tag)itemTags);
                }
                ListTag fluidTags = new ListTag();
                for (Content fluid : fluidContents) {
                    CompoundTag fluidTag;
                    Object stack = fluid.content;
                    if (stack instanceof IntProviderFluidIngredient) {
                        IntProviderFluidIngredient provider;
                        IntProviderFluidIngredient chanced = provider = (IntProviderFluidIngredient)stack;
                        if (fluid.chance < fluid.maxChance) {
                            double countD = (double)runs * (double)function.getBoostedChance(fluid, recipeTier, chanceTier) / (double)fluid.maxChance;
                            chanced = (IntProviderFluidIngredient)FluidRecipeCapability.CAP.copyWithModifier(provider, ContentModifier.multiplier(countD));
                        }
                        fluidTag = chanced.toNBT();
                    } else {
                        FluidStack[] stacks = ((FluidIngredient)FluidRecipeCapability.CAP.of(fluid.content)).getStacks();
                        if (stacks.length == 0 || stacks[0].isEmpty()) continue;
                        FluidStack stack2 = stacks[0];
                        fluidTag = new CompoundTag();
                        stack2.writeToNBT(fluidTag);
                        if (fluid.chance < fluid.maxChance) {
                            int amount = stacks[0].getAmount();
                            double amountD = (double)amount * (double)runs * (double)function.getBoostedChance(fluid, recipeTier, chanceTier) / (double)fluid.maxChance;
                            amount = Math.max(1, (int)Math.round(amountD));
                            fluidTag.putInt("Amount", amount);
                        }
                    }
                    fluidTags.add((Object)fluidTag);
                }
                if (!fluidTags.isEmpty()) {
                    data.put("OutputFluids", (Tag)fluidTags);
                }
            }
        }
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        if (capData.getBoolean("Working")) {
            ListTag itemTags;
            ArrayList<Ingredient> outputItems = new ArrayList<Ingredient>();
            if (capData.contains("OutputItems", 9) && !(itemTags = capData.getList("OutputItems", 10)).isEmpty()) {
                for (Tag tag : itemTags) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag tCompoundTag = (CompoundTag)tag;
                    if (tCompoundTag.contains("count_provider")) {
                        IntProviderIngredient ingredient = (IntProviderIngredient)IntProviderIngredient.SERIALIZER.parse((JsonObject)NbtOps.INSTANCE.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)tCompoundTag));
                        outputItems.add(ingredient);
                        continue;
                    }
                    ItemStack stack = GTUtil.loadItemStack(tCompoundTag);
                    if (stack.isEmpty()) continue;
                    outputItems.add(SizedIngredient.create(stack));
                }
            }
            ArrayList<FluidIngredient> outputFluids = new ArrayList<FluidIngredient>();
            if (capData.contains("OutputFluids", 9)) {
                ListTag fluidTags = capData.getList("OutputFluids", 10);
                for (Tag tag : fluidTags) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag tCompoundTag = (CompoundTag)tag;
                    if (tCompoundTag.contains("count_provider")) {
                        IntProviderFluidIngredient ingredient = IntProviderFluidIngredient.fromNBT(tCompoundTag);
                        outputFluids.add(ingredient);
                        continue;
                    }
                    FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)tCompoundTag);
                    if (stack.isEmpty()) continue;
                    outputFluids.add(FluidIngredient.of(stack));
                }
            }
            if (!outputItems.isEmpty() || !outputFluids.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"gtceu.top.recipe_output"));
            }
            this.addItemTooltips(tooltip, outputItems);
            this.addFluidTooltips(tooltip, outputFluids);
        }
    }

    private void addItemTooltips(ITooltip iTooltip, List<Ingredient> outputItems) {
        IElementHelper helper = iTooltip.getElementHelper();
        for (Ingredient itemOutput : outputItems) {
            ItemStack item;
            if (itemOutput == null || itemOutput.isEmpty()) continue;
            MutableComponent text = CommonComponents.space();
            if (itemOutput instanceof IntProviderIngredient) {
                IntProviderIngredient provider = (IntProviderIngredient)itemOutput;
                item = provider.getInner().getItems()[0];
                text = text.append((Component)Component.translatable((String)"gtceu.gui.content.range", (Object[])new Object[]{String.valueOf(provider.getCountProvider().getMinValue()), String.valueOf(provider.getCountProvider().getMaxValue())}));
            } else {
                item = itemOutput.getItems()[0];
                text.append(String.valueOf(item.getCount()));
                item.setCount(1);
            }
            text.append((Component)Component.translatable((String)"gtceu.gui.content.times_item", (Object[])new Object[]{this.getItemName(item)}).withStyle(ChatFormatting.WHITE));
            iTooltip.add(helper.smallItem(item));
            iTooltip.append((Component)text);
        }
    }

    private void addFluidTooltips(ITooltip iTooltip, List<FluidIngredient> outputFluids) {
        for (FluidIngredient fluidOutput : outputFluids) {
            FluidStack stack;
            if (fluidOutput == null || fluidOutput.isEmpty()) continue;
            MutableComponent text = CommonComponents.space();
            if (fluidOutput instanceof IntProviderFluidIngredient) {
                IntProviderFluidIngredient provider = (IntProviderFluidIngredient)fluidOutput;
                stack = provider.getInner().getStacks()[0];
                text.append((Component)Component.translatable((String)"gtceu.gui.content.range", (Object[])new Object[]{FluidTextHelper.getUnicodeMillibuckets((long)provider.getCountProvider().getMinValue(), (boolean)true), FluidTextHelper.getUnicodeMillibuckets((long)provider.getCountProvider().getMaxValue(), (boolean)true)}));
            } else {
                stack = fluidOutput.getStacks()[0];
                text.append(FluidTextHelper.getUnicodeMillibuckets((long)stack.getAmount(), (boolean)true));
            }
            text.append((Component)CommonComponents.space()).append(this.getFluidName(stack)).withStyle(ChatFormatting.WHITE);
            iTooltip.add(GTElementHelper.smallFluid(this.getFluid(stack)));
            iTooltip.append((Component)text);
        }
    }

    private Component getItemName(ItemStack stack) {
        return stack.getDisplayName().copy().withStyle(ChatFormatting.WHITE);
    }

    private Component getFluidName(FluidStack stack) {
        return ComponentUtils.wrapInSquareBrackets((Component)stack.getDisplayName()).withStyle(ChatFormatting.WHITE);
    }

    private JadeFluidObject getFluid(FluidStack stack) {
        return JadeFluidObject.of((Fluid)stack.getFluid(), (long)stack.getAmount());
    }
}

