/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.integration.jade.provider.BlockInfoProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class SteamBoilerBlockProvider
extends BlockInfoProvider<SteamBoilerMachine> {
    public SteamBoilerBlockProvider() {
        super(GTCEu.id("steam_boiler_info"));
    }

    @Override
    @Nullable
    protected SteamBoilerMachine getCapability(Level level, BlockPos blockPos) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof SteamBoilerMachine) {
            SteamBoilerMachine steamBoilerMachine = (SteamBoilerMachine)metaMachine;
            return steamBoilerMachine;
        }
        return null;
    }

    @Override
    protected void write(CompoundTag data, SteamBoilerMachine capability, BlockAccessor block) {
        data.putBoolean("isBurning", capability.getRecipeLogic().isWorking());
        data.putBoolean("hasWater", !capability.isHasNoWater());
        data.putLong("steamProduction", capability.getTotalSteamOutput());
        data.putInt("currentTemperature", capability.getCurrentTemperature());
        data.putInt("maxTemperature", capability.getMaxTemperature());
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        MutableComponent extra;
        boolean makingSteam;
        boolean isBurning = capData.getBoolean("isBurning");
        boolean hasWater = capData.getBoolean("hasWater");
        long production = capData.getLong("steamProduction");
        int temperature = capData.getInt("currentTemperature");
        int maxTemperature = capData.getInt("maxTemperature");
        boolean bl = makingSteam = hasWater && temperature >= 100;
        MutableComponent root = isBurning && temperature < maxTemperature ? Component.translatable((String)"gtceu.machine.boiler.info.heating.up") : (!isBurning && temperature > 0 ? Component.translatable((String)"gtceu.machine.boiler.info.cooling.down") : null);
        if (makingSteam) {
            extra = Component.translatable((String)"gtceu.machine.boiler.info.production.data", (Object[])new Object[]{Component.literal((String)FormattingUtil.formatNumbers(production / 10L)).withStyle(ChatFormatting.GREEN)});
            if (root != null) {
                extra = Component.literal((String)" | ").append((Component)extra);
            }
        } else {
            extra = temperature > 0 && temperature < 100 ? Component.literal((String)String.format(" (%s%%)", temperature)).withStyle(isBurning ? ChatFormatting.RED : ChatFormatting.BLUE) : null;
        }
        if (root != null && extra != null) {
            tooltip.add((Component)root.append(extra));
        } else if (root != null) {
            tooltip.add((Component)root);
        } else if (extra != null) {
            tooltip.add(extra);
        }
    }
}

