/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jei.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeWrapper;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.jei.IGui2IDrawable;
import com.lowdragmc.lowdraglib.jei.ModularUIRecipeCategory;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeJEICategory
extends ModularUIRecipeCategory<GTRecipe> {
    public static final Function<GTRecipeCategory, RecipeType<GTRecipe>> TYPES = Util.memoize(c -> new RecipeType(c.registryKey, GTRecipe.class));
    private final GTRecipeCategory category;
    private final IDrawable background;
    private final IDrawable icon;

    public GTRecipeJEICategory(IJeiHelpers helpers, @NotNull GTRecipeCategory category) {
        super(GTRecipeWrapper::new);
        this.category = category;
        GTRecipeType recipeType = category.getRecipeType();
        IGuiHelper guiHelper = helpers.getGuiHelper();
        Size size = recipeType.getRecipeUI().getJEISize();
        this.background = guiHelper.createBlankDrawable(size.width, size.height);
        this.icon = IGui2IDrawable.toDrawable((IGuiTexture)category.getIcon(), (int)16, (int)16);
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        List<GTRecipe> wrapped;
        GTRecipeType type;
        ArrayList<GTRecipeCategory> subCategories = new ArrayList<GTRecipeCategory>();
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            if (!category.shouldRegisterDisplays()) continue;
            type = category.getRecipeType();
            if (category != type.getCategory()) {
                subCategories.add(category);
                continue;
            }
            type.buildRepresentativeRecipes();
            wrapped = List.copyOf(type.getRecipesInCategory(category));
            registration.addRecipes(TYPES.apply(category), wrapped);
        }
        for (GTRecipeCategory subCategory : subCategories) {
            if (!subCategory.shouldRegisterDisplays()) continue;
            type = subCategory.getRecipeType();
            wrapped = List.copyOf(type.getRecipesInCategory(subCategory));
            registration.addRecipes(TYPES.apply(subCategory), wrapped);
        }
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (MachineDefinition machine : GTRegistries.MACHINES) {
            for (GTRecipeType type : machine.getRecipeTypes()) {
                for (GTRecipeCategory category : type.getCategories()) {
                    if (!category.isXEIVisible() && !GTCEu.isDev()) continue;
                    registration.addRecipeCatalyst(machine.asStack(), new RecipeType[]{GTRecipeJEICategory.machineType(category)});
                }
            }
        }
    }

    public static RecipeType<?> machineType(GTRecipeCategory category) {
        if (category == GTRecipeTypes.FURNACE_RECIPES.getCategory()) {
            return RecipeTypes.SMELTING;
        }
        return TYPES.apply(category);
    }

    @NotNull
    public RecipeType<GTRecipe> getRecipeType() {
        return TYPES.apply(this.category);
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)this.category.getLanguageKey());
    }

    @Nullable
    public ResourceLocation getRegistryName(@NotNull GTRecipe recipe) {
        return recipe.id;
    }

    @Generated
    public IDrawable getBackground() {
        return this.background;
    }

    @Generated
    public IDrawable getIcon() {
        return this.icon;
    }
}

