/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.cache;

import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.integration.map.cache.GridCache;
import com.gregtechceu.gtceu.integration.map.cache.GridPos;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;

public class DimensionCache {
    private final ConcurrentMap<GridPos, GridCache> cache = new ConcurrentHashMap<GridPos, GridCache>();
    public boolean dirty;

    public boolean addVein(int gridX, int gridZ, GeneratedVeinMetadata vein) {
        boolean added;
        GridPos key = new GridPos(gridX, gridZ);
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, new GridCache());
        }
        this.dirty = (added = ((GridCache)this.cache.get(key)).addVein(vein)) || this.dirty;
        return added;
    }

    public CompoundTag toNBT(boolean isClient) {
        return this.toNBT(new CompoundTag(), isClient);
    }

    public CompoundTag toNBT(CompoundTag nbt, boolean isClient) {
        for (GridPos key : this.cache.keySet()) {
            nbt.put(key.x + "," + key.z, (Tag)((GridCache)this.cache.get(key)).toNBT(isClient));
        }
        return nbt;
    }

    public void fromNBT(CompoundTag tag, boolean isClient) {
        for (String gridPos : tag.getAllKeys()) {
            String[] split = gridPos.split(",");
            GridPos key = new GridPos(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
            if (!this.cache.containsKey(key)) {
                this.cache.put(key, new GridCache());
            }
            ((GridCache)this.cache.get(key)).fromNBT(tag.getList(gridPos, 10), isClient);
        }
    }

    public List<GeneratedVeinMetadata> getNearbyVeins(BlockPos pos, int blockRadius) {
        return this.getVeinsInBounds(pos.offset(-blockRadius, 0, -blockRadius), pos.offset(blockRadius, 0, blockRadius));
    }

    public List<GeneratedVeinMetadata> getVeinsInBounds(BlockPos topLeftBlock, BlockPos bottomRightBlock) {
        GridPos topLeft = new GridPos(topLeftBlock);
        GridPos bottomRight = new GridPos(bottomRightBlock);
        ArrayList<GeneratedVeinMetadata> found = new ArrayList<GeneratedVeinMetadata>();
        for (int i = topLeft.x; i <= bottomRight.x; ++i) {
            for (int j = topLeft.z; j <= bottomRight.z; ++j) {
                GridPos curPos = new GridPos(i, j);
                if (!this.cache.containsKey(curPos)) continue;
                found.addAll(((GridCache)this.cache.get(curPos)).getVeinsMatching(vein -> vein.center().getX() >= topLeftBlock.getX() && vein.center().getX() <= bottomRightBlock.getX() && vein.center().getZ() >= topLeftBlock.getZ() && vein.center().getZ() <= bottomRightBlock.getZ()));
            }
        }
        return found;
    }

    public List<GeneratedVeinMetadata> getVeinsInChunk(ChunkPos pos) {
        GridPos gPos = new GridPos(pos);
        if (this.cache.containsKey(gPos)) {
            return ((GridCache)this.cache.get(gPos)).getVeinsMatching(vein -> pos.equals((Object)vein.originChunk()));
        }
        return new ArrayList<GeneratedVeinMetadata>();
    }

    public void removeAllInChunk(ChunkPos pos) {
        GridPos gPos = new GridPos(pos);
        if (this.cache.containsKey(gPos)) {
            ((GridCache)this.cache.get(gPos)).removeVeinsMatching(vein -> pos.equals((Object)vein.originChunk()));
        }
    }

    @Generated
    public ConcurrentMap<GridPos, GridCache> getCache() {
        return this.cache;
    }
}

