/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.xaeros.worldmap.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.resources.ResourceLocation;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiTexturedButton;

public class GuiTexturedButtonWithSize
extends GuiTexturedButton {
    protected int spriteW;
    protected int spriteH;

    public GuiTexturedButtonWithSize(int x, int y, int w, int h, int textureX, int textureY, int textureW, int textureH, int spriteW, int spriteH, ResourceLocation texture, Button.OnPress onPress, Supplier<CursorBox> tooltip) {
        super(x, y, w, h, textureX, textureY, textureW, textureH, texture, onPress, tooltip);
        this.spriteW = spriteW;
        this.spriteH = spriteH;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int iconX = this.getX() + this.width / 2 - this.textureW / 2;
        int iconY = this.getY() + this.height / 2 - this.textureH / 2;
        if (this.active) {
            if (this.isHovered) {
                --iconY;
                RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        }
        if (this.isFocused()) {
            guiGraphics.fill(iconX, iconY, iconX + this.textureW, iconY + this.textureH, 0x55FFFFFF);
        }
        guiGraphics.blit(this.texture, iconX, iconY, (float)this.textureX, (float)this.textureY, this.textureW, this.textureH, this.spriteW, this.spriteH);
    }
}

