/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.integration.top.element.FluidStackElement;
import com.gregtechceu.gtceu.integration.top.element.FluidStyle;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RecipeOutputProvider
extends CapabilityInfoProvider<RecipeLogic> {
    public ResourceLocation getID() {
        return GTCEu.id("recipe_output_info");
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos blockPos, @Nullable Direction direction) {
        return GTCapabilityHelper.getRecipeLogic(level, blockPos, direction);
    }

    @Override
    protected void addProbeInfo(RecipeLogic recipeLogic, IProbeInfo iProbeInfo, Player player, BlockEntity blockEntity, IProbeHitData iProbeHitData) {
        GTRecipe recipe;
        if (recipeLogic.isWorking() && (recipe = recipeLogic.getLastRecipe()) != null) {
            int recipeTier = RecipeHelper.getPreOCRecipeEuTier(recipe);
            int chanceTier = recipeTier + recipe.ocLevel;
            ChanceBoostFunction function = recipe.getType().getChanceFunction();
            List<Content> itemContents = recipe.getOutputContents(ItemRecipeCapability.CAP);
            List<Content> fluidContents = recipe.getOutputContents(FluidRecipeCapability.CAP);
            ArrayList<Ingredient> itemOutputs = new ArrayList<Ingredient>();
            for (Content content : itemContents) {
                ItemStack[] stacks;
                Ingredient content2 = (Ingredient)ItemRecipeCapability.CAP.of(content.content);
                if (content2 instanceof IntProviderIngredient) {
                    IntProviderIngredient provider = (IntProviderIngredient)content2;
                    stacks = provider.getInner().getItems();
                } else {
                    stacks = content2.getItems();
                }
                if (stacks.length == 0 || stacks[0].isEmpty()) continue;
                ItemStack stack = stacks[0].copy();
                if (content.chance < content.maxChance) {
                    int count = stack.getCount();
                    double countD = (double)count * (double)recipe.parallels * (double)function.getBoostedChance(content, recipeTier, chanceTier) / (double)content.maxChance;
                    count = Math.max(1, (int)Math.round(countD));
                    stack.setCount(count);
                }
                itemOutputs.add(Ingredient.of((ItemStack[])new ItemStack[]{stack}));
            }
            ArrayList<FluidIngredient> fluidOutputs = new ArrayList<FluidIngredient>();
            for (Content fluid : fluidContents) {
                FluidStack[] stacks;
                FluidIngredient content = (FluidIngredient)FluidRecipeCapability.CAP.of(fluid.content);
                if (content instanceof IntProviderFluidIngredient) {
                    IntProviderFluidIngredient provider = (IntProviderFluidIngredient)content;
                    stacks = provider.getInner().getStacks();
                } else {
                    stacks = content.getStacks();
                }
                if (stacks.length == 0 || stacks[0].isEmpty()) continue;
                FluidStack stack = stacks[0].copy();
                if (fluid.chance < fluid.maxChance) {
                    int amount = stack.getAmount();
                    double amountD = (double)amount * (double)recipe.parallels * (double)function.getBoostedChance(fluid, recipeTier, chanceTier) / (double)fluid.maxChance;
                    amount = Math.max(1, (int)Math.round(amountD));
                    stack.setAmount(amount);
                }
                fluidOutputs.add(FluidIngredient.of(stack));
            }
            if (!itemOutputs.isEmpty() || !fluidOutputs.isEmpty()) {
                IProbeInfo iProbeInfo2 = iProbeInfo.vertical(iProbeInfo.defaultLayoutStyle().spacing(0));
                iProbeInfo2.text(CompoundText.create().info((Component)Component.translatable((String)"gtceu.top.recipe_output").append(" ")));
                this.addItemInfo(iProbeInfo2, itemOutputs);
                this.addFluidInfo(iProbeInfo2, fluidOutputs);
            }
        }
    }

    private void addItemInfo(IProbeInfo verticalPane, List<Ingredient> outputItems) {
        for (Ingredient itemOutput : outputItems) {
            if (itemOutput == null || itemOutput.isEmpty()) continue;
            IProbeInfo horizontalPane = verticalPane.horizontal(verticalPane.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            Object spacer = " ";
            if (itemOutput instanceof IntProviderIngredient) {
                IntProviderIngredient provider = (IntProviderIngredient)itemOutput;
                spacer = (String)spacer + String.valueOf(Component.translatable((String)"gtceu.gui.content.range", (Object[])new Object[]{String.valueOf(provider.getCountProvider().getMinValue()), String.valueOf(provider.getCountProvider().getMaxValue())})) + " ";
                provider.setItemStacks(null);
                provider.setSampledCount(1);
            }
            horizontalPane.item(itemOutput.getItems()[0], new ItemStyle().width(16).height(16)).text((String)spacer).itemLabel(itemOutput.getItems()[0]);
        }
    }

    private void addFluidInfo(IProbeInfo verticalPane, List<FluidIngredient> outputFluids) {
        for (FluidIngredient fluidOutput : outputFluids) {
            if (fluidOutput == null || fluidOutput.isEmpty()) continue;
            IProbeInfo horizontalPane = verticalPane.horizontal(verticalPane.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            Object spacer = " ";
            if (fluidOutput instanceof IntProviderFluidIngredient) {
                IntProviderFluidIngredient provider = (IntProviderFluidIngredient)fluidOutput;
                spacer = (String)spacer + String.valueOf(Component.translatable((String)"gtceu.gui.content.range", (Object[])new Object[]{String.valueOf(provider.getCountProvider().getMinValue()), String.valueOf(provider.getCountProvider().getMaxValue())})) + " ";
                fluidOutput.setAmount(provider.getCountProvider().getMaxValue());
            }
            horizontalPane.element((IElement)new FluidStackElement(fluidOutput.getStacks()[0], new FluidStyle())).text((String)spacer).text(fluidOutput.getStacks()[0].getDisplayName());
        }
    }
}

