/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class WorkableInfoProvider
extends CapabilityInfoProvider<IWorkable> {
    public ResourceLocation getID() {
        return GTCEu.id("workable_provider");
    }

    @Override
    @Nullable
    protected IWorkable getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getWorkable(level, pos, side);
    }

    @Override
    protected void addProbeInfo(IWorkable capability, IProbeInfo probeInfo, Player player, BlockEntity blockEntity, IProbeHitData data) {
        MutableComponent text;
        RecipeLogic logic;
        if (!capability.isActive()) {
            return;
        }
        int currentProgress = capability.getProgress();
        int maxProgress = capability.getMaxProgress();
        if (capability instanceof RecipeLogic && (logic = (RecipeLogic)capability).getLastRecipe() != null && logic.getLastRecipe().data.getBoolean("duration_is_total_cwu")) {
            int color = capability.isWorkingEnabled() ? -16722738 : -4514776;
            probeInfo.progress(currentProgress, maxProgress, probeInfo.defaultProgressStyle().suffix((Component)Component.translatable((String)"gtceu.top.progress_computation", (Object[])new Object[]{maxProgress})).filledColor(color).alternateFilledColor(color).borderColor(-11184811));
            return;
        }
        if (maxProgress < 20) {
            text = Component.translatable((String)"gtceu.top.progress_tick", (Object[])new Object[]{maxProgress});
        } else {
            currentProgress = Math.round((float)currentProgress / 20.0f);
            maxProgress = Math.round((float)maxProgress / 20.0f);
            text = Component.translatable((String)"gtceu.top.progress_sec", (Object[])new Object[]{maxProgress});
        }
        if (maxProgress > 0) {
            int color = capability.isWorkingEnabled() ? -11748585 : -4514776;
            probeInfo.progress(currentProgress, maxProgress, probeInfo.defaultProgressStyle().suffix((Component)text).filledColor(color).alternateFilledColor(color).borderColor(-11184811));
        }
    }
}

