/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.xei.widgets;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidStackList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidTagList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemStackList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemTagList;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class GTOreByProduct {
    private static final List<TagPrefix> ORES = new ArrayList<TagPrefix>();
    private static ImmutableList<TagPrefix> IN_PROCESSING_STEPS;
    private static ImmutableList<ItemStack> ALWAYS_MACHINES;
    private final Int2ObjectMap<Content> chances = new Int2ObjectOpenHashMap();
    protected final List<ItemEntryList> itemInputs = new ArrayList<ItemEntryList>();
    protected final NonNullList<ItemStack> itemOutputs = NonNullList.create();
    protected final List<FluidEntryList> fluidInputs = new ArrayList<FluidEntryList>();
    private boolean hasDirectSmelt = false;
    private boolean hasChemBath = false;
    private boolean hasSeparator = false;
    private boolean hasSifter = false;
    private int currentSlot;

    public static void addOreByProductPrefix(TagPrefix orePrefix) {
        if (!ORES.contains(orePrefix)) {
            ORES.add(orePrefix);
        }
    }

    public GTOreByProduct(Material material) {
        if (IN_PROCESSING_STEPS == null) {
            IN_PROCESSING_STEPS = ImmutableList.of((Object)TagPrefix.crushed, (Object)TagPrefix.crushedPurified, (Object)TagPrefix.dustImpure, (Object)TagPrefix.dustPure, (Object)TagPrefix.crushedRefined);
        }
        if (ALWAYS_MACHINES == null) {
            ALWAYS_MACHINES = ImmutableList.of((Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.CENTRIFUGE[1].asStack(), (Object)GTMachines.ORE_WASHER[1].asStack(), (Object)GTMachines.THERMAL_CENTRIFUGE[1].asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.MACERATOR[1].asStack(), (Object)GTMachines.CENTRIFUGE[1].asStack());
        }
        OreProperty property = material.getProperty(PropertyKey.ORE);
        int oreMultiplier = property.getOreMultiplier();
        int byproductMultiplier = property.getByProductMultiplier();
        this.currentSlot = 0;
        Material[] byproducts = new Material[]{property.getOreByProduct(0, material), property.getOreByProduct(1, material), property.getOreByProduct(2, material), property.getOreByProduct(3, material)};
        ObjectIntPair<Material> washedIn = property.getWashedIn();
        List<Material> separatedInto = property.getSeparatedInto();
        ItemTagList oreStacks = new ItemTagList();
        for (TagPrefix prefix : ORES) {
            oreStacks.add(ChemicalHelper.getTag(prefix, material), 1, null);
        }
        oreStacks.add(ChemicalHelper.getTag(TagPrefix.rawOre, material), 1, null);
        this.itemInputs.add(oreStacks);
        ArrayList<ItemStack> simpleWashers = new ArrayList<ItemStack>();
        simpleWashers.add(new ItemStack((ItemLike)Items.CAULDRON));
        simpleWashers.add(GTMachines.ORE_WASHER[1].asStack());
        if (!material.hasProperty(PropertyKey.BLAST)) {
            this.addToInputs(new ItemStack((ItemLike)Blocks.FURNACE));
            this.hasDirectSmelt = true;
        } else {
            this.addToInputs(ItemStack.EMPTY);
        }
        for (ItemStack stack : ALWAYS_MACHINES) {
            this.addToInputs(stack);
        }
        this.itemInputs.add(ItemStackList.of(simpleWashers));
        this.itemInputs.add(ItemStackList.of(simpleWashers));
        this.itemInputs.add(ItemStackList.of(simpleWashers));
        if (!((Material)washedIn.first()).isNull()) {
            this.hasChemBath = true;
            this.addToInputs(GTMachines.CHEMICAL_BATH[1].asStack());
        } else {
            this.addToInputs(ItemStack.EMPTY);
        }
        if (separatedInto != null && !separatedInto.isEmpty()) {
            this.hasSeparator = true;
            this.addToInputs(GTMachines.ELECTROMAGNETIC_SEPARATOR[1].asStack());
        } else {
            this.addToInputs(ItemStack.EMPTY);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            this.hasSifter = true;
            this.addToInputs(GTMachines.SIFTER[1].asStack());
        } else {
            this.addToInputs(ItemStack.EMPTY);
        }
        for (TagPrefix prefix : IN_PROCESSING_STEPS) {
            this.itemInputs.add(ItemTagList.of(ChemicalHelper.getTag(prefix, material), 1, null));
        }
        this.currentSlot += 21;
        if (this.hasDirectSmelt) {
            Material smeltingMaterial;
            Material material2 = smeltingMaterial = property.getDirectSmeltResult().isNull() ? material : property.getDirectSmeltResult();
            ItemStack smeltingResult = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get(TagPrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get(TagPrefix.gem, smeltingMaterial) : ChemicalHelper.get(TagPrefix.dust, smeltingMaterial));
            smeltingResult.setCount(smeltingResult.getCount() * oreMultiplier);
            this.addToOutputs(smeltingResult);
        } else {
            this.addEmptyOutputs(1);
        }
        this.addToOutputs(material, TagPrefix.crushed, 2 * oreMultiplier);
        if (!ChemicalHelper.get(TagPrefix.gem, byproducts[0]).isEmpty()) {
            this.addToOutputs(byproducts[0], TagPrefix.gem, 1);
        } else {
            this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        }
        this.addChance(1400, 0);
        this.addToOutputs(material, TagPrefix.dustImpure, 1);
        this.addToOutputs(byproducts[0], TagPrefix.dust, byproductMultiplier);
        this.addChance(1400, 0);
        this.addToOutputs(material, TagPrefix.dust, 1);
        this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        this.addChance(1111, 0);
        this.addToOutputs(material, TagPrefix.crushedPurified, 1);
        this.addToOutputs(byproducts[0], TagPrefix.dust, 1);
        this.addChance(3333, 0);
        FluidTagList tagList = new FluidTagList();
        tagList.add(GTMaterials.Water.getFluidTag(), 1000, null);
        tagList.add(GTMaterials.DistilledWater.getFluidTag(), 100, null);
        this.fluidInputs.add(tagList);
        this.addToOutputs(material, TagPrefix.crushedRefined, 1);
        this.addToOutputs(byproducts[1], TagPrefix.dust, byproductMultiplier);
        this.addChance(3333, 0);
        this.addToOutputs(material, TagPrefix.dust, 1);
        this.addToOutputs(byproducts[2], TagPrefix.dust, 1);
        this.addChance(1400, 0);
        this.addToOutputs(material, TagPrefix.dustPure, 1);
        this.addToOutputs(byproducts[1], TagPrefix.dust, 1);
        this.addChance(1400, 0);
        this.addToOutputs(material, TagPrefix.dust, 1);
        this.addToOutputs(byproducts[1], TagPrefix.dust, 1);
        this.addChance(1111, 0);
        this.addToOutputs(material, TagPrefix.crushed, 1);
        this.addToOutputs(material, TagPrefix.crushedPurified, 1);
        this.addToOutputs(material, TagPrefix.dustImpure, 1);
        this.addToOutputs(material, TagPrefix.dust, 1);
        this.addToOutputs(material, TagPrefix.dustPure, 1);
        this.addToOutputs(material, TagPrefix.dust, 1);
        if (this.hasChemBath) {
            this.addToOutputs(material, TagPrefix.crushedPurified, 1);
            this.addToOutputs(byproducts[3], TagPrefix.dust, byproductMultiplier);
            this.addChance(7000, 0);
            this.fluidInputs.add(FluidTagList.of(((Material)washedIn.first()).getFluidTag(), washedIn.secondInt(), null));
        } else {
            this.addEmptyOutputs(2);
            this.fluidInputs.add(new FluidStackList());
        }
        if (this.hasSeparator) {
            TagPrefix prefix;
            prefix = separatedInto.get(separatedInto.size() - 1).getBlastTemperature() == 0 && separatedInto.get(separatedInto.size() - 1).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dust;
            ItemStack separatedStack2 = ChemicalHelper.get(prefix, separatedInto.get(separatedInto.size() - 1), prefix == TagPrefix.nugget ? 2 : 1);
            this.addToOutputs(material, TagPrefix.dust, 1);
            this.addToOutputs(separatedInto.get(0), TagPrefix.dust, 1);
            this.addChance(1000, 0);
            this.addToOutputs(separatedStack2);
            this.addChance(prefix == TagPrefix.dust ? 500 : 2000, 0);
        } else {
            this.addEmptyOutputs(3);
        }
        if (this.hasSifter) {
            boolean highOutput = material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT);
            ItemStack flawedStack = ChemicalHelper.get(TagPrefix.gemFlawed, material);
            ItemStack chippedStack = ChemicalHelper.get(TagPrefix.gemChipped, material);
            this.addToOutputs(material, TagPrefix.gemExquisite, 1);
            this.addGemChance(300, 0, 500, 0, highOutput);
            this.addToOutputs(material, TagPrefix.gemFlawless, 1);
            this.addGemChance(1000, 0, 1500, 0, highOutput);
            this.addToOutputs(material, TagPrefix.gem, 1);
            this.addGemChance(3500, 0, 5000, 0, highOutput);
            this.addToOutputs(material, TagPrefix.dustPure, 1);
            this.addGemChance(5000, 0, 2500, 0, highOutput);
            if (!flawedStack.isEmpty()) {
                this.addToOutputs(flawedStack);
                this.addGemChance(2500, 0, 2000, 0, highOutput);
            } else {
                this.addEmptyOutputs(1);
            }
            if (!chippedStack.isEmpty()) {
                this.addToOutputs(chippedStack);
                this.addGemChance(3500, 0, 3000, 0, highOutput);
            } else {
                this.addEmptyOutputs(1);
            }
        } else {
            this.addEmptyOutputs(6);
        }
    }

    public void getTooltip(int slotIndex, List<Component> tooltips) {
        if (this.chances.containsKey(slotIndex)) {
            Content entry = (Content)this.chances.get(slotIndex);
            float chance = 100.0f * (float)entry.chance / (float)entry.maxChance;
            if (entry.tierChanceBoost != 0) {
                float boost = (float)entry.tierChanceBoost / 100.0f;
                tooltips.add(FormattingUtil.formatPercentage2Places("gtceu.gui.content.chance_base", chance));
                tooltips.add(FormattingUtil.formatPercentage2Places("gtceu.gui.content.chance_tier_boost_plus", boost));
            } else {
                tooltips.add(FormattingUtil.formatPercentage2Places("gtceu.gui.content.chance_no_boost", chance));
            }
        }
    }

    public Content getChance(int slot) {
        return (Content)this.chances.get(slot);
    }

    public boolean hasSifter() {
        return this.hasSifter;
    }

    public boolean hasSeparator() {
        return this.hasSeparator;
    }

    public boolean hasChemBath() {
        return this.hasChemBath;
    }

    public boolean hasDirectSmelt() {
        return this.hasDirectSmelt;
    }

    private void addToOutputs(Material material, TagPrefix prefix, int size) {
        this.addToOutputs(ChemicalHelper.get(prefix, material, size));
    }

    private void addToOutputs(ItemStack stack) {
        this.itemOutputs.add((Object)stack);
        ++this.currentSlot;
    }

    private void addEmptyOutputs(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addToOutputs(ItemStack.EMPTY);
        }
    }

    private void addToInputs(ItemStack stack) {
        this.itemInputs.add(ItemStackList.of(stack));
    }

    private void addChance(int base, int tier) {
        this.chances.put(this.currentSlot - 1, (Object)new Content(ItemStack.EMPTY, base, ChanceLogic.getMaxChancedValue(), tier));
    }

    private void addGemChance(int baseLow, int tierLow, int baseHigh, int tierHigh, boolean high) {
        if (high) {
            this.addChance(baseHigh, tierHigh);
        } else {
            this.addChance(baseLow, tierLow);
        }
    }
}

