/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.xei.widgets;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemEntryList;
import com.gregtechceu.gtceu.integration.xei.handlers.fluid.CycleFluidEntryHandler;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemEntryHandler;
import com.gregtechceu.gtceu.integration.xei.widgets.GTOreByProduct;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GTOreByProductWidget
extends WidgetGroup {
    protected static final IntImmutableList ITEM_INPUT_LOCATIONS = IntImmutableList.of((int[])new int[]{3, 3, 23, 3, 3, 24, 23, 71, 50, 80, 24, 25, 97, 71, 70, 80, 114, 48, 133, 71, 3, 123, 41, 145, 102, 145, 24, 48, 155, 71, 101, 25});
    protected static final IntImmutableList ITEM_OUTPUT_LOCATIONS = IntImmutableList.of((int[])new int[]{46, 3, 3, 47, 3, 65, 23, 92, 23, 110, 50, 101, 50, 119, 64, 25, 82, 25, 97, 92, 97, 110, 70, 101, 70, 119, 137, 47, 155, 47, 133, 92, 133, 110, 3, 105, 3, 145, 23, 145, 63, 145, 84, 145, 124, 145, 64, 48, 82, 48, 155, 92, 155, 110, 155, 128, 119, 3, 137, 3, 155, 3, 119, 21, 137, 21, 155, 21});
    protected static final IntImmutableList FLUID_LOCATIONS = IntImmutableList.of((int[])new int[]{42, 25, 42, 48});
    protected static final IntSet FINAL_OUTPUT_INDICES = IntSet.of((int[])new int[]{0, 4, 8, 10, 12, 16, 20, 22, 24, 28, 30, 32, 40, 44, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66});

    public GTOreByProductWidget(Material material) {
        super(0, 0, 176, 166);
        this.setClientSideWidget();
        this.setRecipe(new GTOreByProduct(material));
    }

    public void setRecipe(GTOreByProduct recipeWrapper) {
        int i;
        BooleanArrayList itemOutputExists = new BooleanArrayList();
        this.addWidget((Widget)new ImageWidget(ITEM_INPUT_LOCATIONS.getInt(0), ITEM_INPUT_LOCATIONS.getInt(1), 18, 18, (IGuiTexture)GuiTextures.SLOT));
        boolean hasSifter = recipeWrapper.hasSifter();
        this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_BASE));
        if (recipeWrapper.hasDirectSmelt()) {
            this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_SMELT));
        }
        if (recipeWrapper.hasChemBath()) {
            this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_CHEM));
        }
        if (recipeWrapper.hasSeparator()) {
            this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_SEP));
        }
        if (hasSifter) {
            this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_SIFT));
        }
        List<ItemEntryList> itemInputs = recipeWrapper.itemInputs;
        CycleItemEntryHandler itemInputsHandler = new CycleItemEntryHandler(itemInputs);
        WidgetGroup itemStackGroup = new WidgetGroup();
        for (int i2 = 0; i2 < ITEM_INPUT_LOCATIONS.size(); i2 += 2) {
            int finalI = i2;
            itemStackGroup.addWidget(new SlotWidget(itemInputsHandler, i2 / 2, ITEM_INPUT_LOCATIONS.getInt(i2), ITEM_INPUT_LOCATIONS.getInt(i2 + 1)).setCanTakeItems(false).setCanPutItems(false).setIngredientIO(IngredientIO.INPUT).setOnAddedTooltips((slot, tooltips) -> recipeWrapper.getTooltip(finalI / 2, (List<Component>)tooltips)).setBackground(new IGuiTexture[]{null}));
        }
        NonNullList<ItemStack> itemOutputs = recipeWrapper.itemOutputs;
        CustomItemStackHandler itemOutputsHandler = new CustomItemStackHandler(itemOutputs);
        for (int i3 = 0; i3 < ITEM_OUTPUT_LOCATIONS.size(); i3 += 2) {
            int slotIndex = i3 / 2;
            float xeiChance = 1.0f;
            Content chance = recipeWrapper.getChance(i3 / 2 + itemInputs.size());
            IGuiTexture overlay = null;
            if (chance != null) {
                xeiChance = (float)chance.chance / (float)chance.maxChance;
                overlay = chance.createOverlay(false, 0, 0, null);
            }
            if (((ItemStack)itemOutputs.get(slotIndex)).isEmpty()) {
                itemOutputExists.add(false);
                continue;
            }
            itemStackGroup.addWidget(new SlotWidget((IItemHandlerModifiable)itemOutputsHandler, slotIndex, ITEM_OUTPUT_LOCATIONS.getInt(i3), ITEM_OUTPUT_LOCATIONS.getInt(i3 + 1)).setCanTakeItems(false).setCanPutItems(false).setIngredientIO(FINAL_OUTPUT_INDICES.contains(i3) ? IngredientIO.OUTPUT : IngredientIO.BOTH).setXEIChance(xeiChance).setOnAddedTooltips((slot, tooltips) -> recipeWrapper.getTooltip(slotIndex + itemInputs.size(), (List<Component>)tooltips)).setBackground(new IGuiTexture[]{null}).setOverlay(overlay));
            itemOutputExists.add(true);
        }
        List<FluidEntryList> fluidInputs = recipeWrapper.fluidInputs;
        CycleFluidEntryHandler fluidInputsHandler = new CycleFluidEntryHandler(fluidInputs);
        WidgetGroup fluidStackGroup = new WidgetGroup();
        for (i = 0; i < FLUID_LOCATIONS.size(); i += 2) {
            int slotIndex = i / 2;
            if (fluidInputs.get(slotIndex).isEmpty()) continue;
            TankWidget tank = new TankWidget(new CustomFluidTank(fluidInputsHandler.getFluidInTank(slotIndex)), FLUID_LOCATIONS.getInt(i), FLUID_LOCATIONS.getInt(i + 1), false, false).setIngredientIO(IngredientIO.INPUT).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT).setShowAmount(false);
            fluidStackGroup.addWidget((Widget)tank);
        }
        this.addWidget((Widget)itemStackGroup);
        this.addWidget((Widget)fluidStackGroup);
        for (i = 0; i < ITEM_OUTPUT_LOCATIONS.size(); i += 2) {
            if (!itemOutputExists.getBoolean(i / 2) && (i <= 56 || !itemOutputExists.getBoolean(28) || !hasSifter)) continue;
            this.addWidget(this.widgets.size() - 3, (Widget)new ImageWidget(ITEM_OUTPUT_LOCATIONS.getInt(i), ITEM_OUTPUT_LOCATIONS.getInt(i + 1), 18, 18, (IGuiTexture)GuiTextures.SLOT));
        }
    }
}

