/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class EntityDamageUtil {
    public static void applyTemperatureDamage(@NotNull LivingEntity entity, int temperature, float multiplier, int maximum) {
        if (temperature > 320) {
            int damage = (int)(multiplier * (float)(temperature - 300) / 50.0f);
            if (maximum > 0) {
                damage = Math.min(maximum, damage);
            }
            EntityDamageUtil.applyHeatDamage(entity, damage);
        } else if (temperature < 260) {
            int damage = (int)(multiplier * (float)(273 - temperature) / 25.0f);
            if (maximum > 0) {
                damage = Math.min(maximum, damage);
            }
            EntityDamageUtil.applyFrostDamage(entity, damage);
        }
    }

    public static void applyHeatDamage(@NotNull LivingEntity entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.isAlive()) {
            return;
        }
        if (entity.getType().is(CustomTags.HEAT_IMMUNE)) {
            return;
        }
        if (entity.getEffect(MobEffects.FIRE_RESISTANCE) != null) {
            return;
        }
        entity.hurt(GTDamageTypes.HEAT.source((LevelAccessor)entity.level()), (float)damage);
    }

    public static void applyFrostDamage(@NotNull LivingEntity entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.isAlive()) {
            return;
        }
        if (entity.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES)) {
            return;
        }
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.FEET);
        if (!stack.isEmpty() && stack.getEnchantmentLevel(Enchantments.FROST_WALKER) > 0) {
            stack.hurtAndBreak(1, entity, ent -> ent.broadcastBreakEvent(EquipmentSlot.FEET));
            return;
        }
        entity.hurt(entity.damageSources().freeze(), (float)damage);
    }

    public static void applyChemicalDamage(@NotNull LivingEntity entity, int damage) {
        if (damage <= 0) {
            return;
        }
        if (!entity.isAlive()) {
            return;
        }
        if (entity.getType().is(CustomTags.CHEMICAL_IMMUNE)) {
            return;
        }
        entity.hurt(GTDamageTypes.CHEMICAL.source((LevelAccessor)entity.level()), (float)damage);
        entity.addEffect(new MobEffectInstance(MobEffects.POISON, damage * 100, 1));
    }
}

