/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public final class GTHashMaps {
    private GTHashMaps() {
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemHandler(@NotNull IItemHandler inputs) {
        return GTHashMaps.fromItemHandler(inputs, false);
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemHandler(@NotNull IItemHandler inputs, boolean linked) {
        Object2IntMap<ItemStack> map = GTHashMaps.createItemStackMap(linked);
        for (int i = 0; i < inputs.getSlots(); ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            map.put((Object)stack.copy(), map.getInt((Object)stack) + stack.getCount());
        }
        return map;
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemStackCollection(@NotNull Iterable<ItemStack> inputs) {
        return GTHashMaps.fromItemStackCollection(inputs, false);
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemStackCollection(@NotNull Iterable<ItemStack> inputs, boolean linked) {
        Object2IntMap<ItemStack> map = GTHashMaps.createItemStackMap(linked);
        for (ItemStack stack : inputs) {
            if (stack.isEmpty()) continue;
            map.put((Object)stack.copy(), map.getInt((Object)stack) + stack.getCount());
        }
        return map;
    }

    @NotNull
    public static Object2IntMap<ItemStack> createItemStackMap(boolean linked) {
        ItemStackHashStrategy strategy = ItemStackHashStrategy.comparingAllButCount();
        return linked ? new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)strategy) : new Object2IntOpenCustomHashMap((Hash.Strategy)strategy);
    }

    public static Map<FluidStack, Integer> fromFluidHandler(IFluidHandler fluidInputs) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i < fluidInputs.getTanks(); ++i) {
            FluidStack fluidStack = fluidInputs.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            map.addTo((Object)fluidStack, fluidStack.getAmount());
        }
        return map;
    }

    public static Map<FluidStack, Integer> fromFluidCollection(Iterable<FluidStack> fluidInputs) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (FluidStack fluidStack : fluidInputs) {
            if (fluidStack == null || fluidStack.isEmpty()) continue;
            map.addTo((Object)fluidStack, fluidStack.getAmount());
        }
        return map;
    }
}

