/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.gregtechceu.gtceu.utils.ToolItemHelper;
import com.gregtechceu.gtceu.utils.WeightedEntry;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTUtil {
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final ImmutableList<BlockPos> NON_CORNER_NEIGHBOURS = (ImmutableList)Util.make(() -> {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)18);
        BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).filter(pos -> (pos.getX() == 0 || pos.getY() == 0 || pos.getZ() == 0) && !pos.equals((Object)BlockPos.ZERO)).map(BlockPos::immutable).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    });
    private static final Object2IntMap<String> RVN = new Object2IntArrayMap((Object[])GTValues.VN, GTValues.ALL_TIERS);
    private static final MapColor[] MAP_COLORS;

    public static int getTierByName(String name) {
        return RVN.getOrDefault((Object)name, -1);
    }

    @Nullable
    public static Direction determineWrenchingSide(Direction facing, float x, float y, float z) {
        Direction opposite = facing.getOpposite();
        switch (facing) {
            case DOWN: 
            case UP: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return Direction.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return Direction.EAST;
                }
                if ((double)z < 0.25) {
                    return Direction.NORTH;
                }
                if ((double)z > 0.75) {
                    return Direction.SOUTH;
                }
                return facing;
            }
            case NORTH: 
            case SOUTH: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.EAST;
                }
                if ((double)y < 0.25) {
                    return Direction.DOWN;
                }
                if ((double)y > 0.75) {
                    return Direction.UP;
                }
                return facing;
            }
            case WEST: 
            case EAST: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.NORTH;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return Direction.SOUTH;
                }
                if ((double)y < 0.25) {
                    return Direction.DOWN;
                }
                if ((double)y > 0.75) {
                    return Direction.UP;
                }
                return facing;
            }
        }
        return null;
    }

    @Nullable
    public static Direction getFacingToNeighbor(@NotNull BlockPos main, @NotNull BlockPos neighbor) {
        int difX = neighbor.getX() - main.getX();
        int difY = neighbor.getY() - main.getY();
        int difZ = neighbor.getZ() - main.getZ();
        if (difX != 0) {
            if (difY != 0 || difZ != 0 || difX != 1 && difX != -1) {
                return null;
            }
            return difX > 0 ? Direction.EAST : Direction.WEST;
        }
        if (difY != 0) {
            if (difZ != 0 || difY != 1 && difY != -1) {
                return null;
            }
            return difY > 0 ? Direction.UP : Direction.DOWN;
        }
        if (difZ != 0) {
            if (difZ != 1 && difZ != -1) {
                return null;
            }
            return difZ > 0 ? Direction.SOUTH : Direction.NORTH;
        }
        return null;
    }

    public static float getExplosionPower(long voltage) {
        return GTUtil.getTierByVoltage(voltage) + 1;
    }

    public static int nearestLesserOrEqual(@NotNull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] <= value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static int nearestLesser(@NotNull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] < value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static byte getTierByVoltage(long voltage) {
        if (voltage > Integer.MAX_VALUE) {
            return 14;
        }
        return GTUtil.getOCTierByVoltage(voltage);
    }

    public static byte getOCTierByVoltage(long voltage) {
        if (voltage <= GTValues.V[0]) {
            return 0;
        }
        return (byte)(62 - Long.numberOfLeadingZeros(voltage - 1L) >> 1);
    }

    public static byte getFloorTierByVoltage(long voltage) {
        if (voltage < GTValues.V[1]) {
            return 0;
        }
        if (voltage == GTValues.VEX[30]) {
            return 30;
        }
        return (byte)(60 - Long.numberOfLeadingZeros(voltage) >> 1);
    }

    @NotNull
    public static ItemStack copyFirst(ItemStack ... stacks) {
        if (stacks.length == 0) {
            throw new IllegalArgumentException("Empty ItemStack candidates");
        }
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            return stack.copy();
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public static ItemStack copyFirst(int newCount, ItemStack ... stacks) {
        if (stacks.length == 0) {
            throw new IllegalArgumentException("Empty ItemStack candidates");
        }
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            return stack.copyWithCount(newCount);
        }
        return ItemStack.EMPTY;
    }

    public static <M> M getItem(List<? extends M> list, int index, M replacement) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return replacement;
    }

    @Nullable
    public static <T extends WeightedEntry> T getRandomItem(RandomSource random, List<T> randomList) {
        if (randomList.isEmpty()) {
            return null;
        }
        int size = randomList.size();
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            int weight = ((WeightedEntry)randomList.get(i)).weight();
            if (weight <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + weight);
            }
            baseOffsets[i] = currentIndex += weight;
        }
        int randomValue = random.nextInt(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return (T)((WeightedEntry)randomList.get(i));
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    @Nullable
    public static <T extends WeightedEntry> T getRandomItem(List<T> randomList) {
        return GTUtil.getRandomItem(GTValues.RNG, randomList);
    }

    public static <T, R> Class<T> getActualTypeParameter(Class<? extends R> thisClass, int index) {
        Type type = thisClass.getGenericSuperclass();
        return (Class)((ParameterizedType)type).getActualTypeArguments()[index];
    }

    public static boolean isShiftDown() {
        if (GTCEu.isClientSide()) {
            long id = Minecraft.getInstance().getWindow().getWindow();
            return InputConstants.isKeyDown((long)id, (int)340) || InputConstants.isKeyDown((long)id, (int)340);
        }
        return false;
    }

    public static boolean isCtrlDown() {
        if (GTCEu.isClientSide()) {
            long id = Minecraft.getInstance().getWindow().getWindow();
            return InputConstants.isKeyDown((long)id, (int)341) || InputConstants.isKeyDown((long)id, (int)345);
        }
        return false;
    }

    public static boolean isAltDown() {
        if (GTCEu.isClientSide()) {
            long id = Minecraft.getInstance().getWindow().getWindow();
            return InputConstants.isKeyDown((long)id, (int)342) || InputConstants.isKeyDown((long)id, (int)346);
        }
        return false;
    }

    public static boolean isFluidStackAmountDivisible(FluidStack fluidStack, int divisor) {
        return fluidStack.getAmount() % divisor == 0 && fluidStack.getAmount() % divisor != fluidStack.getAmount() && fluidStack.getAmount() / divisor != 0;
    }

    public static boolean isItemStackCountDivisible(ItemStack itemStack, int divisor) {
        return itemStack.getCount() % divisor == 0 && itemStack.getCount() % divisor != itemStack.getCount() && itemStack.getCount() / divisor != 0;
    }

    public static int getItemBurnTime(Item item) {
        return ForgeHooks.getBurnTime((ItemStack)item.getDefaultInstance(), null);
    }

    public static int getPumpBiomeModifier(Holder<Biome> biome) {
        if (biome.is(BiomeTags.IS_NETHER)) {
            return -1;
        }
        if (biome.is(BiomeTags.IS_DEEP_OCEAN) || biome.is(BiomeTags.IS_OCEAN) || biome.is(BiomeTags.IS_BEACH) || biome.is(BiomeTags.IS_RIVER)) {
            return 1000;
        }
        if (biome.is(Tags.Biomes.IS_SWAMP) || biome.is(Tags.Biomes.IS_WET)) {
            return 800;
        }
        if (biome.is(BiomeTags.IS_JUNGLE)) {
            return 350;
        }
        if (biome.is(Tags.Biomes.IS_SNOWY)) {
            return 300;
        }
        if (biome.is(Tags.Biomes.IS_PLAINS) || biome.is(BiomeTags.IS_FOREST)) {
            return 250;
        }
        if (biome.is(Tags.Biomes.IS_COLD)) {
            return 175;
        }
        if (biome.is(CustomTags.IS_SANDY)) {
            return 170;
        }
        return 100;
    }

    public static DyeColor determineDyeColor(int rgbColor) {
        return GTUtil.closestColor(rgbColor, DyeColor.values(), DyeColor::getTextColor);
    }

    public static MapColor determineMapColor(int rgbColor) {
        return GTUtil.closestColor(rgbColor, MAP_COLORS, c -> c.calculateRGBColor(MapColor.Brightness.NORMAL));
    }

    private static <T> T closestColor(int rgbColor, T[] colors, Function<T, Integer> extractRgbColor) {
        float[] c = GradientUtil.getRGB(rgbColor);
        double min = Double.MAX_VALUE;
        T minColor = null;
        for (T color : colors) {
            float[] c2 = GradientUtil.getRGB(extractRgbColor.apply(color));
            double distance = (c[0] - c2[0]) * (c[0] - c2[0]) + (c[1] - c2[1]) * (c[1] - c2[1]) + (c[2] - c2[2]) * (c[2] - c2[2]);
            if (Double.compare(min, distance) <= 0) continue;
            minColor = color;
            min = distance;
        }
        return minColor;
    }

    public static int convertRGBtoARGB(int colorValue) {
        return GTUtil.convertRGBtoARGB(colorValue, 255);
    }

    public static int convertRGBtoARGB(int colorValue, int opacity) {
        if ((colorValue >> 24 & 0xFF) != 0) {
            return colorValue;
        }
        return opacity << 24 | colorValue;
    }

    @Nullable
    public static Fluid getMoltenFluid(@NotNull Material material) {
        if (material.hasProperty(PropertyKey.ALLOY_BLAST)) {
            return material.getProperty(PropertyKey.FLUID).getStorage().get(FluidStorageKeys.MOLTEN);
        }
        if (!TagPrefix.ingotHot.doGenerateItem(material) && material.hasProperty(PropertyKey.FLUID)) {
            return material.getProperty(PropertyKey.FLUID).getStorage().get(FluidStorageKeys.LIQUID);
        }
        return null;
    }

    public static int getFluidColor(FluidStack fluid) {
        return IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid);
    }

    public static boolean canSeeSunClearly(Level world, BlockPos blockPos) {
        if (!world.canSeeSky(blockPos.above())) {
            return false;
        }
        Biome biome = (Biome)world.getBiome(blockPos.above()).value();
        if (world.isRaining() && (biome.warmEnoughToRain(blockPos.above()) || biome.coldEnoughToSnow(blockPos.above()))) {
            return false;
        }
        if (world.getBiome(blockPos.above()).is(BiomeTags.IS_END)) {
            return false;
        }
        ResourceLocation javdVoidBiome = new ResourceLocation("javd", "void");
        if (GTCEu.Mods.isJAVDLoaded() && world.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome).equals((Object)javdVoidBiome)) {
            return !world.isDay();
        }
        return world.isDay();
    }

    public static boolean isBlockSnow(@NotNull BlockState state) {
        return state.is(Blocks.SNOW) || state.is(Blocks.SNOW_BLOCK);
    }

    public static boolean tryBreakSnow(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, boolean playSound) {
        boolean success = false;
        if (state.is(Blocks.SNOW_BLOCK)) {
            level.setBlock(pos, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(7)), 11);
            success = true;
        } else if (state.getBlock() == Blocks.SNOW) {
            int layers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
            if (layers == 1) {
                level.destroyBlock(pos, false);
            } else {
                level.setBlock(pos, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers - 1)), 11);
            }
            success = true;
        }
        if (success && playSound) {
            level.playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return success;
    }

    public static void appendHazardTooltips(Material material, List<Component> tooltipComponents) {
        if (!ConfigHolder.INSTANCE.gameplay.hazardsEnabled || !material.hasProperty(PropertyKey.HAZARD)) {
            return;
        }
        if (GTUtil.isShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"gtceu.medical_condition.description_shift"));
            tooltipComponents.add((Component)Component.translatable((String)("gtceu.medical_condition." + material.getProperty(PropertyKey.HAZARD).condition.name)));
            tooltipComponents.add((Component)Component.translatable((String)"gtceu.hazard_trigger.description"));
            tooltipComponents.add((Component)Component.translatable((String)("gtceu.hazard_trigger." + material.getProperty(PropertyKey.HAZARD).hazardTrigger.name())));
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"gtceu.medical_condition.description"));
    }

    public static CompoundTag saveItemStack(ItemStack itemStack, CompoundTag compoundTag) {
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        compoundTag.putString("id", resourceLocation.toString());
        compoundTag.putInt("Count", itemStack.getCount());
        if (itemStack.getTag() != null) {
            compoundTag.put("tag", (Tag)itemStack.getTag().copy());
        }
        return compoundTag;
    }

    public static ItemStack loadItemStack(CompoundTag compoundTag) {
        try {
            Item item = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(compoundTag.getString("id")));
            int count = compoundTag.getInt("Count");
            ItemStack stack = new ItemStack((ItemLike)item, count);
            if (compoundTag.contains("tag", 10)) {
                stack.setTag(compoundTag.getCompound("tag"));
                if (stack.getTag() != null) {
                    stack.getItem().verifyTagAfterLoad(stack.getTag());
                }
            }
            if (stack.isDamageableItem()) {
                stack.setDamageValue(stack.getDamageValue());
            }
            return stack;
        }
        catch (RuntimeException var2) {
            GTCEu.LOGGER.debug("Tried to load invalid item: {}", (Object)compoundTag, (Object)var2);
            return ItemStack.EMPTY;
        }
    }

    public static Tuple<ItemStack, MutableComponent> getMaintenanceText(byte flag) {
        return switch (flag) {
            case 0 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.WRENCH), (Object)Component.translatable((String)"gtceu.top.maintenance.wrench"));
            case 1 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.SCREWDRIVER), (Object)Component.translatable((String)"gtceu.top.maintenance.screwdriver"));
            case 2 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.SOFT_MALLET), (Object)Component.translatable((String)"gtceu.top.maintenance.soft_mallet"));
            case 3 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.HARD_HAMMER), (Object)Component.translatable((String)"gtceu.top.maintenance.hard_hammer"));
            case 4 -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.WIRE_CUTTER), (Object)Component.translatable((String)"gtceu.top.maintenance.wire_cutter"));
            default -> new Tuple((Object)ToolItemHelper.getToolItem(GTToolType.CROWBAR), (Object)Component.translatable((String)"gtceu.top.maintenance.crowbar"));
        };
    }

    public static void addPotionTooltip(List<Pair<MobEffectInstance, Float>> effects, List<Component> list) {
        if (!effects.isEmpty()) {
            list.add((Component)Component.translatable((String)"gtceu.tooltip.potion.header"));
        }
        effects.forEach(pair -> {
            MobEffectInstance effect = (MobEffectInstance)pair.getFirst();
            float probability = ((Float)pair.getSecond()).floatValue();
            list.add((Component)Component.translatable((String)"gtceu.tooltip.potion.each", (Object[])new Object[]{Component.translatable((String)effect.getDescriptionId()).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)), Component.translatable((String)("enchantment.level." + (effect.getAmplifier() + 1))).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW)), Component.literal((String)String.valueOf(effect.getDuration())).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), Component.literal((String)String.valueOf(100.0f * probability)).setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN))}));
        });
    }

    public static boolean isSameItemSameTags(ItemStack s1, ItemStack s2) {
        return ItemStack.isSameItem((ItemStack)s1, (ItemStack)s2) && Objects.equals(s1.getTag(), s2.getTag());
    }

    public static <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> ArrayList<T> list(T obj) {
        return new ArrayList<T>(List.of(obj));
    }

    static {
        int maxId = MapColor.GLOW_LICHEN.id;
        MAP_COLORS = new MapColor[maxId];
        for (int i = 0; i < maxId; ++i) {
            GTUtil.MAP_COLORS[i] = MapColor.byId((int)(i + 1));
        }
    }
}

