/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface ItemStackHashStrategy
extends Hash.Strategy<ItemStack> {
    public static ItemStackHashStrategyBuilder builder() {
        return new ItemStackHashStrategyBuilder();
    }

    public static ItemStackHashStrategy comparingAll() {
        return ItemStackHashStrategyBuilder.ALL;
    }

    public static ItemStackHashStrategy comparingAllButCount() {
        return ItemStackHashStrategyBuilder.ITEM_AND_TAG;
    }

    public static ItemStackHashStrategy comparingItem() {
        return ItemStackHashStrategyBuilder.ITEM;
    }

    public static class ItemStackHashStrategyBuilder {
        private static final ItemStackHashStrategy ALL = ItemStackHashStrategy.builder().compareItem(true).compareCount(true).compareTag(true).build();
        private static final ItemStackHashStrategy ITEM_AND_TAG = ItemStackHashStrategy.builder().compareItem(true).compareTag(true).build();
        private static final ItemStackHashStrategy ITEM = ItemStackHashStrategy.builder().compareItem(true).build();
        private boolean item;
        private boolean count;
        private boolean tag;

        public ItemStackHashStrategyBuilder compareItem(boolean choice) {
            this.item = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareCount(boolean choice) {
            this.count = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareTag(boolean choice) {
            this.tag = choice;
            return this;
        }

        public ItemStackHashStrategy build() {
            return new ItemStackHashStrategy(){

                public int hashCode(@Nullable ItemStack o) {
                    return o == null || o.isEmpty() ? 0 : Objects.hash(item ? o.getItem() : null, count ? Integer.valueOf(o.getCount()) : null, tag ? o.getTag() : null);
                }

                public boolean equals(@Nullable ItemStack a, @Nullable ItemStack b) {
                    if (a == null || a.isEmpty()) {
                        return b == null || b.isEmpty();
                    }
                    if (b == null || b.isEmpty()) {
                        return false;
                    }
                    return !(item && a.getItem() != b.getItem() || count && a.getCount() != b.getCount() || tag && !Objects.equals(a.getTag(), b.getTag()));
                }
            };
        }
    }
}

