/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerEnergyStack;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.utils.GTMath;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EURecipeCapability
extends RecipeCapability<EnergyStack> {
    public static final EURecipeCapability CAP = new EURecipeCapability();

    protected EURecipeCapability() {
        super("eu", -256, false, 2, SerializerEnergyStack.INSTANCE);
    }

    @Override
    public EnergyStack copyInner(EnergyStack content) {
        return content;
    }

    @Override
    public EnergyStack copyWithModifier(EnergyStack content, ContentModifier modifier) {
        return content.withVoltage(modifier.apply(content.voltage()));
    }

    @Override
    public int limitMaxParallelByOutput(IRecipeCapabilityHolder holder, GTRecipe recipe, int multiplier, boolean tick) {
        if (holder instanceof ICustomParallel) {
            ICustomParallel p = (ICustomParallel)((Object)holder);
            return p.limitEUParallel(recipe, multiplier, tick);
        }
        if (tick) {
            long recipeEUt = recipe.getOutputEUt().getTotalEU();
            if (recipeEUt == 0L) {
                return multiplier;
            }
            long maxVoltage = Long.MAX_VALUE;
            if (holder instanceof IOverclockMachine) {
                IOverclockMachine overclockMachine = (IOverclockMachine)((Object)holder);
                maxVoltage = overclockMachine.getOverclockVoltage();
            } else if (holder instanceof ITieredMachine) {
                ITieredMachine tieredMachine = (ITieredMachine)((Object)holder);
                maxVoltage = tieredMachine.getMaxVoltage();
            }
            return Math.min(multiplier, Math.abs(GTMath.saturatedCast(maxVoltage / recipeEUt)));
        }
        List<Content> outputs = recipe.getOutputContents(this);
        if (outputs.isEmpty()) {
            return multiplier;
        }
        if (!holder.hasCapabilityProxies()) {
            return 0;
        }
        List<IRecipeHandler<?>> handlers = holder.getCapabilitiesFlat(IO.OUT, this);
        if (handlers.isEmpty()) {
            return 0;
        }
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        long totalEU = 0L;
        for (Content content : outputs) {
            totalEU += ((EnergyStack)this.of(content.content)).getTotalEU();
        }
        if (totalEU != 0L && (long)multiplier > Long.MAX_VALUE / totalEU) {
            maxMultiplier = multiplier = GTMath.saturatedCast(Long.MAX_VALUE / totalEU);
        }
        while (minMultiplier != maxMultiplier) {
            IRecipeHandler<?> handler;
            Object eu = LongList.of((long)(totalEU * (long)multiplier));
            Iterator<IRecipeHandler<?>> iterator = handlers.iterator();
            while (iterator.hasNext() && (eu = (handler = iterator.next()).handleRecipe(IO.OUT, recipe, (List<?>)eu, true)) != null) {
            }
            int[] nArray = ParallelLogic.adjustMultiplier(eu == null, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = nArray[0];
            multiplier = nArray[1];
            maxMultiplier = nArray[2];
        }
        return multiplier;
    }

    @Override
    public int getMaxParallelByInput(IRecipeCapabilityHolder holder, GTRecipe recipe, int limit, boolean tick) {
        if (tick) {
            long maxVoltage = Long.MAX_VALUE;
            if (holder instanceof IOverclockMachine) {
                IOverclockMachine overclockMachine = (IOverclockMachine)((Object)holder);
                maxVoltage = overclockMachine.getOverclockVoltage();
            } else if (holder instanceof ITieredMachine) {
                ITieredMachine tieredMachine = (ITieredMachine)((Object)holder);
                maxVoltage = tieredMachine.getMaxVoltage();
            }
            long recipeEUt = recipe.getInputEUt().getTotalEU();
            if (recipeEUt == 0L) {
                return limit;
            }
            return Math.min(limit, Math.abs(GTMath.saturatedCast(maxVoltage / recipeEUt)));
        }
        if (!holder.hasCapabilityProxies()) {
            return 0;
        }
        List<Content> inputs = recipe.getInputContents(this);
        if (inputs.isEmpty()) {
            return limit;
        }
        long nonConsumable = 0L;
        long consumable = 0L;
        for (Content content : inputs) {
            EnergyStack s = (EnergyStack)this.of(content.content);
            if (content.chance == 0) {
                nonConsumable += s.getTotalEU();
                continue;
            }
            consumable += s.getTotalEU();
        }
        if (nonConsumable == 0L && consumable == 0L) {
            return limit;
        }
        long sum = 0L;
        for (IRecipeHandler<?> handler : holder.getCapabilitiesFlat(IO.IN, this)) {
            for (Object content : handler.getContents()) {
                if (content instanceof EnergyStack) {
                    EnergyStack es = (EnergyStack)content;
                    sum += es.getTotalEU();
                    continue;
                }
                if (!(content instanceof Long)) continue;
                Long l = (Long)content;
                sum += l.longValue();
            }
        }
        if (sum < nonConsumable) {
            return 0;
        }
        return Math.min(GTMath.saturatedCast((sum -= nonConsumable) / consumable), limit);
    }

    public static List<Content> makeEUContent(EnergyStack eu) {
        return List.of(new Content(eu, ChanceLogic.getMaxChancedValue(), ChanceLogic.getMaxChancedValue(), 0));
    }

    public static void putEUContent(Map<RecipeCapability<?>, List<Content>> contents, EnergyStack eu) {
        contents.put(CAP, EURecipeCapability.makeEUContent(eu));
    }

    public static interface ICustomParallel {
        public int limitEUParallel(GTRecipe var1, int var2, boolean var3);
    }
}

