/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import java.util.function.IntSupplier;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ColorBlockWidget
extends Widget {
    private IntSupplier colorSupplier;
    private int currentColor = -1;
    private static boolean isShowAlpha = false;

    public ColorBlockWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.isClientSideWidget && this.colorSupplier != null) {
            this.currentColor = this.colorSupplier.getAsInt();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            ColorBlockWidget.playButtonClickSound();
            isShowAlpha = !isShowAlpha;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.getPosition().x + 1;
        int y = this.getPosition().y + 1;
        int width = this.getSize().width - 2;
        int height = this.getSize().height - 2;
        if (this.colorSupplier != null) {
            this.currentColor = this.colorSupplier.getAsInt();
        }
        int BORDER_COLOR = -16777216;
        int opaqueColor = isShowAlpha ? this.currentColor : this.currentColor | 0xFF000000;
        graphics.m_280509_(x, y, x + width, y + height, opaqueColor);
        DrawerHelper.drawBorder((GuiGraphics)graphics, (int)x, (int)y, (int)width, (int)height, (int)-16777216, (int)1);
    }

    @NotNull
    @Generated
    public ColorBlockWidget setColorSupplier(IntSupplier colorSupplier) {
        this.colorSupplier = colorSupplier;
        return this;
    }

    @NotNull
    @Generated
    public ColorBlockWidget setCurrentColor(int currentColor) {
        this.currentColor = currentColor;
        return this;
    }

    @Generated
    public int getCurrentColor() {
        return this.currentColor;
    }
}

