/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.common.data.item.GTToolActions;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TreeFellingBehavior
implements IToolBehavior {
    public static final TreeFellingBehavior INSTANCE = new TreeFellingBehavior();

    protected TreeFellingBehavior() {
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return action == GTToolActions.AXE_FELL_TREE;
    }

    @Override
    public void addBehaviorNBT(ItemStack stack, CompoundTag tag) {
        tag.m_128379_("TreeFelling", true);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.tree_felling"));
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> onItemRightClick(Level level, Player player, InteractionHand hand) {
        CompoundTag tag;
        ItemStack held = player.m_21120_(hand);
        if (!(level instanceof ServerLevel) || !player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        boolean disable = (tag = ToolHelper.getBehaviorsTag(held)).m_128471_("DisableTreeFelling");
        tag.m_128379_("DisableTreeFelling", !disable);
        player.m_213846_((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.tree_felling").m_130946_(" - ").m_7220_((Component)Component.m_237115_((String)("cover.voiding.label." + (disable ? "enabled" : "disabled")))));
        return InteractionResultHolder.m_19090_((Object)held);
    }
}

