/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.IVoidable;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.ActionResult;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.VoidFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DistillationTowerMachine
extends WorkableElectricMultiblockMachine
implements FluidRecipeCapability.ICustomParallel {
    private List<IFluidHandler> fluidOutputs;
    @Nullable
    private IFluidHandler firstValid = null;
    private final int yOffset;

    public DistillationTowerMachine(IMachineBlockEntity holder) {
        this(holder, 1);
    }

    public DistillationTowerMachine(IMachineBlockEntity holder, int yOffset) {
        super(holder, new Object[0]);
        this.yOffset = yOffset;
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new DistillationTowerLogic(this);
    }

    @Override
    public DistillationTowerLogic getRecipeLogic() {
        return (DistillationTowerLogic)super.getRecipeLogic();
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        int startY = this.getPos().m_123342_() + this.yOffset;
        List<IMultiPart> parts = this.getParts().stream().filter(part -> PartAbility.EXPORT_FLUIDS.isApplicable(part.self().getBlockState().m_60734_())).filter(part -> part.self().getPos().m_123342_() >= startY).toList();
        if (!parts.isEmpty()) {
            int maxY = parts.get(parts.size() - 1).self().getPos().m_123342_();
            this.fluidOutputs = new ObjectArrayList(maxY - startY);
            int outputIndex = 0;
            for (int y = startY; y <= maxY; ++y) {
                if (parts.size() <= outputIndex) {
                    this.fluidOutputs.add((IFluidHandler)VoidFluidHandler.INSTANCE);
                    continue;
                }
                IMultiPart part2 = parts.get(outputIndex);
                if (part2.self().getPos().m_123342_() == y) {
                    IFluidHandler handler = part2.getRecipeHandlers().get(0).getCapability(FluidRecipeCapability.CAP).stream().filter(IFluidHandler.class::isInstance).findFirst().map(IFluidHandler.class::cast).orElse((IFluidHandler)VoidFluidHandler.INSTANCE);
                    this.addOutput(handler);
                    ++outputIndex;
                    continue;
                }
                if (part2.self().getPos().m_123342_() > y) {
                    this.fluidOutputs.add((IFluidHandler)VoidFluidHandler.INSTANCE);
                    continue;
                }
                GTCEu.LOGGER.error("The Distillation Tower at {} has a fluid export hatch with an unexpected Y position", (Object)this.getPos());
                this.onStructureInvalid();
                return;
            }
        } else {
            this.onStructureInvalid();
        }
    }

    private void addOutput(IFluidHandler handler) {
        this.fluidOutputs.add(handler);
        if (this.firstValid == null && handler != VoidFluidHandler.INSTANCE) {
            this.firstValid = handler;
        }
    }

    @Override
    public void onStructureInvalid() {
        this.fluidOutputs = null;
        this.firstValid = null;
        super.onStructureInvalid();
    }

    @Override
    public int limitFluidParallel(GTRecipe recipe, int multiplier, boolean tick) {
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        List<Content> contents = (tick ? recipe.tickInputs : recipe.inputs).get(FluidRecipeCapability.CAP);
        if (contents == null || contents.isEmpty()) {
            return multiplier;
        }
        int maxAmount = contents.stream().map(Content::getContent).map(FluidRecipeCapability.CAP::of).filter(i -> !i.isEmpty()).mapToInt(FluidIngredient::getAmount).max().orElse(0);
        if (maxAmount == 0) {
            return multiplier;
        }
        if (multiplier > Integer.MAX_VALUE / maxAmount) {
            maxMultiplier = multiplier = Integer.MAX_VALUE / maxAmount;
        }
        while (minMultiplier != maxMultiplier) {
            GTRecipe copy = DistillationTowerMachine.modifyOutputs(recipe, ContentModifier.multiplier(multiplier));
            boolean filled = this.getRecipeLogic().applyFluidOutputs(copy, IFluidHandler.FluidAction.SIMULATE, this.getVoidingMode());
            int[] bin = ParallelLogic.adjustMultiplier(filled, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = bin[0];
            multiplier = bin[1];
            maxMultiplier = bin[2];
        }
        return multiplier;
    }

    private static GTRecipe modifyOutputs(GTRecipe recipe, ContentModifier cm) {
        return new GTRecipe(recipe.recipeType, recipe.id, recipe.inputs, cm.applyContents(recipe.outputs), recipe.tickInputs, cm.applyContents(recipe.tickOutputs), recipe.inputChanceLogics, recipe.outputChanceLogics, recipe.tickInputChanceLogics, recipe.tickOutputChanceLogics, recipe.conditions, recipe.ingredientActions, recipe.data, recipe.duration, recipe.recipeCategory);
    }

    @Generated
    public List<IFluidHandler> getFluidOutputs() {
        return this.fluidOutputs;
    }

    @Nullable
    @Generated
    public IFluidHandler getFirstValid() {
        return this.firstValid;
    }

    public static class DistillationTowerLogic
    extends RecipeLogic {
        @Persisted
        @DescSynced
        @Nullable
        GTRecipe workingRecipe = null;

        public DistillationTowerLogic(IRecipeLogicMachine machine) {
            super(machine);
        }

        @Override
        @NotNull
        public DistillationTowerMachine getMachine() {
            return (DistillationTowerMachine)super.getMachine();
        }

        @Override
        @Nullable
        public GTRecipe getLastRecipe() {
            return this.workingRecipe;
        }

        @Override
        protected ActionResult matchRecipe(GTRecipe recipe) {
            ActionResult match = this.matchDTRecipe(recipe);
            if (!match.isSuccess()) {
                return match;
            }
            return RecipeHelper.matchTickRecipe(this.machine, recipe);
        }

        @Override
        protected void handleSearchingRecipes(Iterator<GTRecipe> matches) {
            this.workingRecipe = null;
            super.handleSearchingRecipes(matches);
        }

        private ActionResult matchDTRecipe(GTRecipe recipe) {
            Map<RecipeCapability<?>, List<Content>> out;
            ActionResult result = RecipeHelper.handleRecipe(this.machine, recipe, IO.IN, recipe.inputs, Collections.emptyMap(), false, true);
            if (!result.isSuccess()) {
                return result;
            }
            List<Content> items = recipe.getOutputContents(ItemRecipeCapability.CAP);
            if (!items.isEmpty() && !(result = RecipeHelper.handleRecipe(this.machine, recipe, IO.OUT, out = Map.of(ItemRecipeCapability.CAP, items), Collections.emptyMap(), false, true)).isSuccess()) {
                return result;
            }
            if (!this.applyFluidOutputs(recipe, IFluidHandler.FluidAction.SIMULATE, this.machine.getVoidingMode())) {
                return ActionResult.fail((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_out").m_130946_(": ").m_7220_((Component)FluidRecipeCapability.CAP.getName()), FluidRecipeCapability.CAP, IO.OUT);
            }
            return ActionResult.SUCCESS;
        }

        private void updateWorkingRecipe(GTRecipe recipe) {
            if (recipe.recipeType == GTRecipeTypes.DISTILLERY_RECIPES) {
                this.workingRecipe = recipe;
                return;
            }
            this.workingRecipe = recipe.copy();
            List<Content> contents = recipe.getOutputContents(FluidRecipeCapability.CAP);
            List<IFluidHandler> outputs = this.getMachine().getFluidOutputs();
            ArrayList<Content> trimmed = new ArrayList<Content>(12);
            for (int i = 0; i < Math.min(contents.size(), outputs.size()); ++i) {
                if (outputs.get(i) instanceof VoidFluidHandler) continue;
                trimmed.add(contents.get(i));
            }
            this.workingRecipe.outputs.put(FluidRecipeCapability.CAP, trimmed);
        }

        @Override
        protected ActionResult handleRecipeIO(GTRecipe recipe, IO io) {
            if (io != IO.OUT) {
                ActionResult handleIO = super.handleRecipeIO(recipe, io);
                if (handleIO.isSuccess()) {
                    this.updateWorkingRecipe(recipe);
                } else {
                    this.workingRecipe = null;
                }
                return handleIO;
            }
            List<Content> items = recipe.getOutputContents(ItemRecipeCapability.CAP);
            if (!items.isEmpty()) {
                Map<RecipeCapability<?>, List<Content>> out = Map.of(ItemRecipeCapability.CAP, items);
                RecipeHelper.handleRecipe(this.machine, recipe, io, out, this.chanceCaches, false, false);
            }
            if (this.applyFluidOutputs(recipe, IFluidHandler.FluidAction.EXECUTE, this.machine.getVoidingMode())) {
                this.workingRecipe = null;
                return ActionResult.SUCCESS;
            }
            return ActionResult.fail((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_out").m_130946_(": ").m_7220_((Component)FluidRecipeCapability.CAP.getName()), FluidRecipeCapability.CAP, IO.OUT);
        }

        private boolean applyFluidOutputs(GTRecipe recipe, IFluidHandler.FluidAction action, IVoidable.VoidingMode voidMode) {
            List<FluidIngredient> fluids = recipe.getOutputContents(FluidRecipeCapability.CAP).stream().map(Content::getContent).map(FluidRecipeCapability.CAP::of).toList();
            if (recipe.recipeType == GTRecipeTypes.DISTILLERY_RECIPES) {
                int n;
                FluidStack fluid = fluids.get(0).getStacks()[0];
                IFluidHandler handler = this.getMachine().getFirstValid();
                if (handler == null) {
                    return false;
                }
                if (handler instanceof NotifiableFluidTank) {
                    NotifiableFluidTank nft = (NotifiableFluidTank)handler;
                    n = nft.fillInternal(fluid, action);
                } else {
                    n = handler.fill(fluid, action);
                }
                int filled = n;
                return filled == fluid.getAmount();
            }
            boolean valid = true;
            List<IFluidHandler> outputs = this.getMachine().getFluidOutputs();
            for (int i = 0; i < Math.min(fluids.size(), outputs.size()); ++i) {
                int filled;
                IFluidHandler handler = outputs.get(i);
                FluidStack fluid = fluids.get(i).getStacks()[0];
                if (handler instanceof NotifiableFluidTank) {
                    NotifiableFluidTank nft = (NotifiableFluidTank)handler;
                    v1 = nft.fillInternal(fluid, action);
                } else {
                    v1 = filled = handler.fill(fluid, action);
                }
                if (filled != fluid.getAmount() && !voidMode.canVoid(FluidRecipeCapability.CAP)) {
                    valid = false;
                }
                if (action.simulate() && !valid) break;
            }
            return valid;
        }
    }
}

