/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets.prospecting;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public abstract class SPacketProspect<T>
implements GTNetwork.INetPacket {
    protected final Table<ResourceKey<Level>, BlockPos, T> data;

    protected SPacketProspect() {
        this.data = HashBasedTable.create();
    }

    protected SPacketProspect(Table<ResourceKey<Level>, BlockPos, T> data) {
        this.data = data;
    }

    protected SPacketProspect(Collection<ResourceKey<Level>> keys, Collection<BlockPos> positions, Collection<T> prospected) {
        this();
        Iterator<ResourceKey<Level>> keyIterator = keys.iterator();
        Iterator<BlockPos> posIterator = positions.iterator();
        Iterator<T> prospectedIterator = prospected.iterator();
        while (keyIterator.hasNext()) {
            this.data.put(keyIterator.next(), (Object)posIterator.next(), prospectedIterator.next());
        }
    }

    protected SPacketProspect(ResourceKey<Level> key, Collection<BlockPos> positions, Collection<T> prospected) {
        this.data = HashBasedTable.create((int)1, (int)prospected.size());
        Iterator<BlockPos> posIterator = positions.iterator();
        Iterator<T> prospectedIterator = prospected.iterator();
        while (posIterator.hasNext()) {
            this.data.put(key, (Object)posIterator.next(), prospectedIterator.next());
        }
    }

    protected SPacketProspect(ResourceKey<Level> key, BlockPos position, T prospected) {
        this.data = HashBasedTable.create((int)1, (int)1);
        this.data.put(key, (Object)position, prospected);
    }

    public SPacketProspect(FriendlyByteBuf buf) {
        this();
        int rowCount = buf.readInt();
        for (int i = 0; i < rowCount; ++i) {
            ResourceKey rowKey = buf.m_236801_(Registries.f_256858_);
            int entryCount = buf.readInt();
            for (int j = 0; j < entryCount; ++j) {
                BlockPos blockPos = buf.m_130135_();
                T t = this.decodeData(buf);
                this.data.put((Object)rowKey, (Object)blockPos, t);
            }
        }
    }

    public abstract void encodeData(FriendlyByteBuf var1, T var2);

    public abstract T decodeData(FriendlyByteBuf var1);

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.data.rowKeySet().size());
        this.data.rowMap().forEach((key, entry) -> {
            buf.m_236858_(key);
            buf.writeInt(entry.size());
            entry.forEach((blockPos, t) -> {
                buf.m_130064_(blockPos);
                this.encodeData(buf, t);
            });
        });
    }

    @Override
    public abstract void execute(NetworkEvent.Context var1);
}

