/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.common.data.GTRecipeConditions;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import lombok.Generated;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class GameStageCondition
extends RecipeCondition {
    public static final Codec<GameStageCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse(instance).and((App)Codec.STRING.fieldOf("stageName").forGetter(val -> val.stageName)).apply((Applicative)instance, GameStageCondition::new));
    private String stageName;
    public static final GameStageCondition INSTANCE = new GameStageCondition();

    public GameStageCondition(String stageName) {
        this(false, stageName);
    }

    public GameStageCondition(boolean isReverse, String stageName) {
        super(isReverse);
        this.stageName = stageName;
    }

    @Override
    public RecipeConditionType<?> getType() {
        return GTRecipeConditions.GAMESTAGE;
    }

    @Override
    public Component getTooltips() {
        if (this.isReverse) {
            return Component.m_237110_((String)"recipe.condition.gamestage.locked_stage", (Object[])new Object[]{this.stageName});
        }
        return Component.m_237110_((String)"recipe.condition.gamestage.unlocked_stage", (Object[])new Object[]{this.stageName});
    }

    @Override
    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        MachineOwner owner = recipeLogic.machine.self().getOwner();
        if (owner == null) {
            return false;
        }
        for (UUID player : owner.getMembers()) {
            IStageData playerData = GameStageSaveHandler.getPlayerData((UUID)player);
            if (playerData == null || !playerData.hasStage(this.stageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new GameStageCondition();
    }

    @Generated
    public GameStageCondition() {
    }
}

