/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.placeholder.MultiLineComponent;
import com.gregtechceu.gtceu.api.placeholder.Placeholder;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderContext;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderHandler;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderUtils;
import com.gregtechceu.gtceu.api.placeholder.exceptions.InvalidArgsException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.MissingItemException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.NoMENetworkException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.NotSupportedException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.OutOfRangeException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.PlaceholderException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.WrongNumberOfArgsException;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTAEPlaceholders {
    private GTAEPlaceholders() {
    }

    private static IGrid getGrid(PlaceholderContext ctx) throws PlaceholderException {
        IGridConnectedBlockEntity gridBlockEntity;
        IGridNode node;
        IMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        IGridNode node2;
        if (ctx.pos() == null) {
            throw new NotSupportedException();
        }
        IInWorldGridNodeHost nodeHost = GridHelper.getNodeHost((Level)ctx.level(), (BlockPos)ctx.pos());
        if (nodeHost != null && (node2 = nodeHost.getGridNode(ctx.side())) != null) {
            return node2.getGrid();
        }
        BlockEntity blockEntity = ctx.level().m_7702_(ctx.pos());
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity gridMachine = (IGridConnectedBlockEntity)metaMachine;
            IGrid nullable = gridMachine.getMainNode().getGrid();
            if (nullable == null) {
                throw new NoMENetworkException();
            }
            return nullable;
        }
        if (blockEntity instanceof IGridConnectedBlockEntity && (node = (gridBlockEntity = (IGridConnectedBlockEntity)blockEntity).getGridNode()) != null) {
            return gridBlockEntity.getGridNode().getGrid();
        }
        throw new NoMENetworkException();
    }

    private static long countItems(String id, IGrid grid) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        if (item == null) {
            return 0L;
        }
        GenericStack stack = GenericStack.fromItemStack((ItemStack)new ItemStack((ItemLike)item, 1));
        if (stack == null) {
            return 0L;
        }
        return grid.getStorageService().getInventory().getAvailableStacks().get(stack.what());
    }

    private static long countItems(@Nullable ItemFilter filter, IGrid grid) {
        KeyCounter stacks = grid.getStorageService().getCachedInventory();
        long count = 0L;
        for (Object2LongMap.Entry stack : stacks) {
            if (!(stack.getKey() instanceof AEItemKey) || filter != null && !filter.test(((AEKey)stack.getKey()).wrapForDisplayOrFilter())) continue;
            count += stack.getLongValue();
        }
        return count;
    }

    private static long countFluids(@Nullable String id, IGrid grid) {
        if (id == null) {
            KeyCounter stacks = grid.getStorageService().getCachedInventory();
            long count = 0L;
            for (Object2LongMap.Entry stack : stacks) {
                if (!(stack.getKey() instanceof AEFluidKey)) continue;
                count += stack.getLongValue();
            }
            return count;
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(id));
        if (fluid == null) {
            return 0L;
        }
        GenericStack stack = GenericStack.fromFluidStack((FluidStack)new FluidStack(fluid, 1));
        if (stack == null) {
            return 0L;
        }
        return grid.getStorageService().getInventory().getAvailableStacks().get(stack.what());
    }

    private static Vector3i getSpatialSize(IGrid grid) {
        BlockPos start = grid.getSpatialService().getMin();
        BlockPos end = grid.getSpatialService().getMax();
        BlockPos tmp = end.m_121996_((Vec3i)start);
        return new Vector3i(tmp.m_123341_(), tmp.m_123342_(), tmp.m_123343_()).absolute();
    }

    public static void init() {
        PlaceholderHandler.addPlaceholder(new Placeholder("ae2itemCount"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IGrid grid = GTAEPlaceholders.getGrid(ctx);
                if (args.isEmpty()) {
                    return MultiLineComponent.literal(GTAEPlaceholders.countItems((ItemFilter)null, grid));
                }
                if (args.size() == 1) {
                    return MultiLineComponent.literal(GTAEPlaceholders.countItems(GTStringUtils.componentsToString(args.get(0)), grid));
                }
                if (GTStringUtils.equals(args.get(0), "filter")) {
                    int slot = PlaceholderUtils.toInt(args.get(1));
                    try {
                        PlaceholderUtils.checkRange("slot index", 1, 8, slot);
                        if (ctx.itemStackHandler() == null) {
                            throw new NotSupportedException();
                        }
                        return MultiLineComponent.literal(GTAEPlaceholders.countItems(ItemFilter.loadFilter(ctx.itemStackHandler().getStackInSlot(slot - 1)), grid));
                    }
                    catch (NullPointerException e) {
                        throw new MissingItemException("filter", slot);
                    }
                }
                throw new InvalidArgsException();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("ae2fluidCount"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IGrid grid = GTAEPlaceholders.getGrid(ctx);
                if (args.isEmpty()) {
                    return MultiLineComponent.literal(GTAEPlaceholders.countFluids(null, grid));
                }
                if (args.size() == 1) {
                    return MultiLineComponent.literal(GTAEPlaceholders.countFluids(GTStringUtils.componentsToString(args.get(0)), grid));
                }
                throw new WrongNumberOfArgsException(1, args.size());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("ae2power"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IGrid grid = GTAEPlaceholders.getGrid(ctx);
                PlaceholderUtils.checkArgs(args, 0);
                return MultiLineComponent.literal(grid.getEnergyService().getStoredPower());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("ae2maxPower"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IGrid grid = GTAEPlaceholders.getGrid(ctx);
                PlaceholderUtils.checkArgs(args, 0);
                return MultiLineComponent.literal(grid.getEnergyService().getMaxStoredPower());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("ae2powerUsage"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IGrid grid = GTAEPlaceholders.getGrid(ctx);
                PlaceholderUtils.checkArgs(args, 0);
                return MultiLineComponent.literal(grid.getEnergyService().getAvgPowerUsage());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("ae2spatial"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IGrid grid = GTAEPlaceholders.getGrid(ctx);
                PlaceholderUtils.checkArgs(args, 1);
                if (GTStringUtils.equals(args.get(0), "power")) {
                    return MultiLineComponent.literal(grid.getSpatialService().requiredPower());
                }
                if (GTStringUtils.equals(args.get(0), "efficiency")) {
                    return MultiLineComponent.literal(grid.getSpatialService().currentEfficiency());
                }
                if (GTStringUtils.equals(args.get(0), "sizeX")) {
                    return MultiLineComponent.literal(GTAEPlaceholders.getSpatialSize((IGrid)grid).x);
                }
                if (GTStringUtils.equals(args.get(0), "sizeY")) {
                    return MultiLineComponent.literal(GTAEPlaceholders.getSpatialSize((IGrid)grid).y);
                }
                if (GTStringUtils.equals(args.get(0), "sizeZ")) {
                    return MultiLineComponent.literal(GTAEPlaceholders.getSpatialSize((IGrid)grid).z);
                }
                throw new InvalidArgsException();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("ae2crafting"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IGrid grid = GTAEPlaceholders.getGrid(ctx);
                PlaceholderUtils.checkArgs(args, 1, true);
                ICraftingService crafting = grid.getCraftingService();
                if (GTStringUtils.equals(args.get(0), "get")) {
                    if (GTStringUtils.equals(args.get(1), "amount")) {
                        return MultiLineComponent.literal(crafting.getCpus().size());
                    }
                    int index = PlaceholderUtils.toInt(args.get(1));
                    int i = 0;
                    for (ICraftingCPU cpu : crafting.getCpus()) {
                        if (index - 1 == i) {
                            CraftingJobStatus job = cpu.getJobStatus();
                            if (GTStringUtils.equals(args.get(2), "storage")) {
                                return MultiLineComponent.literal(cpu.getAvailableStorage());
                            }
                            if (GTStringUtils.equals(args.get(2), "threads")) {
                                return MultiLineComponent.literal(cpu.getCoProcessors());
                            }
                            if (GTStringUtils.equals(args.get(2), "name")) {
                                return MultiLineComponent.of((Component)(cpu.getName() == null ? Component.m_237113_((String)("Crafting CPU " + i)) : cpu.getName().m_6881_()));
                            }
                            if (GTStringUtils.equals(args.get(2), "selectionMode")) {
                                return MultiLineComponent.literal(cpu.getSelectionMode().name());
                            }
                            if (job == null) {
                                return MultiLineComponent.literal(0L);
                            }
                            if (GTStringUtils.equals(args.get(2), "amount")) {
                                return MultiLineComponent.literal(job.crafting().amount());
                            }
                            if (GTStringUtils.equals(args.get(2), "item")) {
                                return MultiLineComponent.of((Component)job.crafting().what().getDisplayName().m_6881_());
                            }
                            if (GTStringUtils.equals(args.get(2), "progress")) {
                                return MultiLineComponent.literal(job.progress());
                            }
                            if (GTStringUtils.equals(args.get(2), "time")) {
                                return MultiLineComponent.literal(job.elapsedTimeNanos());
                            }
                            throw new InvalidArgsException();
                        }
                        ++i;
                    }
                    throw new OutOfRangeException("cpu number", 1, crafting.getCpus().size(), index);
                }
                throw new InvalidArgsException();
            }
        });
    }
}

