/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.cache.client;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.integration.map.GenericMapRenderer;
import com.gregtechceu.gtceu.integration.map.GroupingMapRenderer;
import com.gregtechceu.gtceu.integration.map.cache.DimensionCache;
import com.gregtechceu.gtceu.integration.map.cache.GridCache;
import com.gregtechceu.gtceu.integration.map.cache.WorldCache;
import com.gregtechceu.gtceu.integration.map.cache.client.IClientCache;
import com.gregtechceu.gtceu.integration.map.cache.fluid.FluidCache;
import com.gregtechceu.gtceu.integration.map.layer.builtin.OreRenderLayer;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class GTClientCache
extends WorldCache
implements IClientCache {
    public static final GTClientCache instance = new GTClientCache();
    private final FluidCache fluids = new FluidCache();

    public void notifyNewVeins(GeneratedVeinMetadata ... veins) {
        if (veins.length == 0) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        for (GeneratedVeinMetadata vein : veins) {
            String veinId = vein.id().toString();
            MutableComponent name = Component.m_237115_((String)veinId.replace("gtceu:", "gtceu.jei.ore_vein."));
            Material material = OreRenderLayer.getMaterial(vein);
            if (!material.isNull()) {
                BlockPos center = vein.center();
                name.m_6270_(name.m_7383_().m_178520_(material.getMaterialRGB()).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"(%d, %d, %d)".formatted(center.m_123341_(), center.m_123342_(), center.m_123343_())))));
            }
            player.m_213846_((Component)Component.m_237110_((String)"message.gtceu.new_veins.name", (Object[])new Object[]{name}));
        }
    }

    public void addFluid(ResourceKey<Level> dim, int chunkX, int chunkZ, ProspectorMode.FluidInfo fluid) {
        this.fluids.addFluid(dim, chunkX, chunkZ, fluid);
    }

    @Override
    public boolean addVein(ResourceKey<Level> dim, int gridX, int gridZ, GeneratedVeinMetadata vein) {
        boolean added;
        GroupingMapRenderer renderer = GroupingMapRenderer.getInstance();
        if (renderer != null) {
            ((GenericMapRenderer)renderer).addMarker(OreRenderLayer.getName(vein).getString(), dim, vein, OreRenderLayer.getId(vein));
        }
        if (added = super.addVein(dim, gridX, gridZ, vein)) {
            this.notifyNewVeins(vein);
        }
        return added;
    }

    @Override
    public Collection<ResourceKey<Level>> getExistingDimensions(String prefix) {
        return this.cache.keySet();
    }

    @Override
    public CompoundTag saveDimFile(String prefix, ResourceKey<Level> dim) {
        if (!this.cache.containsKey(dim)) {
            return null;
        }
        return ((DimensionCache)this.cache.get(dim)).toNBT(true);
    }

    @Override
    public CompoundTag saveSingleFile(String name) {
        return this.fluids.toNbt();
    }

    @Override
    public void readDimFile(String prefix, ResourceKey<Level> dim, CompoundTag data) {
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, new DimensionCache());
        }
        ((DimensionCache)this.cache.get(dim)).fromNBT(data, true);
        GroupingMapRenderer renderer = GroupingMapRenderer.getInstance();
        if (renderer != null) {
            for (GridCache grid : ((DimensionCache)this.cache.get(dim)).getCache().values()) {
                for (GeneratedVeinMetadata vein : grid.getVeins()) {
                    ((GenericMapRenderer)renderer).addMarker(OreRenderLayer.getName(vein).getString(), dim, vein, OreRenderLayer.getId(vein));
                }
            }
        }
    }

    @Override
    public void readSingleFile(String name, CompoundTag data) {
        this.fluids.fromNbt(data);
    }

    @Override
    public void setupCacheFiles() {
        this.addDimFiles();
        this.addSingleFile("fluids");
    }

    @Override
    public void clear() {
        super.clear();
        this.fluids.clear();
    }
}

