/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.misc;

import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import dev.architectury.fluid.FluidStack;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public interface IGhostFluidTarget
extends IGhostIngredientTarget {
    @OnlyIn(value=Dist.CLIENT)
    public Rect2i getRectangleBox();

    @OnlyIn(value=Dist.CLIENT)
    public void acceptFluid(net.minecraftforge.fluids.FluidStack var1);

    @OnlyIn(value=Dist.CLIENT)
    default public List<Target> getPhantomTargets(Object ingredient) {
        if (!((ingredient = this.convertIngredient(ingredient)) instanceof net.minecraftforge.fluids.FluidStack) && PhantomFluidWidget.drainFrom(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.getRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @NotNull
            public Rect2i getArea() {
                return rectangle;
            }

            public void accept(@NotNull Object ingredient) {
                net.minecraftforge.fluids.FluidStack fluidStack;
                net.minecraftforge.fluids.FluidStack ingredientStack = (ingredient = IGhostFluidTarget.this.convertIngredient(ingredient)) instanceof net.minecraftforge.fluids.FluidStack ? (fluidStack = (net.minecraftforge.fluids.FluidStack)ingredient) : PhantomFluidWidget.drainFrom(ingredient);
                if (ingredientStack != null) {
                    IGhostFluidTarget.this.acceptFluid(ingredientStack);
                }
            }
        }});
    }

    default public Object convertIngredient(Object ingredient) {
        FluidStack fluidStack;
        if (GTCEu.Mods.isREILoaded() && ingredient instanceof FluidStack) {
            fluidStack = (FluidStack)ingredient;
            ingredient = new net.minecraftforge.fluids.FluidStack(fluidStack.getFluid(), (int)fluidStack.getAmount(), fluidStack.getTag());
        }
        if (GTCEu.Mods.isEMILoaded() && ingredient instanceof EmiStack) {
            EmiStack fluidEmiStack = (EmiStack)ingredient;
            Fluid fluid = (Fluid)fluidEmiStack.getKeyOfType(Fluid.class);
            Object object = ingredient = fluid == null ? net.minecraftforge.fluids.FluidStack.EMPTY : new net.minecraftforge.fluids.FluidStack(fluid, (int)fluidEmiStack.getAmount(), fluidEmiStack.getNbt());
        }
        if (GTCEu.Mods.isJEILoaded() && ingredient instanceof net.minecraftforge.fluids.FluidStack) {
            fluidStack = (net.minecraftforge.fluids.FluidStack)ingredient;
            ingredient = new net.minecraftforge.fluids.FluidStack(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
        }
        return ingredient;
    }
}

