/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;

public class RecipeAmperageEnergyContainer
extends NotifiableEnergyContainer {
    protected final IRecipeLogicMachine machine;

    public RecipeAmperageEnergyContainer(IRecipeLogicMachine machine, long maxCapacity, long maxInputVoltage, long maxInputAmperage, long maxOutputVoltage, long maxOutputAmperage) {
        super(machine.self(), maxCapacity, maxInputVoltage, maxInputAmperage, maxOutputVoltage, maxOutputAmperage);
        this.machine = machine;
    }

    public static RecipeAmperageEnergyContainer makeEmitterContainer(IRecipeLogicMachine machine, long maxCapacity, long maxOutputVoltage, long maxOutputAmperage) {
        return new RecipeAmperageEnergyContainer(machine, maxCapacity, 0L, 0L, maxOutputVoltage, maxOutputAmperage);
    }

    public static RecipeAmperageEnergyContainer makeReceiverContainer(IRecipeLogicMachine machine, long maxCapacity, long maxInputVoltage, long maxInputAmperage) {
        return new RecipeAmperageEnergyContainer(machine, maxCapacity, maxInputVoltage, maxInputAmperage, 0L, 0L);
    }

    @Override
    public long getInputAmperage() {
        GTRecipe lastRecipe = this.machine.getRecipeLogic().getLastRecipe();
        long amperage = lastRecipe != null ? lastRecipe.getInputEUt().amperage() : super.getInputAmperage();
        if (this.getEnergyCapacity() / 2L > this.getEnergyStored() && this.machine.getRecipeLogic().isActive()) {
            return amperage + 1L;
        }
        return amperage;
    }

    @Override
    public long getOutputAmperage() {
        GTRecipe lastRecipe = this.machine.getRecipeLogic().getLastRecipe();
        if (lastRecipe != null) {
            return lastRecipe.getOutputEUt().amperage();
        }
        return super.getOutputAmperage();
    }
}

