/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public final class NBTPredicateUtils {
    private NBTPredicateUtils() {
    }

    public static JsonElement toJson(Tag tag) {
        return (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, tag);
    }

    public static Tag fromJson(JsonElement e) {
        return (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, e);
    }

    public static Tag getNestedTag(CompoundTag inputTag, String path) {
        String[] parts = path.split("\\.");
        CompoundTag current = inputTag;
        for (String part : parts) {
            CompoundTag compound;
            if (current == null) {
                return null;
            }
            int bracketIndex = part.indexOf(91);
            if (bracketIndex == -1) {
                CompoundTag compound2;
                if (!(current instanceof CompoundTag) || !(compound2 = current).m_128441_(part)) {
                    return null;
                }
                current = compound2.m_128423_(part);
                continue;
            }
            String key = part.substring(0, bracketIndex);
            String indexSection = part.substring(bracketIndex);
            if (!(current instanceof CompoundTag) || !(compound = current).m_128441_(key)) {
                return null;
            }
            Tag tag = compound.m_128423_(key);
            if (!(tag instanceof ListTag)) {
                return null;
            }
            ListTag list = (ListTag)tag;
            Tag element = tag;
            int from = 0;
            while (true) {
                int index;
                int open = indexSection.indexOf(91, from);
                int close = indexSection.indexOf(93, from);
                if (open == -1 || close == -1) break;
                String numStr = indexSection.substring(open + 1, close);
                if (!(element instanceof ListTag)) {
                    return null;
                }
                ListTag innerList = (ListTag)element;
                try {
                    index = Integer.parseInt(numStr);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                if (index < 0 || index >= innerList.size()) {
                    return null;
                }
                element = innerList.get(index);
                from = close + 1;
            }
            current = element;
        }
        return current;
    }
}

