/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.modifier;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ModifierFunction {
    public static final ModifierFunction NULL = recipe -> null;
    public static final ModifierFunction IDENTITY = recipe -> recipe;

    @Contract(pure=true)
    @Nullable
    public GTRecipe apply(@NotNull GTRecipe var1);

    default public ModifierFunction compose(@NotNull ModifierFunction before) {
        return recipe -> this.applySafe(before.apply(recipe));
    }

    default public ModifierFunction andThen(@NotNull ModifierFunction after) {
        return recipe -> after.applySafe(this.apply(recipe));
    }

    private GTRecipe applySafe(@Nullable GTRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        return this.apply(recipe);
    }

    public static FunctionBuilder builder() {
        return new FunctionBuilder();
    }

    public static final class FunctionBuilder {
        private int parallels = 1;
        private int subtickParallels = 1;
        private int batchParallels = 1;
        private int addOCs = 0;
        private ContentModifier eutModifier = ContentModifier.IDENTITY;
        private ContentModifier durationModifier = ContentModifier.IDENTITY;
        private ContentModifier inputModifier = ContentModifier.IDENTITY;
        private ContentModifier outputModifier = ContentModifier.IDENTITY;
        private ContentModifier tickInputModifier = ContentModifier.IDENTITY;
        private ContentModifier tickOutputModifier = ContentModifier.IDENTITY;
        private final List<RecipeCondition> addedConditions = new ArrayList<RecipeCondition>();

        public FunctionBuilder conditions(RecipeCondition ... conditions) {
            this.addedConditions.addAll(Arrays.asList(conditions));
            return this;
        }

        public FunctionBuilder modifyAllContents(ContentModifier cm) {
            this.inputModifier = cm;
            this.outputModifier = cm;
            this.tickInputModifier = cm;
            this.tickOutputModifier = cm;
            return this;
        }

        public FunctionBuilder eutMultiplier(double multiplier) {
            this.eutModifier = ContentModifier.multiplier(multiplier);
            return this;
        }

        public FunctionBuilder durationMultiplier(double multiplier) {
            this.durationModifier = ContentModifier.multiplier(multiplier);
            return this;
        }

        public ModifierFunction build() {
            if (this.parallels == 0) {
                return NULL;
            }
            return recipe -> {
                ArrayList<RecipeCondition> newConditions = new ArrayList<RecipeCondition>(recipe.conditions);
                newConditions.addAll(this.addedConditions);
                GTRecipe copied = new GTRecipe(recipe.recipeType, recipe.id, this.inputModifier.applyContents(recipe.inputs), this.outputModifier.applyContents(recipe.outputs), FunctionBuilder.applyAllButEU(this.tickInputModifier, recipe.tickInputs), FunctionBuilder.applyAllButEU(this.tickOutputModifier, recipe.tickOutputs), new HashMap(recipe.inputChanceLogics), new HashMap(recipe.outputChanceLogics), new HashMap(recipe.tickInputChanceLogics), new HashMap(recipe.tickOutputChanceLogics), newConditions, new ArrayList(recipe.ingredientActions), recipe.data, recipe.duration, recipe.recipeCategory);
                copied.parallels = recipe.parallels * this.parallels;
                copied.subtickParallels = recipe.subtickParallels * this.subtickParallels;
                copied.ocLevel = recipe.ocLevel + this.addOCs;
                copied.batchParallels = recipe.batchParallels * this.batchParallels;
                copied.duration = recipe.data.m_128471_("duration_is_total_cwu") ? (int)Math.max(1.0f, (float)recipe.duration * (1.0f - 0.025f * (float)this.addOCs)) : Math.max(1, this.durationModifier.apply(recipe.duration));
                if (this.eutModifier != ContentModifier.IDENTITY) {
                    EnergyStack.WithIO preEUt = RecipeHelper.getRealEUtWithIO(recipe);
                    EnergyStack eut = EURecipeCapability.CAP.copyWithModifier(preEUt.stack(), this.eutModifier);
                    EURecipeCapability.putEUContent(preEUt.isInput() ? copied.tickInputs : copied.tickOutputs, eut);
                }
                return copied;
            };
        }

        private static Map<RecipeCapability<?>, List<Content>> applyAllButEU(ContentModifier cm, Map<RecipeCapability<?>, List<Content>> contents) {
            if (cm == ContentModifier.IDENTITY) {
                return new HashMap(contents);
            }
            HashMap copyContents = new HashMap();
            for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
                RecipeCapability<?> cap = entry.getKey();
                List<Content> contentList = entry.getValue();
                if (contentList == null || contentList.isEmpty()) continue;
                if (cap == EURecipeCapability.CAP) {
                    copyContents.put(cap, new ArrayList<Content>(contentList));
                    continue;
                }
                ArrayList<Content> contentsCopy = new ArrayList<Content>();
                for (Content content : contentList) {
                    contentsCopy.add(content.copy(cap, cm));
                }
                copyContents.put(cap, contentsCopy);
            }
            return copyContents;
        }

        @NotNull
        @Generated
        public FunctionBuilder parallels(int parallels) {
            this.parallels = parallels;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder subtickParallels(int subtickParallels) {
            this.subtickParallels = subtickParallels;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder batchParallels(int batchParallels) {
            this.batchParallels = batchParallels;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder addOCs(int addOCs) {
            this.addOCs = addOCs;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder eutModifier(ContentModifier eutModifier) {
            this.eutModifier = eutModifier;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder durationModifier(ContentModifier durationModifier) {
            this.durationModifier = durationModifier;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder inputModifier(ContentModifier inputModifier) {
            this.inputModifier = inputModifier;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder outputModifier(ContentModifier outputModifier) {
            this.outputModifier = outputModifier;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder tickInputModifier(ContentModifier tickInputModifier) {
            this.tickInputModifier = tickInputModifier;
            return this;
        }

        @NotNull
        @Generated
        public FunctionBuilder tickOutputModifier(ContentModifier tickOutputModifier) {
            this.tickOutputModifier = tickOutputModifier;
            return this;
        }
    }
}

