/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.client.util.ExtendedBlockModelRotation;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateProvider;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.blockstates.VariantProperty;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.IGeneratedBlockState;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTBlockstateProvider
extends RegistrateBlockstateProvider {
    public static final String Z_ROT_PROPERTY_NAME = "gtceu:z";
    private static final VariantProperty<VariantProperties.Rotation> X_ROT = VariantProperties.f_125518_;
    private static final VariantProperty<VariantProperties.Rotation> Y_ROT = VariantProperties.f_125519_;
    private static final VariantProperty<VariantProperties.Rotation> Z_ROT = new VariantProperty("gtceu:z", r -> new JsonPrimitive((Number)(r.ordinal() * 90)));
    public static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");
    public static final ExistingFileHelper.ResourceType MODEL = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".json", "models");
    private static GTBlockstateProvider CURRENT_PROVIDER = null;

    public GTBlockstateProvider(AbstractRegistrate<?> parent, GatherDataEvent event, Map<ProviderType<?>, RegistrateProvider> existing) {
        this(parent, event.getGenerator().getPackOutput(), event.getExistingFileHelper());
        existing.put(ProviderType.BLOCKSTATE, (RegistrateProvider)this);
    }

    public GTBlockstateProvider(AbstractRegistrate<?> parent, PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(parent, packOutput, exFileHelper);
    }

    public static GTBlockstateProvider getCurrentProvider() {
        return CURRENT_PROVIDER;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        CURRENT_PROVIDER = this;
        CompletableFuture value = super.m_213708_(cache);
        CURRENT_PROVIDER = null;
        return value;
    }

    public ExistingFileHelper getExistingFileHelper() {
        return this.models().existingFileHelper;
    }

    public MultiVariantGenerator multiVariantGenerator(Block block) {
        MultiVariantGenerator multiVariant = MultiVariantGenerator.m_125254_((Block)block);
        this.registeredBlocks.put(block, new BlockStateGeneratorWrapper((BlockStateGenerator)multiVariant));
        return multiVariant;
    }

    public MultiVariantGenerator multiVariantGenerator(Block block, Variant baseVariant) {
        MultiVariantGenerator multiVariant = MultiVariantGenerator.m_125256_((Block)block, (Variant)baseVariant);
        this.registeredBlocks.put(block, new BlockStateGeneratorWrapper((BlockStateGenerator)multiVariant));
        return multiVariant;
    }

    public MultiPartGenerator multiPartGenerator(Block block) {
        MultiPartGenerator multiPart = MultiPartGenerator.m_125204_((Block)block);
        this.registeredBlocks.put(block, new BlockStateGeneratorWrapper((BlockStateGenerator)multiPart));
        return multiPart;
    }

    @Nullable
    public static PropertyDispatch createFacingDispatch(MachineDefinition definition) {
        return GTBlockstateProvider.createFacingDispatch(definition.getRotationState(), definition.isAllowExtendedFacing());
    }

    @Nullable
    public static PropertyDispatch createFacingDispatch(RotationState rotationState, boolean allowExtendedFacing) {
        PropertyDispatch dispatch;
        if (rotationState == RotationState.NONE) {
            return null;
        }
        if (!allowExtendedFacing) {
            PropertyDispatch.C1 disp = PropertyDispatch.m_125294_((Property)rotationState.property);
            dispatch = disp.m_125335_(front -> {
                ExtendedBlockModelRotation orientation = ExtendedBlockModelRotation.get(front, Direction.NORTH);
                return GTBlockstateProvider.applyOrientation(Variant.m_125501_(), orientation);
            });
        } else {
            PropertyDispatch.C2 disp = PropertyDispatch.m_125296_((Property)rotationState.property, (Property)GTBlockStateProperties.UPWARDS_FACING);
            dispatch = disp.m_125362_((front, up) -> {
                ExtendedBlockModelRotation orientation = ExtendedBlockModelRotation.get(front, up);
                return GTBlockstateProvider.applyOrientation(Variant.m_125501_(), orientation);
            });
        }
        return dispatch;
    }

    public static Variant applyOrientation(Variant variant, ExtendedBlockModelRotation orientation) {
        return GTBlockstateProvider.applyRotation(variant, orientation.getAngleX(), orientation.getAngleY(), orientation.getAngleZ());
    }

    public static Variant applyRotation(Variant variant, int angleX, int angleY, int angleZ) {
        angleX = GTBlockstateProvider.normalizeAngle(angleX);
        angleY = GTBlockstateProvider.normalizeAngle(angleY);
        angleZ = GTBlockstateProvider.normalizeAngle(angleZ);
        if (angleX != 0) {
            variant = variant.m_125511_(X_ROT, (Object)GTBlockstateProvider.rotationByAngle(angleX));
        }
        if (angleY != 0) {
            variant = variant.m_125511_(Y_ROT, (Object)GTBlockstateProvider.rotationByAngle(angleY));
        }
        if (angleZ != 0) {
            variant = variant.m_125511_(Z_ROT, (Object)GTBlockstateProvider.rotationByAngle(angleZ));
        }
        return variant;
    }

    private static int normalizeAngle(int angle) {
        return angle - angle / 360 * 360;
    }

    private static VariantProperties.Rotation rotationByAngle(int angle) {
        return switch (angle) {
            case 0 -> VariantProperties.Rotation.R0;
            case 90 -> VariantProperties.Rotation.R90;
            case 180 -> VariantProperties.Rotation.R180;
            case 270 -> VariantProperties.Rotation.R270;
            default -> throw new IllegalArgumentException("Invalid angle: " + angle);
        };
    }

    protected Optional<BlockStateGeneratorWrapper> getExistingBlockStateGenerator(Block block) {
        return Optional.ofNullable((IGeneratedBlockState)this.registeredBlocks.get(block)).filter(g -> g instanceof BlockStateGeneratorWrapper).map(g -> (BlockStateGeneratorWrapper)g);
    }

    public Optional<MultiVariantGenerator> getExistingMultiVariantGenerator(Block block) {
        return this.getExistingBlockStateGenerator(block).filter(g -> g.generator() instanceof MultiVariantGenerator).map(g -> (MultiVariantGenerator)g.generator());
    }

    public Optional<MultiPartGenerator> getExistingMultipartGenerator(Block block) {
        return this.getExistingBlockStateGenerator(block).filter(g -> g.generator() instanceof MultiPartGenerator).map(g -> (MultiPartGenerator)g.generator());
    }

    public record BlockStateGeneratorWrapper(BlockStateGenerator generator) implements IGeneratedBlockState
    {
        public JsonObject toJson() {
            return ((JsonElement)this.generator.get()).getAsJsonObject();
        }
    }
}

