/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.utils.GTMatrixUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtil {
    private static final Map<Direction, Vector3fc[]> DIRECTION_POSITION_MAP = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        map.put(Direction.UP, new Vector3fc[]{RenderUtil.vec3f(0.0f, 1.0f, 1.0f), RenderUtil.vec3f(1.0f, 1.0f, 1.0f), RenderUtil.vec3f(1.0f, 1.0f, 0.0f), RenderUtil.vec3f(0.0f, 1.0f, 0.0f)});
        map.put(Direction.DOWN, new Vector3fc[]{RenderUtil.vec3f(1.0f, 0.0f, 1.0f), RenderUtil.vec3f(0.0f, 0.0f, 1.0f), RenderUtil.vec3f(0.0f, 0.0f, 0.0f), RenderUtil.vec3f(1.0f, 0.0f, 0.0f)});
        map.put(Direction.SOUTH, new Vector3fc[]{RenderUtil.vec3f(1.0f, 1.0f, 0.0f), RenderUtil.vec3f(1.0f, 0.0f, 0.0f), RenderUtil.vec3f(0.0f, 0.0f, 0.0f), RenderUtil.vec3f(0.0f, 1.0f, 0.0f)});
        map.put(Direction.NORTH, new Vector3fc[]{RenderUtil.vec3f(0.0f, 1.0f, 1.0f), RenderUtil.vec3f(0.0f, 0.0f, 1.0f), RenderUtil.vec3f(1.0f, 0.0f, 1.0f), RenderUtil.vec3f(1.0f, 1.0f, 1.0f)});
        map.put(Direction.EAST, new Vector3fc[]{RenderUtil.vec3f(0.0f, 1.0f, 0.0f), RenderUtil.vec3f(0.0f, 0.0f, 0.0f), RenderUtil.vec3f(0.0f, 0.0f, 1.0f), RenderUtil.vec3f(0.0f, 1.0f, 1.0f)});
        map.put(Direction.WEST, new Vector3fc[]{RenderUtil.vec3f(1.0f, 1.0f, 1.0f), RenderUtil.vec3f(1.0f, 0.0f, 1.0f), RenderUtil.vec3f(1.0f, 0.0f, 0.0f), RenderUtil.vec3f(1.0f, 1.0f, 0.0f)});
    });
    private static final Map<Direction, Vector3fc> DIRECTION_NORMAL_MAP = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        map.put(Direction.UP, RenderUtil.vec3f(0.0f, 1.0f, 0.0f));
        map.put(Direction.DOWN, RenderUtil.vec3f(0.0f, 1.0f, 0.0f));
        map.put(Direction.SOUTH, RenderUtil.vec3f(0.0f, 0.0f, 1.0f));
        map.put(Direction.NORTH, RenderUtil.vec3f(0.0f, 0.0f, 1.0f));
        map.put(Direction.EAST, RenderUtil.vec3f(1.0f, 0.0f, 0.0f));
        map.put(Direction.WEST, RenderUtil.vec3f(1.0f, 0.0f, 0.0f));
    });

    public static Vec3 vec3(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    public static Vector3f vec3f(float x, float y, float z) {
        return new Vector3f(x, y, z);
    }

    public static Vector3fc[] getVertices(Direction direction) {
        return DIRECTION_POSITION_MAP.get(direction);
    }

    public static Vector3fc getNormal(Direction direction) {
        return DIRECTION_NORMAL_MAP.get(direction);
    }

    public static int getFluidLight(Fluid fluid, BlockPos pos) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return 0;
        }
        return LevelRenderer.m_109537_((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockState)fluid.m_76145_().m_76188_(), (BlockPos)pos);
    }

    public static void vertex(Matrix4f pose, VertexConsumer vertexConsumer, float x, float y, float z, int r, int g, int b, int a, float u, float v, int overlayCoords, int lightOverlay, float v0, float v1, float v2) {
        vertexConsumer.m_252986_(pose, x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(overlayCoords).m_85969_(lightOverlay).m_5601_(v0, v1, v2).m_5752_();
    }

    public static Vector3f transformVertex(Vector3fc vertex, Direction direction, float offsetX, float offsetY, float offsetZ) {
        float addX = offsetX;
        float addY = offsetY;
        float addZ = offsetZ;
        switch (direction) {
            case DOWN: {
                addY = -addY;
                break;
            }
            case SOUTH: {
                addZ = -addZ;
                break;
            }
            case EAST: {
                addX = -addX;
            }
        }
        return new Vector3f(vertex).add(addX, addY, addZ);
    }

    @Nullable
    public static Fluid getRecipeFluidToRender(GTRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        ObjectArrayList contents = new ObjectArrayList();
        ArrayList empty = new ArrayList();
        contents.addAll((Collection)recipe.outputs.getOrDefault(FluidRecipeCapability.CAP, empty));
        contents.addAll((Collection)recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, empty));
        if (contents.isEmpty()) {
            return null;
        }
        Optional<Content> fluidContent = contents.stream().filter(content -> {
            FluidIngredient ingredient;
            Object patt8289$temp = content.content;
            return patt8289$temp instanceof FluidIngredient && !(ingredient = (FluidIngredient)patt8289$temp).isEmpty();
        }).findAny();
        if (fluidContent.isEmpty()) {
            return null;
        }
        FluidIngredient ingredient = (FluidIngredient)fluidContent.get().content;
        FluidStack[] stacks = ingredient.getStacks();
        if (stacks.length == 0) {
            return null;
        }
        Fluid fluid = null;
        for (int i = 0; i < stacks.length && fluid == null; ++i) {
            if (stacks[i].isEmpty()) continue;
            fluid = stacks[i].getFluid();
        }
        return fluid;
    }

    public static void moveToFace(PoseStack poseStack, Vector3fc pos, Direction face) {
        RenderUtil.moveToFace(poseStack, pos.x(), pos.y(), pos.z(), face);
    }

    public static void moveToFace(PoseStack poseStack, float x, float y, float z, Direction face) {
        poseStack.m_252880_(Math.fma(face.m_122429_(), 0.5f, x), Math.fma(face.m_122430_(), 0.5f, y), Math.fma(face.m_122431_(), 0.5f, z));
    }

    public static void drawBlock(BlockAndTintGetter level, BlockPos pos, BlockState state, MultiBufferSource bufferSource, PoseStack poseStack) {
        int packedLight = LevelRenderer.m_109537_((BlockAndTintGetter)level, (BlockState)state, (BlockPos)pos);
        RenderShape renderShape = state.m_60799_();
        if (renderShape == RenderShape.INVISIBLE) {
            return;
        }
        if (renderShape == RenderShape.ENTITYBLOCK_ANIMATED) {
            ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
            IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BakedModel model = blockRenderer.m_110910_(state);
        ModelData modelData = model.getModelData(level, pos, state, ModelData.EMPTY);
        int blockColor = Minecraft.m_91087_().m_91298_().m_92577_(state, level, pos, 0);
        float r = (float)(blockColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(blockColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(blockColor & 0xFF) / 255.0f;
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), modelData)) {
            blockRenderer.m_110937_().renderModel(poseStack.m_85850_(), bufferSource.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), state, model, r, g, b, packedLight, OverlayTexture.f_118083_, modelData, renderType);
        }
    }

    public static void rotateToFace(PoseStack poseStack, Direction face, Direction spin) {
        float rotationAngle = 1.5707964f * (switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.WEST -> 1.0f;
            case Direction.DOWN, Direction.EAST -> -1.0f;
            case Direction.SOUTH -> 2.0f;
            case Direction.NORTH -> 0.0f;
        });
        Quaternionf rotation = new Quaternionf();
        if (face.m_122434_() == Direction.Axis.Y) {
            poseStack.m_85841_(1.0f, -1.0f, 1.0f);
            rotation.rotateX(rotationAngle);
        } else {
            poseStack.m_85841_(-1.0f, -1.0f, -1.0f);
            rotation.rotateY(rotationAngle);
        }
        rotation.rotateZ(RenderUtil.getSpinAngle(spin, face));
        poseStack.m_252781_(rotation);
    }

    private static float getSpinAngle(Direction spin, Direction face) {
        if (spin.m_122434_() == Direction.Axis.Z && face == Direction.DOWN) {
            spin = spin.m_122424_();
        }
        return GTMatrixUtils.upwardFacingAngle(spin);
    }

    public static boolean renderResearchItemContent(GuiGraphics graphics, Operation<Void> originalMethod, @Nullable LivingEntity entity, @Nullable Level level, ItemStack stack, int x, int y, int z, int seed) {
        if (!Screen.m_96638_()) {
            return false;
        }
        ResearchManager.ResearchItem researchData = ResearchManager.readResearchId(stack);
        if (researchData == null) {
            return false;
        }
        Collection<GTRecipe> recipes = researchData.recipeType().getDataStickEntry(researchData.researchId());
        if (recipes == null || recipes.isEmpty()) {
            return false;
        }
        for (GTRecipe recipe : recipes) {
            FluidStack[] fluids;
            ItemStack output;
            ItemStack[] items;
            List<Content> outputs = recipe.getOutputContents(ItemRecipeCapability.CAP);
            if (!(outputs.isEmpty() || (items = ((Ingredient)ItemRecipeCapability.CAP.of(outputs.get((int)0).content)).m_43908_()).length <= 0 || (output = items[0]).m_41619_() || GTUtil.isSameItemSameTags(output, stack))) {
                originalMethod.call(new Object[]{entity, level, output, x, y, seed, z});
                return true;
            }
            outputs = recipe.getOutputContents(FluidRecipeCapability.CAP);
            if (outputs.isEmpty() || (fluids = ((FluidIngredient)FluidRecipeCapability.CAP.of(outputs.get((int)0).content)).getStacks()).length == 0 || (output = fluids[0]).isEmpty()) continue;
            IClientFluidTypeExtensions clientExt = IClientFluidTypeExtensions.of((Fluid)output.getFluid());
            TextureAtlasSprite texture = FluidTextureType.STILL.map(clientExt, (FluidStack)output);
            int color = clientExt.getTintColor((FluidStack)output);
            DrawerHelper.drawFluidTexture((GuiGraphics)graphics, (float)x, (float)y, (TextureAtlasSprite)texture, (float)0.0f, (float)0.0f, (float)z, (int)color);
            return true;
        }
        return false;
    }

    public static enum FluidTextureType {
        STILL((fluidTypeExtensions, fluidStack) -> {
            if (!fluidStack.isEmpty()) {
                return fluidTypeExtensions.getStillTexture(fluidStack);
            }
            return fluidTypeExtensions.getStillTexture();
        }),
        FLOWING((fluidTypeExtensions, fluidStack) -> {
            if (!fluidStack.isEmpty()) {
                return fluidTypeExtensions.getFlowingTexture(fluidStack);
            }
            return fluidTypeExtensions.getFlowingTexture();
        }),
        OVERLAY((fluidTypeExtensions, fluidStack) -> {
            if (!fluidStack.isEmpty()) {
                return fluidTypeExtensions.getOverlayTexture(fluidStack);
            }
            return fluidTypeExtensions.getOverlayTexture();
        });

        private static final ResourceLocation WATER_STILL;
        private final BiFunction<IClientFluidTypeExtensions, FluidStack, ResourceLocation> mapper;

        private FluidTextureType(BiFunction<IClientFluidTypeExtensions, FluidStack, ResourceLocation> mapper) {
            this.mapper = mapper;
        }

        public TextureAtlasSprite map(IClientFluidTypeExtensions fluidTypeExtensions) {
            return this.map(fluidTypeExtensions, FluidStack.EMPTY);
        }

        public TextureAtlasSprite map(IClientFluidTypeExtensions fluidTypeExtensions, FluidStack fluidStack) {
            ResourceLocation texture = this.mapper.apply(fluidTypeExtensions, fluidStack);
            if (texture == null) {
                texture = FluidTextureType.STILL.mapper.apply(fluidTypeExtensions, fluidStack);
            }
            if (texture == null) {
                texture = WATER_STILL;
            }
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        }

        static {
            WATER_STILL = new ResourceLocation("minecraft", "block/water_still");
        }
    }
}

