/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.events.MaterialCasingCollectionEvent;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.block.IFusionCasingType;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.DuctPipeBlockItem;
import com.gregtechceu.gtceu.api.item.LampBlockItem;
import com.gregtechceu.gtceu.api.item.LaserPipeBlockItem;
import com.gregtechceu.gtceu.api.item.OpticalPipeBlockItem;
import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeBlock;
import com.gregtechceu.gtceu.common.block.BatteryBlock;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import com.gregtechceu.gtceu.common.block.CleanroomFilterType;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import com.gregtechceu.gtceu.common.block.DuctPipeBlock;
import com.gregtechceu.gtceu.common.block.FoamBlock;
import com.gregtechceu.gtceu.common.block.FusionCasingBlock;
import com.gregtechceu.gtceu.common.block.GTCeilingHangingSignBlock;
import com.gregtechceu.gtceu.common.block.GTStandingSignBlock;
import com.gregtechceu.gtceu.common.block.GTWallHangingSignBlock;
import com.gregtechceu.gtceu.common.block.GTWallSignBlock;
import com.gregtechceu.gtceu.common.block.LampBlock;
import com.gregtechceu.gtceu.common.block.LaserPipeBlock;
import com.gregtechceu.gtceu.common.block.MinerPipeBlock;
import com.gregtechceu.gtceu.common.block.OpticalPipeBlock;
import com.gregtechceu.gtceu.common.block.RubberLogBlock;
import com.gregtechceu.gtceu.common.block.RubberWoodBlock;
import com.gregtechceu.gtceu.common.block.StoneBlockType;
import com.gregtechceu.gtceu.common.block.StoneTypes;
import com.gregtechceu.gtceu.common.block.explosive.IndustrialTNTBlock;
import com.gregtechceu.gtceu.common.block.explosive.PowderbarrelBlock;
import com.gregtechceu.gtceu.common.data.GCYMBlocks;
import com.gregtechceu.gtceu.common.data.GTConfiguredFeatures;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.models.GTModels;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeType;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemPipeType;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeType;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalPipeType;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.core.mixins.BlockPropertiesAccessor;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.gregtechceu.gtceu.utils.memoization.MemoizedBlockSupplier;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTBlocks {
    public static final BlockEntry<LaserPipeBlock>[] LASER_PIPES;
    public static final BlockEntry<OpticalPipeBlock>[] OPTICAL_PIPES;
    public static final BlockEntry<DuctPipeBlock>[] DUCT_PIPES;
    public static final BlockEntry<LongDistancePipeBlock> LD_ITEM_PIPE;
    public static final BlockEntry<LongDistancePipeBlock> LD_FLUID_PIPE;
    public static final BlockEntry<Block> CASING_WOOD_WALL;
    public static final BlockEntry<Block> CASING_COKE_BRICKS;
    public static final BlockEntry<Block> CASING_PRIMITIVE_BRICKS;
    public static final BlockEntry<Block> CASING_BRONZE_BRICKS;
    public static final BlockEntry<Block> CASING_INVAR_HEATPROOF;
    public static final BlockEntry<Block> CASING_ALUMINIUM_FROSTPROOF;
    public static final BlockEntry<Block> CASING_STEEL_SOLID;
    public static final BlockEntry<Block> CASING_STAINLESS_CLEAN;
    public static final BlockEntry<Block> CASING_TITANIUM_STABLE;
    public static final BlockEntry<Block> CASING_TUNGSTENSTEEL_ROBUST;
    public static final BlockEntry<Block> CASING_PTFE_INERT;
    public static final BlockEntry<Block> CASING_HSSE_STURDY;
    public static final BlockEntry<Block> CASING_PALLADIUM_SUBSTATION;
    public static final BlockEntry<GlassBlock> CASING_TEMPERED_GLASS;
    public static final ImmutableMap<Material, BlockEntry<Block>> MATERIALS_TO_CASINGS;
    public static final BlockEntry<Block> CASING_GRATE;
    public static final BlockEntry<Block> CASING_ASSEMBLY_CONTROL;
    public static final BlockEntry<GlassBlock> CASING_LAMINATED_GLASS;
    public static final BlockEntry<ActiveBlock> CASING_ASSEMBLY_LINE;
    public static final BlockEntry<Block> CASING_BRONZE_GEARBOX;
    public static final BlockEntry<Block> CASING_STEEL_GEARBOX;
    public static final BlockEntry<Block> CASING_STAINLESS_STEEL_GEARBOX;
    public static final BlockEntry<Block> CASING_TITANIUM_GEARBOX;
    public static final BlockEntry<Block> CASING_TUNGSTENSTEEL_GEARBOX;
    public static final BlockEntry<Block> CASING_STEEL_TURBINE;
    public static final BlockEntry<Block> CASING_TITANIUM_TURBINE;
    public static final BlockEntry<Block> CASING_STAINLESS_TURBINE;
    public static final BlockEntry<Block> CASING_TUNGSTENSTEEL_TURBINE;
    public static final BlockEntry<Block> CASING_BRONZE_PIPE;
    public static final BlockEntry<Block> CASING_STEEL_PIPE;
    public static final BlockEntry<Block> CASING_TITANIUM_PIPE;
    public static final BlockEntry<Block> CASING_TUNGSTENSTEEL_PIPE;
    public static final BlockEntry<Block> CASING_POLYTETRAFLUOROETHYLENE_PIPE;
    public static final BlockEntry<MinerPipeBlock> MINER_PIPE;
    public static final BlockEntry<Block> CASING_PUMP_DECK;
    public static final BlockEntry<Block> MACHINE_CASING_ULV;
    public static final BlockEntry<Block> MACHINE_CASING_LV;
    public static final BlockEntry<Block> MACHINE_CASING_MV;
    public static final BlockEntry<Block> MACHINE_CASING_HV;
    public static final BlockEntry<Block> MACHINE_CASING_EV;
    public static final BlockEntry<Block> MACHINE_CASING_IV;
    public static final BlockEntry<Block> MACHINE_CASING_LuV;
    public static final BlockEntry<Block> MACHINE_CASING_ZPM;
    public static final BlockEntry<Block> MACHINE_CASING_UV;
    public static final BlockEntry<Block> MACHINE_CASING_UHV;
    public static final BlockEntry<Block> MACHINE_CASING_UEV;
    public static final BlockEntry<Block> MACHINE_CASING_UIV;
    public static final BlockEntry<Block> MACHINE_CASING_UXV;
    public static final BlockEntry<Block> MACHINE_CASING_OpV;
    public static final BlockEntry<Block> MACHINE_CASING_MAX;
    public static final BlockEntry<Block> HERMETIC_CASING_LV;
    public static final BlockEntry<Block> HERMETIC_CASING_MV;
    public static final BlockEntry<Block> HERMETIC_CASING_HV;
    public static final BlockEntry<Block> HERMETIC_CASING_EV;
    public static final BlockEntry<Block> HERMETIC_CASING_IV;
    public static final BlockEntry<Block> HERMETIC_CASING_LuV;
    public static final BlockEntry<Block> HERMETIC_CASING_ZPM;
    public static final BlockEntry<Block> HERMETIC_CASING_UV;
    public static final BlockEntry<Block> HERMETIC_CASING_UHV;
    public static final BlockEntry<Block> BRONZE_HULL;
    public static final BlockEntry<Block> BRONZE_BRICKS_HULL;
    public static final BlockEntry<Block> STEEL_HULL;
    public static final BlockEntry<Block> STEEL_BRICKS_HULL;
    public static final BlockEntry<CoilBlock> COIL_CUPRONICKEL;
    public static final BlockEntry<CoilBlock> COIL_KANTHAL;
    public static final BlockEntry<CoilBlock> COIL_NICHROME;
    public static final BlockEntry<CoilBlock> COIL_RTMALLOY;
    public static final BlockEntry<CoilBlock> COIL_HSSG;
    public static final BlockEntry<CoilBlock> COIL_NAQUADAH;
    public static final BlockEntry<CoilBlock> COIL_TRINIUM;
    public static final BlockEntry<CoilBlock> COIL_TRITANIUM;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_I;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_EV;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_IV;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_II;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_LuV;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_ZPM;
    public static final BlockEntry<BatteryBlock> BATTERY_EMPTY_TIER_III;
    public static final BlockEntry<BatteryBlock> BATTERY_LAPOTRONIC_UV;
    public static final BlockEntry<BatteryBlock> BATTERY_ULTIMATE_UHV;
    public static final BlockEntry<ActiveBlock> CASING_ENGINE_INTAKE;
    public static final BlockEntry<ActiveBlock> CASING_EXTREME_ENGINE_INTAKE;
    public static final Map<IFusionCasingType, Supplier<FusionCasingBlock>> ALL_FUSION_CASINGS;
    public static final BlockEntry<FusionCasingBlock> SUPERCONDUCTING_COIL;
    public static final BlockEntry<FusionCasingBlock> FUSION_COIL;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING_MK2;
    public static final BlockEntry<FusionCasingBlock> FUSION_CASING_MK3;
    public static final BlockEntry<GlassBlock> FUSION_GLASS;
    public static final BlockEntry<Block> PLASTCRETE;
    public static final BlockEntry<Block> FILTER_CASING;
    public static final BlockEntry<Block> FILTER_CASING_STERILE;
    public static final BlockEntry<GlassBlock> CLEANROOM_GLASS;
    public static final Map<BoilerFireboxType, BlockEntry<ActiveBlock>> ALL_FIREBOXES;
    public static final BlockEntry<ActiveBlock> FIREBOX_BRONZE;
    public static final BlockEntry<ActiveBlock> FIREBOX_STEEL;
    public static final BlockEntry<ActiveBlock> FIREBOX_TITANIUM;
    public static final BlockEntry<ActiveBlock> FIREBOX_TUNGSTENSTEEL;
    public static final BlockEntry<Block> COMPUTER_CASING;
    public static final BlockEntry<Block> ADVANCED_COMPUTER_CASING;
    public static final BlockEntry<Block> COMPUTER_HEAT_VENT;
    public static final BlockEntry<Block> HIGH_POWER_CASING;
    public static final BlockEntry<PowderbarrelBlock> POWDERBARREL;
    public static final BlockEntry<IndustrialTNTBlock> INDUSTRIAL_TNT;
    public static final BlockEntry<SaplingBlock> RUBBER_SAPLING;
    public static final BlockEntry<RubberLogBlock> RUBBER_LOG;
    public static final float[] RUBBER_LEAVES_DROPPING_CHANCE;
    public static final BlockEntry<LeavesBlock> RUBBER_LEAVES;
    public static final BlockSetType RUBBER_SET;
    public static final WoodType RUBBER_TYPE;
    public static final BlockEntry<RotatedPillarBlock> STRIPPED_RUBBER_LOG;
    public static final BlockEntry<RubberWoodBlock> RUBBER_WOOD;
    public static final BlockEntry<RotatedPillarBlock> STRIPPED_RUBBER_WOOD;
    public static final BlockEntry<Block> RUBBER_PLANK;
    public static final BlockEntry<SlabBlock> RUBBER_SLAB;
    public static final BlockEntry<FenceBlock> RUBBER_FENCE;
    public static final BlockEntry<GTStandingSignBlock> RUBBER_SIGN;
    public static final BlockEntry<GTWallSignBlock> RUBBER_WALL_SIGN;
    public static final BlockEntry<GTCeilingHangingSignBlock> RUBBER_HANGING_SIGN;
    public static final BlockEntry<GTWallHangingSignBlock> RUBBER_WALL_HANGING_SIGN;
    public static final BlockEntry<PressurePlateBlock> RUBBER_PRESSURE_PLATE;
    public static final BlockEntry<TrapDoorBlock> RUBBER_TRAPDOOR;
    public static final BlockEntry<StairBlock> RUBBER_STAIRS;
    public static final BlockEntry<ButtonBlock> RUBBER_BUTTON;
    public static final BlockEntry<FenceGateBlock> RUBBER_FENCE_GATE;
    public static final BlockEntry<DoorBlock> RUBBER_DOOR;
    public static final BlockSetType TREATED_WOOD_SET;
    public static final WoodType TREATED_WOOD_TYPE;
    public static final BlockEntry<Block> TREATED_WOOD_PLANK;
    public static final BlockEntry<SlabBlock> TREATED_WOOD_SLAB;
    public static final BlockEntry<FenceBlock> TREATED_WOOD_FENCE;
    public static final BlockEntry<GTStandingSignBlock> TREATED_WOOD_SIGN;
    public static final BlockEntry<GTWallSignBlock> TREATED_WOOD_WALL_SIGN;
    public static final BlockEntry<GTCeilingHangingSignBlock> TREATED_WOOD_HANGING_SIGN;
    public static final BlockEntry<GTWallHangingSignBlock> TREATED_WOOD_WALL_HANGING_SIGN;
    public static final BlockEntry<PressurePlateBlock> TREATED_WOOD_PRESSURE_PLATE;
    public static final BlockEntry<TrapDoorBlock> TREATED_WOOD_TRAPDOOR;
    public static final BlockEntry<StairBlock> TREATED_WOOD_STAIRS;
    public static final BlockEntry<ButtonBlock> TREATED_WOOD_BUTTON;
    public static final BlockEntry<FenceGateBlock> TREATED_WOOD_FENCE_GATE;
    public static final BlockEntry<DoorBlock> TREATED_WOOD_DOOR;
    public static final BlockEntry<Block> ACID_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> ANTIMATTER_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> BIO_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> BOSS_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> CAUSALITY_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> EXPLOSION_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> FIRE_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> FROST_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> GENERIC_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> GREGIFICATION_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> HIGH_PRESSURE_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> HIGH_VOLTAGE_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> HIGH_TEMPERATURE_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> LASER_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> MAGIC_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> MAGNETIC_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> MOB_INFESTATION_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> MOB_SPAWNER_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> NOISE_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> RADIOACTIVE_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> SPATIAL_STORAGE_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> TURRET_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> VOID_HAZARD_SIGN_BLOCK;
    public static final BlockEntry<Block> YELLOW_STRIPES_BLOCK_A;
    public static final BlockEntry<Block> YELLOW_STRIPES_BLOCK_B;
    public static Table<StoneBlockType, StoneTypes, BlockEntry<Block>> STONE_BLOCKS;
    public static Map<TagPrefix, Supplier<BlockState>> COBBLE_BLOCKS;
    public static BlockEntry<Block> RED_GRANITE;
    public static BlockEntry<Block> MARBLE;
    public static BlockEntry<Block> LIGHT_CONCRETE;
    public static BlockEntry<Block> DARK_CONCRETE;
    public static BlockEntry<Block> BRITTLE_CHARCOAL;
    public static final BlockEntry<FoamBlock> FOAM;
    public static final BlockEntry<FoamBlock> REINFORCED_FOAM;
    public static final BlockEntry<Block> PETRIFIED_FOAM;
    public static final BlockEntry<Block> REINFORCED_STONE;
    public static final Map<DyeColor, BlockEntry<LampBlock>> LAMPS;
    public static final Map<DyeColor, BlockEntry<LampBlock>> BORDERLESS_LAMPS;
    public static final Map<DyeColor, BlockEntry<Block>> METAL_SHEETS;
    public static final Map<DyeColor, BlockEntry<Block>> LARGE_METAL_SHEETS;
    public static final Map<DyeColor, BlockEntry<Block>> STUDS;

    private static void generateLaserPipeBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Laser Pipe Blocks...");
        for (int i = 0; i < LaserPipeType.values().length; ++i) {
            GTBlocks.registerLaserPipeBlock(i);
        }
        GTCEu.LOGGER.debug("Generating GTCEu Laser Pipe Blocks... Complete!");
    }

    private static void registerLaserPipeBlock(int index) {
        BlockEntry entry;
        LaserPipeType type = LaserPipeType.values()[index];
        GTBlocks.LASER_PIPES[index] = entry = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_laser_pipe".formatted(type.m_7912_()), p -> new LaserPipeBlock((BlockBehaviour.Properties)p, type)).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60988_().m_60955_().m_280606_()).blockstate(NonNullBiConsumer.noop()).defaultLoot().tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WIRE_CUTTER}).addLayer(() -> RenderType::m_110457_).addLayer(() -> RenderType::m_110466_).color(() -> LaserPipeBlock::tintedColor).item(LaserPipeBlockItem::new).model(NonNullBiConsumer.noop()).color(() -> LaserPipeBlockItem::tintColor).build()).register();
    }

    private static void generateOpticalPipeBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Optical Pipe Blocks...");
        for (int i = 0; i < OpticalPipeType.values().length; ++i) {
            GTBlocks.registerOpticalPipeBlock(i);
        }
        GTCEu.LOGGER.debug("Generating GTCEu Optical Pipe Blocks... Complete!");
    }

    private static void registerOpticalPipeBlock(int index) {
        BlockEntry entry;
        OpticalPipeType type = OpticalPipeType.values()[index];
        GTBlocks.OPTICAL_PIPES[index] = entry = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_optical_pipe".formatted(type.m_7912_()), p -> new OpticalPipeBlock((BlockBehaviour.Properties)p, type)).lang("Optical Fiber Cable").initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60988_().m_60955_().m_280606_()).blockstate(NonNullBiConsumer.noop()).defaultLoot().tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WIRE_CUTTER}).addLayer(() -> RenderType::m_110457_).addLayer(() -> RenderType::m_110466_).color(() -> OpticalPipeBlock::tintedColor).item(OpticalPipeBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static void generateDuctPipeBlocks() {
        GTCEu.LOGGER.debug("Generating GTCEu Duct Pipe Blocks...");
        for (int i = 0; i < DuctPipeType.VALUES.length; ++i) {
            GTBlocks.registerDuctPipeBlock(i);
        }
        GTCEu.LOGGER.debug("Generating GTCEu Duct Pipe Blocks... Complete!");
    }

    private static void registerDuctPipeBlock(int index) {
        BlockEntry entry;
        DuctPipeType type = DuctPipeType.VALUES[index];
        GTBlocks.DUCT_PIPES[index] = entry = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_duct_pipe".formatted(type.m_7912_()), p -> new DuctPipeBlock((BlockBehaviour.Properties)p, type)).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60988_().m_60955_().m_280606_()).blockstate(NonNullBiConsumer.noop()).defaultLoot().tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).addLayer(() -> RenderType::m_110457_).addLayer(() -> RenderType::m_110466_).item(DuctPipeBlockItem::new).model(NonNullBiConsumer.noop()).build()).register();
    }

    private static BlockEntry<Block> createSidedCasingBlock(String name, ResourceLocation texture) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).blockstate((NonNullBiConsumer)GTModels.createSidedCasingModel(texture)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
    }

    private static BlockEntry<Block> createBrickCasingBlock(String name, ResourceLocation texture) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).exBlockstate(GTModels.cubeAllModel(texture)).tag(new TagKey[]{BlockTags.f_144282_}).item(BlockItem::new).build()).register();
    }

    private static BlockEntry<GlassBlock> createGlassCasingBlock(String name, ResourceLocation texture, Supplier<Supplier<RenderType>> type) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(name, GlassBlock::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).addLayer((Supplier)type).exBlockstate(GTModels.cubeAllModel(texture)).tag(new TagKey[]{BlockTags.f_144282_}).item(BlockItem::new).build()).register();
    }

    public static BlockEntry<Block> createCasingBlock(String name, ResourceLocation texture) {
        return GTBlocks.createCasingBlock(name, (NonNullFunction<BlockBehaviour.Properties, Block>)((NonNullFunction)Block::new), texture, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50075_), () -> RenderType::m_110451_);
    }

    public static BlockEntry<Block> createCasingBlock(String name, NonNullFunction<BlockBehaviour.Properties, Block> blockSupplier, ResourceLocation texture, NonNullSupplier<? extends Block> properties, Supplier<Supplier<RenderType>> type) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(name, (NonNullFunction)blockSupplier).initialProperties((NonNullSupplier)properties).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).addLayer((Supplier)type).exBlockstate(GTModels.cubeAllModel(texture)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
    }

    private static BlockEntry<Block> createMachineCasingBlock(int tier) {
        String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
        BlockEntry entry = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_machine_casing".formatted(tierName), Block::new).lang("%s Machine Casing".formatted(GTValues.VN[tier])).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).blockstate((NonNullBiConsumer)GTModels.createMachineCasingModel(tierName)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
        if (!GTCEuAPI.isHighTier() && tier > 9) {
            GTRegistration.REGISTRATE.setCreativeTab((RegistryEntry<?>)entry, null);
        }
        return entry;
    }

    private static BlockEntry<Block> createHermeticCasing(int tier) {
        String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
        BlockEntry entry = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_hermetic_casing".formatted(tierName), Block::new).lang("Hermetic Casing %s".formatted(GTValues.LVT[tier])).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).addLayer(() -> RenderType::m_110457_).blockstate((NonNullBiConsumer)GTModels.createHermeticCasingModel(tierName)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
        if (!GTCEuAPI.isHighTier() && tier > 9) {
            GTRegistration.REGISTRATE.setCreativeTab((RegistryEntry<?>)entry, null);
        }
        return entry;
    }

    private static BlockEntry<Block> createSteamCasing(String name, String material) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.f_50075_).blockstate((NonNullBiConsumer)GTModels.createSteamCasingModel(material)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
    }

    private static BlockEntry<CoilBlock> createCoilBlock(ICoilType coilType) {
        BlockEntry coilBlock = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_coil_block".formatted(coilType.getName()), p -> new CoilBlock((BlockBehaviour.Properties)p, coilType)).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).addLayer(() -> RenderType::m_110457_).blockstate((NonNullBiConsumer)GTModels.createCoilModel(coilType)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
        GTCEuAPI.HEATING_COILS.put(coilType, (Supplier<CoilBlock>)coilBlock);
        return coilBlock;
    }

    private static BlockEntry<BatteryBlock> createBatteryBlock(IBatteryData batteryData) {
        BlockEntry batteryBlock = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_battery".formatted(batteryData.getBatteryName()), p -> new BatteryBlock((BlockBehaviour.Properties)p, batteryData)).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, entityType) -> false)).blockstate((NonNullBiConsumer)GTModels.createBatteryBlockModel(batteryData)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
        GTCEuAPI.PSS_BATTERIES.put(batteryData, (Supplier<BatteryBlock>)batteryBlock);
        return batteryBlock;
    }

    private static BlockEntry<FusionCasingBlock> createFusionCasing(IFusionCasingType casingType) {
        BlockEntry casingBlock = ((BlockBuilder)GTRegistration.REGISTRATE.block(casingType.m_7912_(), p -> new FusionCasingBlock((BlockBehaviour.Properties)p, casingType)).initialProperties(() -> Blocks.f_50075_).properties(properties -> properties.m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56743_)).addLayer(() -> RenderType::m_110457_).blockstate((NonNullBiConsumer)GTModels.createFusionCasingModel(casingType)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH, CustomTags.TOOL_TIERS[casingType.getHarvestLevel()]}).item(BlockItem::new).build()).register();
        ALL_FUSION_CASINGS.put(casingType, (Supplier<FusionCasingBlock>)casingBlock);
        return casingBlock;
    }

    private static BlockEntry<Block> createCleanroomFilter(IFilterType filterType) {
        BlockEntry filterBlock = ((BlockBuilder)GTRegistration.REGISTRATE.block(filterType.m_7912_(), Block::new).initialProperties(() -> Blocks.f_50075_).properties(properties -> properties.m_60913_(2.0f, 8.0f).m_60918_(SoundType.f_56743_).m_60922_((blockState, blockGetter, blockPos, entityType) -> false)).blockstate((NonNullBiConsumer)GTModels.createCleanroomFilterModel(filterType)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH, CustomTags.TOOL_TIERS[1]}).item(BlockItem::new).build()).register();
        GTCEuAPI.CLEANROOM_FILTERS.put(filterType, (Supplier<Block>)filterBlock);
        return filterBlock;
    }

    protected static BlockEntry<ActiveBlock> createActiveCasing(String name, String baseModelPath) {
        return ((BlockBuilder)GTRegistration.REGISTRATE.block(name, ActiveBlock::new).initialProperties(() -> Blocks.f_50075_).addLayer(() -> RenderType::m_110457_).blockstate((NonNullBiConsumer)GTModels.createActiveModel(GTCEu.id(baseModelPath))).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).model((ctx, prov) -> prov.withExistingParent(prov.name((NonNullSupplier)ctx), GTCEu.id(baseModelPath))).build()).register();
    }

    private static BlockEntry<ActiveBlock> createFireboxCasing(BoilerFireboxType type) {
        BlockEntry block = ((BlockBuilder)GTRegistration.REGISTRATE.block("%s_casing".formatted(type.name()), ActiveBlock::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).addLayer(() -> RenderType::m_110457_).blockstate((NonNullBiConsumer)GTModels.createFireboxModel(type)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
        ALL_FIREBOXES.put(type, (BlockEntry<ActiveBlock>)block);
        return block;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor leavesBlockColor() {
        return (state, reader, pos, tintIndex) -> {
            if (reader != null && pos != null) {
                return BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos);
            }
            return FoliageColor.m_46113_();
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor leavesItemColor() {
        return (stack, tintIndex) -> FoliageColor.m_46113_();
    }

    public static void generateStoneBlocks() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (StoneTypes strata : StoneTypes.values()) {
            if (!strata.generateBlocks) continue;
            for (StoneBlockType type : StoneBlockType.values()) {
                String blockId = type.blockId.formatted(strata.m_7912_());
                if (BuiltInRegistries.f_256975_.m_7804_(new ResourceLocation(blockId))) continue;
                BlockBuilder entry = (BlockBuilder)((BlockBuilder)GTRegistration.REGISTRATE.block(blockId, Block::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(type.hardness, type.resistance).m_284180_(strata.mapColor)).transform(type == StoneBlockType.STONE ? GTBlocks.unificationBlock(strata.getTagPrefix(), strata.getMaterial()) : builder2 -> builder2)).tag(new TagKey[]{BlockTags.f_144282_, CustomTags.NEEDS_WOOD_TOOL}).loot((tables, block) -> {
                    if (type == StoneBlockType.STONE) {
                        tables.m_247577_(block, tables.m_245514_(block, (ItemLike)((BlockEntry)STONE_BLOCKS.get((Object)StoneBlockType.COBBLE, (Object)strata)).get()));
                    } else {
                        tables.m_247577_(block, tables.m_247033_((ItemLike)block));
                    }
                }).item().build();
                if (type == StoneBlockType.STONE && strata.isNatural()) {
                    entry.tag(new TagKey[]{BlockTags.f_144266_, BlockTags.f_13061_, BlockTags.f_144273_, BlockTags.f_144276_}).blockstate(GTModels.randomRotatedModel(GTCEu.id("block/stones/" + strata.m_7912_() + "/" + type.id)));
                } else {
                    entry.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().singleTexture(ctx.getName(), prov.mcLoc("block/cube_all"), "all", prov.modLoc("block/stones/" + strata.m_7912_() + "/" + type.id))));
                }
                if (type == StoneBlockType.STONE) {
                    entry.tag(new TagKey[]{Tags.Blocks.STONE});
                }
                if (type == StoneBlockType.COBBLE) {
                    entry.tag(new TagKey[]{Tags.Blocks.COBBLESTONE});
                }
                builder.put((Object)type, (Object)strata, (Object)entry.register());
            }
        }
        STONE_BLOCKS = builder.build();
        STONE_BLOCKS.row((Object)StoneBlockType.COBBLE).forEach((ore, block) -> {
            if (ore.generateBlocks) {
                GTBlocks.registerCobbleBlock(ore.getTagPrefix(), () -> ((BlockEntry)block).getDefaultState());
            }
        });
        RED_GRANITE = (BlockEntry)STONE_BLOCKS.get((Object)StoneBlockType.STONE, (Object)StoneTypes.RED_GRANITE);
        MARBLE = (BlockEntry)STONE_BLOCKS.get((Object)StoneBlockType.STONE, (Object)StoneTypes.MARBLE);
        LIGHT_CONCRETE = (BlockEntry)STONE_BLOCKS.get((Object)StoneBlockType.STONE, (Object)StoneTypes.CONCRETE_LIGHT);
        DARK_CONCRETE = (BlockEntry)STONE_BLOCKS.get((Object)StoneBlockType.STONE, (Object)StoneTypes.CONCRETE_DARK);
    }

    public static <P, T extends Block, S2 extends BlockBuilder<T, P>> NonNullFunction<S2, S2> unificationBlock(@NotNull TagPrefix tagPrefix, @NotNull Material mat) {
        return builder -> {
            builder.onRegister(block -> {
                MemoizedBlockSupplier<Block> blockSupplier = GTMemoizer.memoizeBlockSupplier(() -> block);
                MaterialEntry entry = new MaterialEntry(tagPrefix, mat);
                GTMaterialItems.toUnify.put(entry, blockSupplier);
                ItemMaterialData.registerMaterialEntry(blockSupplier, entry);
            });
            return builder;
        };
    }

    public static void registerCobbleBlock(TagPrefix orePrefix, Supplier<BlockState> state) {
        COBBLE_BLOCKS.put(orePrefix, state);
    }

    public static void removeCobbleBlock(TagPrefix orePrefix) {
        COBBLE_BLOCKS.remove(orePrefix);
    }

    public static void init() {
        GTBlocks.generateStoneBlocks();
        GTBlocks.initializeCobbleReplacements();
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_BLOCK);
        GTMaterialBlocks.generateMaterialBlocks();
        GTMaterialBlocks.generateOreBlocks();
        GTMaterialBlocks.generateOreIndicators();
        GTMaterialBlocks.MATERIAL_BLOCKS = GTMaterialBlocks.MATERIAL_BLOCKS_BUILDER.build();
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_PIPE);
        GTMaterialBlocks.generateCableBlocks();
        GTMaterialBlocks.generateFluidPipeBlocks();
        GTMaterialBlocks.generateItemPipeBlocks();
        GTBlocks.generateLaserPipeBlocks();
        GTBlocks.generateOpticalPipeBlocks();
        GTBlocks.generateDuctPipeBlocks();
        GTMaterialBlocks.MATERIAL_BLOCKS_BUILDER = null;
        GTMaterialBlocks.SURFACE_ROCK_BLOCKS_BUILDER = null;
        GTMaterialBlocks.CABLE_BLOCKS_BUILDER = null;
        GTMaterialBlocks.FLUID_PIPE_BLOCKS_BUILDER = null;
        GTMaterialBlocks.ITEM_PIPE_BLOCKS_BUILDER = null;
        GCYMBlocks.init();
    }

    private static void initializeCobbleReplacements() {
        GTBlocks.registerCobbleBlock(TagPrefix.ore, () -> ((Block)Blocks.f_50652_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreDeepslate, () -> ((Block)Blocks.f_152551_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreAndesite, () -> ((Block)Blocks.f_50334_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreDiorite, () -> ((Block)Blocks.f_50228_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreGranite, () -> ((Block)Blocks.f_50122_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreSand, () -> ((Block)Blocks.f_49992_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreGravel, () -> ((Block)Blocks.f_49994_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreRedSand, () -> ((Block)Blocks.f_49993_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreBasalt, () -> ((Block)Blocks.f_50137_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreBlackstone, () -> ((Block)Blocks.f_50730_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreEndstone, () -> ((Block)Blocks.f_50259_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreNetherrack, () -> ((Block)Blocks.f_50134_).m_49966_());
        GTBlocks.registerCobbleBlock(TagPrefix.oreTuff, () -> ((Block)Blocks.f_152496_).m_49966_());
    }

    public static boolean doMetalPipe(Material material) {
        return GTValues.FOOLS.getAsBoolean() && material.hasProperty(PropertyKey.INGOT) && !material.hasProperty(PropertyKey.POLYMER) && !material.hasProperty(PropertyKey.WOOD);
    }

    public static BlockBehaviour.Properties copy(BlockBehaviour.Properties props, BlockBehaviour.Properties newProps) {
        if (props == null) {
            return newProps;
        }
        newProps.m_155954_(((BlockPropertiesAccessor)props).getDestroyTime());
        newProps.m_155956_(((BlockPropertiesAccessor)props).getExplosionResistance());
        if (!((BlockPropertiesAccessor)props).isHasCollision()) {
            newProps.m_60910_();
        }
        if (((BlockPropertiesAccessor)props).isIsRandomlyTicking()) {
            newProps.m_60977_();
        }
        newProps.m_60953_(((BlockPropertiesAccessor)props).getLightEmission());
        newProps.m_284495_(((BlockPropertiesAccessor)props).getMapColor());
        newProps.m_60918_(((BlockPropertiesAccessor)props).getSoundType());
        newProps.m_60911_(((BlockPropertiesAccessor)props).getFriction());
        newProps.m_60956_(((BlockPropertiesAccessor)props).getSpeedFactor());
        if (((BlockPropertiesAccessor)props).isDynamicShape()) {
            newProps.m_60988_();
        }
        if (!((BlockPropertiesAccessor)props).isCanOcclude()) {
            newProps.m_60955_();
        }
        if (((BlockPropertiesAccessor)props).isIsAir()) {
            newProps.m_60996_();
        }
        if (((BlockPropertiesAccessor)props).isIgnitedByLava()) {
            newProps.m_278183_();
        }
        if (((BlockPropertiesAccessor)props).isLiquid()) {
            newProps.m_278788_();
        }
        if (((BlockPropertiesAccessor)props).isForceSolidOff()) {
            newProps.m_280574_();
        }
        if (((BlockPropertiesAccessor)props).isForceSolidOn()) {
            newProps.m_280606_();
        }
        newProps.m_278166_(((BlockPropertiesAccessor)props).getPushReaction());
        if (((BlockPropertiesAccessor)props).isRequiresCorrectToolForDrops()) {
            newProps.m_60999_();
        }
        ((BlockPropertiesAccessor)newProps).setOffsetFunction(((BlockPropertiesAccessor)props).getOffsetFunction());
        if (!((BlockPropertiesAccessor)props).isSpawnParticlesOnBreak()) {
            newProps.m_246721_();
        }
        ((BlockPropertiesAccessor)newProps).setRequiredFeatures(((BlockPropertiesAccessor)props).getRequiredFeatures());
        newProps.m_60991_(((BlockPropertiesAccessor)props).getEmissiveRendering());
        newProps.m_280658_(((BlockPropertiesAccessor)props).getInstrument());
        if (((BlockPropertiesAccessor)props).isReplaceable()) {
            newProps.m_280170_();
        }
        return newProps;
    }

    static {
        DyeColor[] colors;
        LASER_PIPES = new BlockEntry[LaserPipeType.values().length];
        OPTICAL_PIPES = new BlockEntry[OpticalPipeType.values().length];
        DUCT_PIPES = new BlockEntry[DuctPipeType.VALUES.length];
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_PIPE);
        LD_ITEM_PIPE = GTRegistration.REGISTRATE.block("long_distance_item_pipeline", properties -> new LongDistancePipeBlock((BlockBehaviour.Properties)properties, LDItemPipeType.INSTANCE)).initialProperties(() -> Blocks.f_50075_).exBlockstate(GTModels.cubeAllModel(GTCEu.id("block/pipe/ld_item_pipe/block"))).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH, BlockTags.f_144286_}).simpleItem().register();
        LD_FLUID_PIPE = GTRegistration.REGISTRATE.block("long_distance_fluid_pipeline", properties -> new LongDistancePipeBlock((BlockBehaviour.Properties)properties, LDFluidPipeType.INSTANCE)).initialProperties(() -> Blocks.f_50075_).exBlockstate(GTModels.cubeAllModel(GTCEu.id("block/pipe/ld_fluid_pipe/block"))).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH, BlockTags.f_144286_}).simpleItem().register();
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.DECORATION);
        CASING_WOOD_WALL = GTBlocks.createSidedCasingBlock("wood_wall", GTCEu.id("block/casings/wood_wall"));
        CASING_COKE_BRICKS = GTBlocks.createBrickCasingBlock("coke_oven_bricks", GTCEu.id("block/casings/solid/machine_coke_bricks"));
        CASING_PRIMITIVE_BRICKS = GTBlocks.createBrickCasingBlock("firebricks", GTCEu.id("block/casings/solid/machine_primitive_bricks"));
        CASING_BRONZE_BRICKS = GTBlocks.createCasingBlock("steam_machine_casing", GTCEu.id("block/casings/solid/machine_casing_bronze_plated_bricks"));
        CASING_INVAR_HEATPROOF = GTBlocks.createCasingBlock("heatproof_machine_casing", GTCEu.id("block/casings/solid/machine_casing_heatproof"));
        CASING_ALUMINIUM_FROSTPROOF = GTBlocks.createCasingBlock("frostproof_machine_casing", GTCEu.id("block/casings/solid/machine_casing_frost_proof"));
        CASING_STEEL_SOLID = GTBlocks.createCasingBlock("solid_machine_casing", GTCEu.id("block/casings/solid/machine_casing_solid_steel"));
        CASING_STAINLESS_CLEAN = GTBlocks.createCasingBlock("clean_machine_casing", GTCEu.id("block/casings/solid/machine_casing_clean_stainless_steel"));
        CASING_TITANIUM_STABLE = GTBlocks.createCasingBlock("stable_machine_casing", GTCEu.id("block/casings/solid/machine_casing_stable_titanium"));
        CASING_TUNGSTENSTEEL_ROBUST = GTBlocks.createCasingBlock("robust_machine_casing", GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"));
        CASING_PTFE_INERT = GTBlocks.createCasingBlock("inert_machine_casing", GTCEu.id("block/casings/solid/machine_casing_inert_ptfe"));
        CASING_HSSE_STURDY = GTBlocks.createCasingBlock("sturdy_machine_casing", GTCEu.id("block/casings/solid/machine_casing_sturdy_hsse"));
        CASING_PALLADIUM_SUBSTATION = GTBlocks.createCasingBlock("palladium_substation", GTCEu.id("block/casings/solid/machine_casing_palladium_substation"));
        CASING_TEMPERED_GLASS = GTBlocks.createGlassCasingBlock("tempered_glass", GTCEu.id("block/casings/transparent/tempered_glass"), () -> RenderType::m_110466_);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)GTMaterials.Bronze, CASING_BRONZE_BRICKS);
        builder.put((Object)GTMaterials.Invar, CASING_INVAR_HEATPROOF);
        builder.put((Object)GTMaterials.Aluminium, CASING_ALUMINIUM_FROSTPROOF);
        builder.put((Object)GTMaterials.Steel, CASING_STEEL_SOLID);
        builder.put((Object)GTMaterials.StainlessSteel, CASING_STAINLESS_CLEAN);
        builder.put((Object)GTMaterials.Titanium, CASING_TITANIUM_STABLE);
        builder.put((Object)GTMaterials.TungstenSteel, CASING_TUNGSTENSTEEL_ROBUST);
        builder.put((Object)GTMaterials.Polytetrafluoroethylene, CASING_PTFE_INERT);
        builder.put((Object)GTMaterials.HSSE, CASING_HSSE_STURDY);
        builder.put((Object)GTMaterials.HSLASteel, GCYMBlocks.CASING_NONCONDUCTING);
        builder.put((Object)GTMaterials.IncoloyMA956, GCYMBlocks.CASING_VIBRATION_SAFE);
        builder.put((Object)GTMaterials.WatertightSteel, GCYMBlocks.CASING_WATERTIGHT);
        builder.put((Object)GTMaterials.Zeron100, GCYMBlocks.CASING_SECURE_MACERATION);
        builder.put((Object)GTMaterials.TungstenCarbide, GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING);
        builder.put((Object)GTMaterials.TitaniumTungstenCarbide, GCYMBlocks.CASING_LASER_SAFE_ENGRAVING);
        builder.put((Object)GTMaterials.Stellite100, GCYMBlocks.CASING_LARGE_SCALE_ASSEMBLING);
        builder.put((Object)GTMaterials.HastelloyC276, GCYMBlocks.CASING_SHOCK_PROOF);
        MaterialCasingCollectionEvent event = new MaterialCasingCollectionEvent((ImmutableMap.Builder<Material, BlockEntry<Block>>)builder);
        AddonFinder.getAddons().forEach(addon -> addon.collectMaterialCasings(event));
        MATERIALS_TO_CASINGS = builder.build();
        CASING_GRATE = GTBlocks.createCasingBlock("assembly_line_grating", GTCEu.id("block/casings/pipe/machine_casing_grate"));
        CASING_ASSEMBLY_CONTROL = GTBlocks.createCasingBlock("assembly_line_casing", GTCEu.id("block/casings/mechanic/machine_casing_assembly_control"));
        CASING_LAMINATED_GLASS = GTBlocks.createGlassCasingBlock("laminated_glass", GTCEu.id("block/casings/transparent/laminated_glass"), () -> RenderType::m_110457_);
        CASING_ASSEMBLY_LINE = GTBlocks.createActiveCasing("assembly_line_unit", "block/variant/assembly_line");
        CASING_BRONZE_GEARBOX = GTBlocks.createCasingBlock("bronze_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_bronze"));
        CASING_STEEL_GEARBOX = GTBlocks.createCasingBlock("steel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_steel"));
        CASING_STAINLESS_STEEL_GEARBOX = GTBlocks.createCasingBlock("stainless_steel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_stainless_steel"));
        CASING_TITANIUM_GEARBOX = GTBlocks.createCasingBlock("titanium_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_titanium"));
        CASING_TUNGSTENSTEEL_GEARBOX = GTBlocks.createCasingBlock("tungstensteel_gearbox", GTCEu.id("block/casings/gearbox/machine_casing_gearbox_tungstensteel"));
        CASING_STEEL_TURBINE = GTBlocks.createCasingBlock("steel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_steel"));
        CASING_TITANIUM_TURBINE = GTBlocks.createCasingBlock("titanium_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_titanium"));
        CASING_STAINLESS_TURBINE = GTBlocks.createCasingBlock("stainless_steel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_stainless_steel"));
        CASING_TUNGSTENSTEEL_TURBINE = GTBlocks.createCasingBlock("tungstensteel_turbine_casing", GTCEu.id("block/casings/mechanic/machine_casing_turbine_tungstensteel"));
        CASING_BRONZE_PIPE = GTBlocks.createCasingBlock("bronze_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_bronze"));
        CASING_STEEL_PIPE = GTBlocks.createCasingBlock("steel_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_steel"));
        CASING_TITANIUM_PIPE = GTBlocks.createCasingBlock("titanium_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_titanium"));
        CASING_TUNGSTENSTEEL_PIPE = GTBlocks.createCasingBlock("tungstensteel_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_tungstensteel"));
        CASING_POLYTETRAFLUOROETHYLENE_PIPE = GTBlocks.createCasingBlock("ptfe_pipe_casing", GTCEu.id("block/casings/pipe/machine_casing_pipe_polytetrafluoroethylene"));
        MINER_PIPE = GTRegistration.REGISTRATE.block("miner_pipe", MinerPipeBlock::new).initialProperties(() -> Blocks.f_50752_).properties(BlockBehaviour.Properties::m_60955_).addLayer(() -> RenderType::m_110457_).exBlockstate(GTModels.createModelBlockState(GTCEu.id("block/miner_pipe"))).tag(new TagKey[]{BlockTags.f_13069_, BlockTags.f_13070_, BlockTags.f_13060_, BlockTags.f_144287_, BlockTags.f_144289_}).register();
        CASING_PUMP_DECK = ((BlockBuilder)GTRegistration.REGISTRATE.block("pump_deck", Block::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283825_)).blockstate((NonNullBiConsumer)GTModels.createSidedCasingModel(GTCEu.id("block/casings/pump_deck"))).tag(new TagKey[]{CustomTags.MINEABLE_WITH_WRENCH, BlockTags.f_144280_}).item(BlockItem::new).build()).register();
        MACHINE_CASING_ULV = GTBlocks.createMachineCasingBlock(0);
        MACHINE_CASING_LV = GTBlocks.createMachineCasingBlock(1);
        MACHINE_CASING_MV = GTBlocks.createMachineCasingBlock(2);
        MACHINE_CASING_HV = GTBlocks.createMachineCasingBlock(3);
        MACHINE_CASING_EV = GTBlocks.createMachineCasingBlock(4);
        MACHINE_CASING_IV = GTBlocks.createMachineCasingBlock(5);
        MACHINE_CASING_LuV = GTBlocks.createMachineCasingBlock(6);
        MACHINE_CASING_ZPM = GTBlocks.createMachineCasingBlock(7);
        MACHINE_CASING_UV = GTBlocks.createMachineCasingBlock(8);
        MACHINE_CASING_UHV = GTBlocks.createMachineCasingBlock(9);
        MACHINE_CASING_UEV = GTBlocks.createMachineCasingBlock(10);
        MACHINE_CASING_UIV = GTBlocks.createMachineCasingBlock(11);
        MACHINE_CASING_UXV = GTBlocks.createMachineCasingBlock(12);
        MACHINE_CASING_OpV = GTBlocks.createMachineCasingBlock(13);
        MACHINE_CASING_MAX = GTBlocks.createMachineCasingBlock(14);
        HERMETIC_CASING_LV = GTBlocks.createHermeticCasing(1);
        HERMETIC_CASING_MV = GTBlocks.createHermeticCasing(2);
        HERMETIC_CASING_HV = GTBlocks.createHermeticCasing(3);
        HERMETIC_CASING_EV = GTBlocks.createHermeticCasing(4);
        HERMETIC_CASING_IV = GTBlocks.createHermeticCasing(5);
        HERMETIC_CASING_LuV = GTBlocks.createHermeticCasing(6);
        HERMETIC_CASING_ZPM = GTBlocks.createHermeticCasing(7);
        HERMETIC_CASING_UV = GTBlocks.createHermeticCasing(8);
        HERMETIC_CASING_UHV = GTBlocks.createHermeticCasing(9);
        BRONZE_HULL = GTBlocks.createSteamCasing("bronze_machine_casing", "bronze");
        BRONZE_BRICKS_HULL = GTBlocks.createSteamCasing("bronze_brick_casing", "bricked_bronze");
        STEEL_HULL = GTBlocks.createSteamCasing("steel_machine_casing", "steel");
        STEEL_BRICKS_HULL = GTBlocks.createSteamCasing("steel_brick_casing", "bricked_steel");
        COIL_CUPRONICKEL = GTBlocks.createCoilBlock(CoilBlock.CoilType.CUPRONICKEL);
        COIL_KANTHAL = GTBlocks.createCoilBlock(CoilBlock.CoilType.KANTHAL);
        COIL_NICHROME = GTBlocks.createCoilBlock(CoilBlock.CoilType.NICHROME);
        COIL_RTMALLOY = GTBlocks.createCoilBlock(CoilBlock.CoilType.RTMALLOY);
        COIL_HSSG = GTBlocks.createCoilBlock(CoilBlock.CoilType.HSSG);
        COIL_NAQUADAH = GTBlocks.createCoilBlock(CoilBlock.CoilType.NAQUADAH);
        COIL_TRINIUM = GTBlocks.createCoilBlock(CoilBlock.CoilType.TRINIUM);
        COIL_TRITANIUM = GTBlocks.createCoilBlock(CoilBlock.CoilType.TRITANIUM);
        BATTERY_EMPTY_TIER_I = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_I);
        BATTERY_LAPOTRONIC_EV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EV_LAPOTRONIC);
        BATTERY_LAPOTRONIC_IV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.IV_LAPOTRONIC);
        BATTERY_EMPTY_TIER_II = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_II);
        BATTERY_LAPOTRONIC_LuV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.LuV_LAPOTRONIC);
        BATTERY_LAPOTRONIC_ZPM = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.ZPM_LAPOTRONIC);
        BATTERY_EMPTY_TIER_III = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.EMPTY_TIER_III);
        BATTERY_LAPOTRONIC_UV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.UV_LAPOTRONIC);
        BATTERY_ULTIMATE_UHV = GTBlocks.createBatteryBlock(BatteryBlock.BatteryPartType.UHV_ULTIMATE);
        CASING_ENGINE_INTAKE = GTBlocks.createActiveCasing("engine_intake_casing", "block/variant/engine_intake");
        CASING_EXTREME_ENGINE_INTAKE = GTBlocks.createActiveCasing("extreme_engine_intake_casing", "block/variant/extreme_engine_intake");
        ALL_FUSION_CASINGS = new HashMap<IFusionCasingType, Supplier<FusionCasingBlock>>();
        SUPERCONDUCTING_COIL = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.SUPERCONDUCTING_COIL);
        FUSION_COIL = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_COIL);
        FUSION_CASING = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING);
        FUSION_CASING_MK2 = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING_MK2);
        FUSION_CASING_MK3 = GTBlocks.createFusionCasing(FusionCasingBlock.CasingType.FUSION_CASING_MK3);
        FUSION_GLASS = GTBlocks.createGlassCasingBlock("fusion_glass", GTCEu.id("block/casings/transparent/fusion_glass"), () -> RenderType::m_110457_);
        PLASTCRETE = GTBlocks.createCasingBlock("plascrete", GTCEu.id("block/casings/cleanroom/plascrete"));
        FILTER_CASING = GTBlocks.createCleanroomFilter(CleanroomFilterType.FILTER_CASING);
        FILTER_CASING_STERILE = GTBlocks.createCleanroomFilter(CleanroomFilterType.FILTER_CASING_STERILE);
        CLEANROOM_GLASS = GTBlocks.createGlassCasingBlock("cleanroom_glass", GTCEu.id("block/casings/transparent/cleanroom_glass"), () -> RenderType::m_110457_);
        ALL_FIREBOXES = new HashMap<BoilerFireboxType, BlockEntry<ActiveBlock>>();
        FIREBOX_BRONZE = GTBlocks.createFireboxCasing(BoilerFireboxType.BRONZE_FIREBOX);
        FIREBOX_STEEL = GTBlocks.createFireboxCasing(BoilerFireboxType.STEEL_FIREBOX);
        FIREBOX_TITANIUM = GTBlocks.createFireboxCasing(BoilerFireboxType.TITANIUM_FIREBOX);
        FIREBOX_TUNGSTENSTEEL = GTBlocks.createFireboxCasing(BoilerFireboxType.TUNGSTENSTEEL_FIREBOX);
        COMPUTER_CASING = ((BlockBuilder)GTRegistration.REGISTRATE.block("computer_casing", Block::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(GTCEu.id("block/computer_casing")))).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
        ADVANCED_COMPUTER_CASING = ((BlockBuilder)GTRegistration.REGISTRATE.block("advanced_computer_casing", Block::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(GTCEu.id("block/advanced_computer_casing")))).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
        COMPUTER_HEAT_VENT = ((BlockBuilder)GTRegistration.REGISTRATE.block("computer_heat_vent", Block::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, ent) -> false)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeColumn("computer_heat_vent", GTCEu.id("block/casings/hpca/computer_heat_vent_side"), GTCEu.id("block/casings/hpca/computer_heat_vent_top_bot")))).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
        HIGH_POWER_CASING = GTBlocks.createCasingBlock("high_power_casing", GTCEu.id("block/casings/hpca/high_power_casing"));
        POWDERBARREL = GTRegistration.REGISTRATE.block("powderbarrel", PowderbarrelBlock::new).lang("Powderbarrel").properties(p -> p.m_155954_(0.5f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283947_).m_278166_(PushReaction.BLOCK)).tag(new TagKey[]{BlockTags.f_144280_}).simpleItem().register();
        INDUSTRIAL_TNT = GTRegistration.REGISTRATE.block("industrial_tnt", IndustrialTNTBlock::new).lang("Industrial TNT").properties(p -> p.m_284180_(MapColor.f_283816_).m_60966_().m_60918_(SoundType.f_56740_).m_278183_()).tag(new TagKey[]{BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeBottomTop(ctx.getName(), GTCEu.id("block/misc/industrial_tnt_side"), new ResourceLocation("minecraft", "block/tnt_bottom"), new ResourceLocation("minecraft", "block/tnt_top")))).simpleItem().register();
        RUBBER_SAPLING = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_sapling", properties -> new SaplingBlock(new AbstractTreeGrower(){

            protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(@NotNull RandomSource random, boolean largeHive) {
                return GTConfiguredFeatures.RUBBER;
            }
        }, properties)).initialProperties(() -> Blocks.f_50746_).lang("Rubber Sapling").blockstate(GTModels::createCrossBlockState).addLayer(() -> RenderType::m_110463_).tag(new TagKey[]{BlockTags.f_13104_}).item().model(GTModels::rubberTreeSaplingModel).tag(new TagKey[]{ItemTags.f_13180_}).build()).register();
        RUBBER_LOG = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_log", RubberLogBlock::new).properties(p -> p.m_60978_(2.0f).m_60918_(SoundType.f_56736_)).loot((table, block) -> table.m_247577_((Block)block, LootTable.m_79147_().m_79161_(((LootPool.Builder)table.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block))).m_79161_(((LootPool.Builder)table.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GTItems.STICKY_RESIN.get())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)RubberLogBlock.NATURAL, true)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.85f)))))).lang("Rubber Log").tag(new TagKey[]{BlockTags.f_13105_, BlockTags.f_215839_}).blockstate((ctx, provider) -> provider.logBlock((RotatedPillarBlock)ctx.get())).item().tag(new TagKey[]{ItemTags.f_13181_, CustomTags.RUBBER_LOGS}).build()).register();
        RUBBER_LEAVES_DROPPING_CHANCE = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        RUBBER_LEAVES = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_leaves", LeavesBlock::new).initialProperties(() -> Blocks.f_50050_).lang("Rubber Leaves").blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().leaves(ctx.getName(), prov.blockTexture((Block)ctx.get())))).loot((table, block) -> table.m_247577_((Block)block, table.m_246047_((Block)block, (Block)RUBBER_SAPLING.get(), RUBBER_LEAVES_DROPPING_CHANCE))).tag(new TagKey[]{BlockTags.f_13035_, BlockTags.f_144281_}).color(() -> GTBlocks::leavesBlockColor).item().color(() -> GTBlocks::leavesItemColor).tag(new TagKey[]{ItemTags.f_13143_}).build()).register();
        RUBBER_SET = BlockSetType.m_272115_((BlockSetType)new BlockSetType(GTCEu.id("rubber").toString()));
        RUBBER_TYPE = WoodType.m_61844_((WoodType)new WoodType(GTCEu.id("rubber").toString(), RUBBER_SET));
        STRIPPED_RUBBER_LOG = ((BlockBuilder)GTRegistration.REGISTRATE.block("stripped_rubber_log", RotatedPillarBlock::new).initialProperties(() -> Blocks.f_50005_).lang("Stripped Rubber Log").blockstate((ctx, provider) -> provider.logBlock((RotatedPillarBlock)ctx.get())).tag(new TagKey[]{BlockTags.f_13105_, BlockTags.f_144280_}).item().tag(new TagKey[]{ItemTags.f_13181_, CustomTags.RUBBER_LOGS}).build()).register();
        RUBBER_WOOD = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_wood", RubberWoodBlock::new).initialProperties(() -> Blocks.f_50012_).lang("Rubber Wood").blockstate((ctx, provider) -> provider.axisBlock((RotatedPillarBlock)ctx.get(), provider.blockTexture((Block)RUBBER_LOG.get()), provider.blockTexture((Block)RUBBER_LOG.get()))).tag(new TagKey[]{BlockTags.f_13105_, BlockTags.f_144280_}).item().tag(new TagKey[]{ItemTags.f_13181_, CustomTags.RUBBER_LOGS}).build()).register();
        STRIPPED_RUBBER_WOOD = ((BlockBuilder)GTRegistration.REGISTRATE.block("stripped_rubber_wood", RotatedPillarBlock::new).initialProperties(() -> Blocks.f_50045_).lang("Stripped Rubber Wood").blockstate((ctx, provider) -> provider.axisBlock((RotatedPillarBlock)ctx.get(), provider.blockTexture((Block)ctx.get()), provider.blockTexture((Block)ctx.get()))).tag(new TagKey[]{BlockTags.f_13105_, BlockTags.f_144280_}).item().tag(new TagKey[]{ItemTags.f_13181_, CustomTags.RUBBER_LOGS}).build()).register();
        RUBBER_PLANK = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_planks", Block::new).initialProperties(() -> Blocks.f_50741_).lang("Rubber Planks").tag(new TagKey[]{BlockTags.f_13090_, BlockTags.f_144280_}).item().tag(new TagKey[]{ItemTags.f_13168_}).build()).register();
        RUBBER_SLAB = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50399_).lang("Rubber Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)RUBBER_PLANK.get()), prov.blockTexture((Block)RUBBER_PLANK.get()))).tag(new TagKey[]{BlockTags.f_13097_, BlockTags.f_144280_}).item().tag(new TagKey[]{ItemTags.f_13175_}).build()).register();
        RUBBER_FENCE = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_fence", FenceBlock::new).initialProperties(() -> Blocks.f_50479_).lang("Rubber Fence").blockstate((ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.getEntry(), prov.blockTexture((Block)RUBBER_PLANK.get()))).tag(new TagKey[]{BlockTags.f_13098_, BlockTags.f_144280_}).item().model((ctx, prov) -> prov.fenceInventory(ctx.getName(), RUBBER_PLANK.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13176_}).build()).register();
        RUBBER_SIGN = ((BlockBuilder)((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_sign", p -> new GTStandingSignBlock((BlockBehaviour.Properties)p, RUBBER_TYPE)).initialProperties(() -> Blocks.f_50149_).lang("Rubber Sign").blockstate((ctx, prov) -> prov.signBlock((StandingSignBlock)ctx.get(), (WallSignBlock)RUBBER_WALL_SIGN.get(), prov.blockTexture((Block)RUBBER_PLANK.get()))).tag(new TagKey[]{BlockTags.f_13066_, BlockTags.f_144280_}).setData(ProviderType.LANG, NonNullBiConsumer.noop())).item((b, p) -> new SignItem(p, (Block)b, (Block)RUBBER_WALL_SIGN.get())).defaultModel().tag(new TagKey[]{ItemTags.f_13157_}).build()).register();
        RUBBER_WALL_SIGN = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_wall_sign", p -> new GTWallSignBlock((BlockBehaviour.Properties)p, RUBBER_TYPE)).initialProperties(() -> Blocks.f_50159_).lang("Rubber Wall Sign").setData(ProviderType.BLOCKSTATE, NonNullBiConsumer.noop())).tag(new TagKey[]{BlockTags.f_13067_, BlockTags.f_144280_}).loot((table, block) -> table.m_246125_((Block)block, (ItemLike)RUBBER_SIGN.m_5456_())).register();
        RUBBER_HANGING_SIGN = ((BlockBuilder)((ItemBuilder)((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_hanging_sign", p -> new GTCeilingHangingSignBlock((BlockBehaviour.Properties)p, RUBBER_TYPE)).initialProperties(() -> Blocks.f_244633_).lang("Rubber Hanging Sign").blockstate((ctx, prov) -> {
            ModelBuilder model = prov.models().sign(ctx.getName(), prov.blockTexture((Block)RUBBER_PLANK.get()));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).tag(new TagKey[]{BlockTags.f_243838_, BlockTags.f_144280_}).setData(ProviderType.LANG, NonNullBiConsumer.noop())).item((b, p) -> new HangingSignItem((Block)b, (Block)RUBBER_WALL_HANGING_SIGN.get(), p)).defaultModel().tag(new TagKey[]{ItemTags.f_244389_}).setData(ProviderType.LANG, NonNullBiConsumer.noop())).build()).register();
        RUBBER_WALL_HANGING_SIGN = GTRegistration.REGISTRATE.block("rubber_wall_hanging_sign", p -> new GTWallHangingSignBlock((BlockBehaviour.Properties)p, RUBBER_TYPE)).initialProperties(() -> Blocks.f_243895_).lang("Rubber Wall Hanging Sign").blockstate((ctx, prov) -> {
            ModelBuilder model = prov.models().sign(ctx.getName(), prov.blockTexture((Block)RUBBER_PLANK.get()));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).tag(new TagKey[]{BlockTags.f_244544_, BlockTags.f_144280_}).loot((table, block) -> table.m_246125_((Block)block, (ItemLike)RUBBER_HANGING_SIGN.m_5456_())).register();
        RUBBER_PRESSURE_PLATE = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_pressure_plate", p -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, p, RUBBER_SET)).initialProperties(() -> Blocks.f_50168_).lang("Rubber Pressure Plate").tag(new TagKey[]{BlockTags.f_13100_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.pressurePlateBlock((PressurePlateBlock)ctx.getEntry(), prov.blockTexture((Block)RUBBER_PLANK.get()))).item().tag(new TagKey[]{ItemTags.f_13177_}).build()).register();
        RUBBER_TRAPDOOR = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_trapdoor", p -> new TrapDoorBlock(p, RUBBER_SET)).initialProperties(() -> Blocks.f_50217_).lang("Rubber Trapdoor").blockstate((ctx, prov) -> prov.trapdoorBlock((TrapDoorBlock)ctx.get(), prov.blockTexture((Block)ctx.get()), true)).tag(new TagKey[]{BlockTags.f_13102_, BlockTags.f_144280_}).item().model((ctx, prov) -> prov.trapdoorOrientableBottom(ctx.getName(), ctx.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13178_}).build()).register();
        RUBBER_STAIRS = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_stairs", p -> new StairBlock(() -> RUBBER_PLANK.getDefaultState(), p)).initialProperties(() -> Blocks.f_50269_).lang("Rubber Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)RUBBER_PLANK.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        RUBBER_BUTTON = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_button", p -> new ButtonBlock(p, RUBBER_SET, 30, true)).initialProperties(() -> Blocks.f_50252_).lang("Rubber Button").tag(new TagKey[]{BlockTags.f_13092_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.getEntry(), prov.blockTexture((Block)RUBBER_PLANK.get()))).item().model((ctx, prov) -> prov.buttonInventory(ctx.getName(), RUBBER_PLANK.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13170_}).build()).register();
        RUBBER_FENCE_GATE = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_fence_gate", p -> new FenceGateBlock(p, RUBBER_TYPE)).initialProperties(() -> Blocks.f_50474_).lang("Rubber Fence Gate").tag(new TagKey[]{BlockTags.f_13055_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.fenceGateBlock((FenceGateBlock)ctx.getEntry(), prov.blockTexture((Block)RUBBER_PLANK.get()))).item().tag(new TagKey[]{ItemTags.f_254662_}).build()).register();
        RUBBER_DOOR = ((BlockBuilder)GTRegistration.REGISTRATE.block("rubber_door", p -> new DoorBlock(p, RUBBER_SET)).initialProperties(() -> Blocks.f_50484_).lang("Rubber Door").loot((table, block) -> table.m_247577_((Block)block, table.m_247398_((Block)block))).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.getEntry(), GTCEu.id("block/rubber_door_bottom"), GTCEu.id("block/rubber_door_top"))).tag(new TagKey[]{BlockTags.f_13095_, BlockTags.f_144280_}).item().model((ctx, prov) -> prov.generated((NonNullSupplier)ctx)).tag(new TagKey[]{ItemTags.f_13173_}).build()).register();
        TREATED_WOOD_SET = BlockSetType.m_272115_((BlockSetType)new BlockSetType(GTCEu.id("treated_wood").toString()));
        TREATED_WOOD_TYPE = WoodType.m_61844_((WoodType)new WoodType(GTCEu.id("treated_wood").toString(), TREATED_WOOD_SET));
        TREATED_WOOD_PLANK = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_planks", Block::new).initialProperties(() -> Blocks.f_50705_).lang("Treated Wood Planks").properties(p -> p.m_284180_(MapColor.f_283861_)).tag(new TagKey[]{TagUtil.createBlockTag("treated_wood")}).tag(new TagKey[]{BlockTags.f_144280_}).item().tag(new TagKey[]{TagUtil.createItemTag("treated_wood")}).build()).register();
        TREATED_WOOD_SLAB = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_slab", SlabBlock::new).initialProperties(() -> Blocks.f_50399_).lang("Treated Wood Slab").blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()))).tag(new TagKey[]{BlockTags.f_13097_, BlockTags.f_144280_}).item().tag(new TagKey[]{ItemTags.f_13175_}).build()).register();
        TREATED_WOOD_FENCE = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_fence", FenceBlock::new).initialProperties(() -> Blocks.f_50479_).lang("Treated Wood Fence").blockstate((ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.getEntry(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()))).tag(new TagKey[]{BlockTags.f_13098_, BlockTags.f_144280_}).item().model((ctx, prov) -> prov.fenceInventory(ctx.getName(), TREATED_WOOD_PLANK.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13176_}).build()).register();
        TREATED_WOOD_SIGN = ((BlockBuilder)((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_sign", p -> new GTStandingSignBlock((BlockBehaviour.Properties)p, TREATED_WOOD_TYPE)).initialProperties(() -> Blocks.f_50149_).lang("Treated Wood Sign").blockstate((ctx, prov) -> prov.signBlock((StandingSignBlock)ctx.get(), (WallSignBlock)TREATED_WOOD_WALL_SIGN.get(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()))).tag(new TagKey[]{BlockTags.f_13066_, BlockTags.f_144280_}).setData(ProviderType.LANG, NonNullBiConsumer.noop())).item((b, p) -> new SignItem(p, (Block)b, (Block)TREATED_WOOD_WALL_SIGN.get())).defaultModel().tag(new TagKey[]{ItemTags.f_13157_}).build()).register();
        TREATED_WOOD_WALL_SIGN = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_wall_sign", p -> new GTWallSignBlock((BlockBehaviour.Properties)p, TREATED_WOOD_TYPE)).initialProperties(() -> Blocks.f_50159_).lang("Treated Wood Wall Sign").setData(ProviderType.BLOCKSTATE, NonNullBiConsumer.noop())).tag(new TagKey[]{BlockTags.f_13067_, BlockTags.f_144280_}).loot((table, block) -> table.m_246125_((Block)block, (ItemLike)TREATED_WOOD_SIGN.m_5456_())).register();
        TREATED_WOOD_HANGING_SIGN = ((BlockBuilder)((ItemBuilder)((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_hanging_sign", p -> new GTCeilingHangingSignBlock((BlockBehaviour.Properties)p, TREATED_WOOD_TYPE)).initialProperties(() -> Blocks.f_244633_).lang("Treated Wood Hanging Sign").blockstate((ctx, prov) -> {
            ModelBuilder model = prov.models().sign(ctx.getName(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).tag(new TagKey[]{BlockTags.f_243838_, BlockTags.f_144280_}).setData(ProviderType.LANG, NonNullBiConsumer.noop())).item((b, p) -> new HangingSignItem((Block)b, (Block)TREATED_WOOD_WALL_HANGING_SIGN.get(), p)).defaultModel().tag(new TagKey[]{ItemTags.f_244389_}).setData(ProviderType.LANG, NonNullBiConsumer.noop())).build()).register();
        TREATED_WOOD_WALL_HANGING_SIGN = GTRegistration.REGISTRATE.block("treated_wood_wall_hanging_sign", p -> new GTWallHangingSignBlock((BlockBehaviour.Properties)p, TREATED_WOOD_TYPE)).initialProperties(() -> Blocks.f_243895_).lang("Treated Wood Wall Hanging Sign").blockstate((ctx, prov) -> {
            ModelBuilder model = prov.models().sign(ctx.getName(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).tag(new TagKey[]{BlockTags.f_244544_, BlockTags.f_144280_}).loot((table, block) -> table.m_246125_((Block)block, (ItemLike)TREATED_WOOD_HANGING_SIGN.m_5456_())).register();
        TREATED_WOOD_PRESSURE_PLATE = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_pressure_plate", p -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, p, TREATED_WOOD_SET)).initialProperties(() -> Blocks.f_50168_).lang("Treated Wood Pressure Plate").tag(new TagKey[]{BlockTags.f_13100_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.pressurePlateBlock((PressurePlateBlock)ctx.getEntry(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()))).item().tag(new TagKey[]{ItemTags.f_13177_}).build()).register();
        TREATED_WOOD_TRAPDOOR = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_trapdoor", p -> new TrapDoorBlock(p, RUBBER_SET)).initialProperties(() -> Blocks.f_50217_).lang("Treated Wood Trapdoor").blockstate((ctx, prov) -> prov.trapdoorBlock((TrapDoorBlock)ctx.get(), prov.blockTexture((Block)ctx.get()), true)).tag(new TagKey[]{BlockTags.f_13102_, BlockTags.f_144280_}).item().model((ctx, prov) -> prov.trapdoorOrientableBottom(ctx.getName(), ctx.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13178_}).build()).register();
        TREATED_WOOD_STAIRS = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_stairs", p -> new StairBlock(() -> TREATED_WOOD_PLANK.getDefaultState(), p)).initialProperties(() -> Blocks.f_50269_).lang("Treated Wood Stairs").tag(new TagKey[]{BlockTags.f_13030_, BlockTags.f_144280_}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.getEntry(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()))).item().tag(new TagKey[]{ItemTags.f_13138_}).build()).register();
        TREATED_WOOD_BUTTON = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_button", p -> new ButtonBlock(p, TREATED_WOOD_SET, 30, true)).initialProperties(() -> Blocks.f_50252_).lang("Treated Wood Button").tag(new TagKey[]{BlockTags.f_13092_}).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.getEntry(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()))).item().model((ctx, prov) -> prov.buttonInventory(ctx.getName(), TREATED_WOOD_PLANK.getId().m_246208_("block/"))).tag(new TagKey[]{ItemTags.f_13170_}).build()).register();
        TREATED_WOOD_FENCE_GATE = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_fence_gate", p -> new FenceGateBlock(p, TREATED_WOOD_TYPE)).initialProperties(() -> Blocks.f_50474_).lang("Treated Wood Fence Gate").tag(new TagKey[]{BlockTags.f_13055_}).blockstate((ctx, prov) -> prov.fenceGateBlock((FenceGateBlock)ctx.getEntry(), prov.blockTexture((Block)TREATED_WOOD_PLANK.get()))).item().tag(new TagKey[]{ItemTags.f_254662_}).build()).register();
        TREATED_WOOD_DOOR = ((BlockBuilder)GTRegistration.REGISTRATE.block("treated_wood_door", p -> new DoorBlock(p, TREATED_WOOD_SET)).initialProperties(() -> Blocks.f_50484_).lang("Treated Wood Door").loot((table, block) -> table.m_247577_((Block)block, table.m_247398_((Block)block))).addLayer(() -> RenderType::m_110463_).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.getEntry(), GTCEu.id("block/treated_wood_door_bottom"), GTCEu.id("block/treated_wood_door_top"))).tag(new TagKey[]{BlockTags.f_13095_}).item().model((ctx, prov) -> prov.generated((NonNullSupplier)ctx)).tag(new TagKey[]{ItemTags.f_13173_}).build()).register();
        ACID_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("acid_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_acidhazard"));
        ANTIMATTER_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("antimatter_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_antimatterhazard"));
        BIO_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("bio_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_biohazard"));
        BOSS_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("boss_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_bosshazard"));
        CAUSALITY_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("causality_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_causalityhazard"));
        EXPLOSION_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("explosion_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_explosionhazard"));
        FIRE_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("fire_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_firehazard"));
        FROST_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("frost_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_frosthazard"));
        GENERIC_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("generic_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_generichazard"));
        GREGIFICATION_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("gregification_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_gregificationhazard"));
        HIGH_PRESSURE_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("high_pressure_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_highpressurehazard"));
        HIGH_VOLTAGE_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("high_voltage_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_highvoltagehazard"));
        HIGH_TEMPERATURE_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("high_temperature_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_hightemperaturehazard"));
        LASER_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("laser_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_laserhazard"));
        MAGIC_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("magic_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_magichazard"));
        MAGNETIC_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("magnetic_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_magneticfieldhazard"));
        MOB_INFESTATION_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("mob_infestation_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_mobhazard"));
        MOB_SPAWNER_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("mob_spawner_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_mobspawnhazard"));
        NOISE_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("noise_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_noisehazard"));
        RADIOACTIVE_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("radioactive_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_radioactivehazard"));
        SPATIAL_STORAGE_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("spatial_storage_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_spatialhazard"));
        TURRET_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("turret_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_turrethazard"));
        VOID_HAZARD_SIGN_BLOCK = GTBlocks.createCasingBlock("void_hazard_sign_block", GTCEu.id("block/casings/signs/machine_casing_voidhazard"));
        YELLOW_STRIPES_BLOCK_A = GTBlocks.createCasingBlock("yellow_stripes_block_a", GTCEu.id("block/casings/signs/machine_casing_stripes_a"));
        YELLOW_STRIPES_BLOCK_B = GTBlocks.createCasingBlock("yellow_stripes_block_b", GTCEu.id("block/casings/signs/machine_casing_stripes_b"));
        COBBLE_BLOCKS = new HashMap<TagPrefix, Supplier<BlockState>>();
        BRITTLE_CHARCOAL = ((BlockBuilder)GTRegistration.REGISTRATE.block("brittle_charcoal", Block::new).properties(p -> p.m_60978_(0.5f).m_155956_(8.0f).m_60918_(SoundType.f_56742_)).loot((table, block) -> table.m_247577_(block, table.m_245765_((ItemLike)Items.f_42414_, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).lang("Brittle Charcoal").exBlockstate(GTModels.cubeAllModel(GTCEu.id("block/misc/brittle_charcoal"))).tag(new TagKey[]{BlockTags.f_144283_}).item((b, p) -> new BlockItem((Block)b, (Item.Properties)p){

            public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
                super.m_7373_(stack, level, tooltipComponents, isAdvanced);
                tooltipComponents.add(1, (Component)Component.m_237115_((String)"tile.gtceu.brittle_charcoal.tooltip.0"));
                tooltipComponents.add(2, (Component)Component.m_237115_((String)"tile.gtceu.brittle_charcoal.tooltip.1"));
            }
        }).build()).register();
        FOAM = GTRegistration.REGISTRATE.block("foam", p -> new FoamBlock((BlockBehaviour.Properties)p, false)).properties(p -> p.m_60913_(0.5f, 0.3f).m_60977_().m_60918_(SoundType.f_56747_).m_278166_(PushReaction.DESTROY).m_60955_().m_60910_().m_222994_()).simpleItem().register();
        REINFORCED_FOAM = GTRegistration.REGISTRATE.block("reinforced_foam", p -> new FoamBlock((BlockBehaviour.Properties)p, true)).initialProperties((NonNullSupplier)FOAM).simpleItem().register();
        PETRIFIED_FOAM = GTRegistration.REGISTRATE.block("petrified_foam", Block::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(1.0f, 4.0f).m_60918_(SoundType.f_56747_)).tag(new TagKey[]{BlockTags.f_144282_, BlockTags.f_144286_}).simpleItem().register();
        REINFORCED_STONE = GTRegistration.REGISTRATE.block("reinforced_stone", Block::new).initialProperties(() -> Blocks.f_50069_).properties(p -> p.m_60913_(4.0f, 16.0f)).tag(new TagKey[]{BlockTags.f_144282_, BlockTags.f_144285_}).simpleItem().register();
        ImmutableMap.Builder lampBuilder = new ImmutableMap.Builder();
        for (DyeColor dyeColor : colors = DyeColor.values()) {
            lampBuilder.put((Object)dyeColor, (Object)((BlockBuilder)GTRegistration.REGISTRATE.block("%s_lamp".formatted(dyeColor.m_41065_()), p -> new LampBlock((BlockBehaviour.Properties)p, dyeColor, true)).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60913_(0.3f, 8.0f).m_60918_(SoundType.f_56744_)).addLayer(() -> RenderType::m_110463_).blockstate((NonNullBiConsumer)GTModels.lampModel(dyeColor, true)).item(LampBlockItem::new).build()).register());
        }
        LAMPS = lampBuilder.build();
        DyeColor[] borderlessLampBuilder = new ImmutableMap.Builder();
        DyeColor[] dyeColorArray = colors;
        int n = dyeColorArray.length;
        for (int dyeColor = 0; dyeColor < n; ++dyeColor) {
            DyeColor dyeColor2 = dyeColorArray[dyeColor];
            borderlessLampBuilder.put((Object)dyeColor2, (Object)((BlockBuilder)GTRegistration.REGISTRATE.block("%s_borderless_lamp".formatted(dyeColor2.m_41065_()), p -> new LampBlock((BlockBehaviour.Properties)p, dyeColor2, false)).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60913_(0.3f, 8.0f).m_60918_(SoundType.f_56744_)).blockstate((NonNullBiConsumer)GTModels.lampModel(dyeColor2, false)).item(LampBlockItem::new).build()).register());
        }
        BORDERLESS_LAMPS = borderlessLampBuilder.build();
        DyeColor[] colors2 = DyeColor.values();
        ImmutableMap.Builder metalsheetBuilder = new ImmutableMap.Builder();
        for (DyeColor dyeColor : colors2) {
            metalsheetBuilder.put((Object)dyeColor, (Object)GTRegistration.REGISTRATE.block("%s_metal_sheet".formatted(dyeColor.m_41065_()), Block::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60913_(2.0f, 5.0f).m_284268_(dyeColor)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), GTCEu.id("block/decoration/metalsheet_%s".formatted(dyeColor.m_41065_()))))).simpleItem().register());
        }
        METAL_SHEETS = metalsheetBuilder.build();
        ImmutableMap.Builder largeMetalsheetBuilder = new ImmutableMap.Builder();
        for (DyeColor dyeColor2 : colors2) {
            largeMetalsheetBuilder.put((Object)dyeColor2, (Object)GTRegistration.REGISTRATE.block("%s_large_metal_sheet".formatted(dyeColor2.m_41065_()), Block::new).initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60913_(2.0f, 5.0f).m_284268_(dyeColor2)).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), GTCEu.id("block/decoration/large_metalsheet_%s".formatted(dyeColor2.m_41065_()))))).simpleItem().register());
        }
        LARGE_METAL_SHEETS = largeMetalsheetBuilder.build();
        ImmutableMap.Builder studsBuilder = new ImmutableMap.Builder();
        for (DyeColor dyeColor : colors2) {
            studsBuilder.put((Object)dyeColor, (Object)GTRegistration.REGISTRATE.block("%s_studs".formatted(dyeColor.m_41065_()), Block::new).initialProperties(() -> Blocks.f_50041_).properties(p -> p.m_60913_(1.5f, 2.5f).m_284268_(dyeColor)).tag(new TagKey[]{BlockTags.f_144282_, CustomTags.NEEDS_WOOD_TOOL}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), GTCEu.id("block/decoration/studs_%s".formatted(dyeColor.m_41065_()))))).simpleItem().register());
        }
        STUDS = studsBuilder.build();
    }
}

