/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.StoneTypeEntry;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class StoneMachineRecipes {
    private static List<StoneTypeEntry> DEFAULT_ENTRIES;

    public static void init(Consumer<FinishedRecipe> provider) {
        StoneMachineRecipes.registerStoneRecipes(provider);
    }

    private static List<StoneTypeEntry> getDefaultEntries() {
        if (DEFAULT_ENTRIES == null) {
            String mcModID = "minecraft";
            DEFAULT_ENTRIES = Arrays.asList(new StoneTypeEntry.Builder("minecraft", "stone").stone(Items.f_41905_).crackedStone(Items.f_42594_).polishedStone(Items.f_42018_).slab(Items.f_41922_).stair(Items.f_42371_).button(Items.f_42083_).pressurePlate(Items.f_41967_).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "smooth_stone").stone(Items.f_41994_).slab(Items.f_41923_).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "stone_brick").stone(Items.f_42018_).crackedStone(Items.f_42020_).chiselStone(Items.f_42021_).slab(Items.f_41929_).stair(Items.f_42092_).wall(Items.f_42073_).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "andesite").stone(Items.f_42170_).polishedStone(Items.f_42223_).slab(Items.f_42336_).stair(Items.f_42375_).wall(Items.f_42075_).material(GTMaterials.Andesite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_andesite").stone(Items.f_42223_).slab(Items.f_42338_).stair(Items.f_42377_).material(GTMaterials.Andesite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "granite").stone(Items.f_41958_).polishedStone(Items.f_42011_).slab(Items.f_42335_).stair(Items.f_42374_).wall(Items.f_42072_).material(GTMaterials.Granite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_granite").stone(Items.f_42011_).slab(Items.f_42379_).stair(Items.f_42365_).material(GTMaterials.Granite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "diorite").stone(Items.f_42064_).polishedStone(Items.f_42117_).slab(Items.f_42339_).stair(Items.f_42378_).wall(Items.f_42079_).material(GTMaterials.Diorite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_diorite").stone(Items.f_42117_).slab(Items.f_42330_).stair(Items.f_42368_).material(GTMaterials.Diorite).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "sandstone").stone(Items.f_41856_).polishedStone(Items.f_41858_).chiselStone(Items.f_41857_).slab(Items.f_41924_).stair(Items.f_42106_).wall(Items.f_42077_).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "smooth_sandstone").stone(Items.f_41993_).slab(Items.f_42333_).stair(Items.f_42372_).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "cut_sandstone").stone(Items.f_41858_).slab(Items.f_41925_).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "red_sandstone").stone(Items.f_42252_).polishedStone(Items.f_42254_).chiselStone(Items.f_42253_).slab(Items.f_41985_).stair(Items.f_42255_).wall(Items.f_42070_).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "smooth_red_sandstone").stone(Items.f_41992_).slab(Items.f_42380_).stair(Items.f_42366_).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "cut_red_sandstone").stone(Items.f_42254_).slab(Items.f_41986_).material(GTMaterials.QuartzSand).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "cobblestone").stone(Items.f_42594_).slab(Items.f_41927_).stair(Items.f_41965_).wall(Items.f_42066_).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "mossy_cobblestone").stone(Items.f_41998_).slab(Items.f_42331_).stair(Items.f_42369_).wall(Items.f_42067_).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "mossy_stone_brick").stone(Items.f_42019_).slab(Items.f_42381_).stair(Items.f_42367_).wall(Items.f_42071_).material(GTMaterials.Stone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "blackstone").stone(Items.f_42755_).polishedStone(Items.f_42759_).slab(Items.f_42756_).stair(Items.f_42757_).wall(Items.f_42080_).material(GTMaterials.Blackstone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_blackstone").stone(Items.f_42759_).polishedStone(Items.f_42763_).chiselStone(Items.f_42762_).crackedStone(Items.f_42766_).slab(Items.f_42760_).stair(Items.f_42761_).wall(Items.f_42081_).pressurePlate(Items.f_41976_).button(Items.f_42145_).material(GTMaterials.Blackstone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_blackstone_brick").stone(Items.f_42763_).slab(Items.f_42764_).stair(Items.f_42765_).wall(Items.f_42082_).material(GTMaterials.Blackstone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "brick").stone(Items.f_41995_).slab(Items.f_41928_).stair(Items.f_42091_).wall(Items.f_42068_).material(GTMaterials.Brick, 14515200L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "mud_brick").stone(Items.f_220186_).slab(Items.f_220184_).stair(Items.f_220191_).wall(Items.f_220190_).material(GTMaterials.Clay).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "nether_bricks").stone(Items.f_42095_).crackedStone(Items.f_42096_).chiselStone(Items.f_42097_).slab(Items.f_41930_).stair(Items.f_42099_).wall(Items.f_42074_).material(GTMaterials.Netherrack, 14515200L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "red_nether_brick").stone(Items.f_42261_).slab(Items.f_42337_).stair(Items.f_42376_).wall(Items.f_42076_).material(GTMaterials.Netherrack).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "quartz").stone(Items.f_42157_).polishedStone(Items.f_42158_).chiselStone(Items.f_42156_).stair(Items.f_42160_).material(GTMaterials.NetherQuartz, 14515200L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "smooth_quartz").stone(Items.f_41991_).slab(Items.f_42334_).stair(Items.f_42373_).material(GTMaterials.NetherQuartz, 14515200L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "cut_copper").stone(Items.f_151004_).slab(Items.f_150973_).stair(Items.f_151008_).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "exposed_cut_copper").stone(Items.f_151005_).slab(Items.f_150974_).stair(Items.f_150970_).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "oxidized_cut_copper").stone(Items.f_151007_).slab(Items.f_150976_).stair(Items.f_150972_).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "weathered_cut_copper").stone(Items.f_151006_).slab(Items.f_150975_).stair(Items.f_150971_).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "waxed_cut_copper").stone(Items.f_150981_).slab(Items.f_150989_).stair(Items.f_150985_).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "waxed_exposed_cut_copper").stone(Items.f_150982_).slab(Items.f_150990_).stair(Items.f_150986_).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "waxed_oxidized_cut_copper").stone(Items.f_150984_).slab(Items.f_150992_).stair(Items.f_150988_).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "waxed_weathered_cut_copper").stone(Items.f_150983_).slab(Items.f_150991_).stair(Items.f_150987_).material(GTMaterials.Copper, 8164800L).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "purpur").stone(Items.f_42004_).chiselStone(Items.f_42005_).slab(Items.f_41987_).stair(Items.f_42006_).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "end_stone").stone(Items.f_42102_).polishedStone(Items.f_42103_).slab(Items.f_42332_).stair(Items.f_42370_).wall(Items.f_42078_).material(GTMaterials.Endstone).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "prismarine").stone(Items.f_42192_).slab(Items.f_41988_).stair(Items.f_42195_).wall(Items.f_42069_).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "dark_prismarine").stone(Items.f_42194_).slab(Items.f_41990_).stair(Items.f_42250_).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "prismarine_brick").stone(Items.f_42193_).slab(Items.f_41989_).stair(Items.f_42196_).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "bamboo_mosaic").stone(Items.f_243813_).slab(Items.f_244160_).stair(Items.f_243828_).material(GTMaterials.Wood).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "deepslate").stone(Items.f_151034_).crackedStone(Items.f_151035_).build(), new StoneTypeEntry.Builder("minecraft", "cobbled_deepslate").stone(Items.f_151035_).polishedStone(Items.f_151040_).chiselStone(Items.f_151024_).slab(Items.f_151043_).stair(Items.f_151036_).wall(Items.f_151028_).material(GTMaterials.Deepslate).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "polished_deepslate").stone(Items.f_151040_).polishedStone(Items.f_151020_).slab(Items.f_151044_).stair(Items.f_151037_).wall(Items.f_151029_).material(GTMaterials.Deepslate).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "deepslate_bricks").stone(Items.f_151020_).polishedStone(Items.f_151022_).crackedStone(Items.f_151021_).slab(Items.f_151045_).stair(Items.f_151038_).wall(Items.f_151030_).material(GTMaterials.Deepslate).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "deepslate_tile").stone(Items.f_151022_).crackedStone(Items.f_151023_).slab(Items.f_151046_).stair(Items.f_151039_).wall(Items.f_151031_).material(GTMaterials.Deepslate).registerAllMaterialInfo().build(), new StoneTypeEntry.Builder("minecraft", "basalt").stone(Items.f_42051_).polishedStone(Items.f_42052_).material(GTMaterials.Basalt).registerAllMaterialInfo().build());
            return DEFAULT_ENTRIES;
        }
        return DEFAULT_ENTRIES;
    }

    public static void registerMaterialInfo() {
        for (StoneTypeEntry entry : StoneMachineRecipes.getDefaultEntries()) {
            StoneMachineRecipes.registerStoneMaterialInfo(entry);
        }
    }

    public static void registerStoneMaterialInfo(@NotNull StoneTypeEntry entry) {
        if (!entry.material.isNull() && entry.stone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.stone, TagPrefix.block, entry.material);
            }
            if (entry.addStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.stone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.polishedStone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.polishedStone, TagPrefix.block, entry.material);
            }
            if (entry.addPolishedStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.polishedStone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.smeltStone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.smeltStone, TagPrefix.block, entry.material);
            }
            if (entry.addSmeltStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.smeltStone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.chiselStone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.chiselStone, TagPrefix.block, entry.material);
            }
            if (entry.addChiselStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.chiselStone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.crackedStone != null) {
            if (entry.addStoneOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.crackedStone, TagPrefix.block, entry.material);
            }
            if (entry.addCrackedStoneMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.crackedStone, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.slab != null) {
            if (entry.addSlabOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.slab, TagPrefix.slab, entry.material);
            }
            if (entry.addSlabMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.slab, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount / 2L)));
            }
        }
        if (!entry.material.isNull() && entry.stair != null) {
            if (entry.addStairOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.stair, TagPrefix.stairs, entry.material);
            }
            if (entry.addStairMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.stair, new ItemMaterialInfo(new MaterialStack(entry.material, 3L * entry.materialAmount / 4L)));
            }
        }
        if (!entry.material.isNull() && entry.wall != null) {
            if (entry.addWallOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.wall, TagPrefix.fence, entry.material);
            }
            if (entry.addWallMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.wall, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount)));
            }
        }
        if (!entry.material.isNull() && entry.pressurePlate != null && entry.addPressurePlateMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.pressurePlate, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount / 4L)));
        }
        if (!entry.material.isNull() && entry.button != null && entry.addButtonMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.button, new ItemMaterialInfo(new MaterialStack(entry.material, entry.materialAmount / 6L)));
        }
    }

    private static void registerStoneRecipes(Consumer<FinishedRecipe> provider) {
        for (StoneTypeEntry entry : StoneMachineRecipes.getDefaultEntries()) {
            StoneMachineRecipes.registerStoneTypeRecipes(provider, entry);
        }
    }

    public static void registerStoneTypeRecipes(Consumer<FinishedRecipe> provider, @NotNull StoneTypeEntry entry) {
        if (entry.stone == null) {
            GTCEu.LOGGER.error("Could not find stone form of StoneTypeEntry, id: {}", (Object)entry.stoneName);
            return;
        }
        if (entry.polishedStone != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_polish_hammer", new ItemStack((ItemLike)entry.polishedStone, 4), "hSS", " SS", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + entry.stoneName + "_into_polished").inputItems(entry.stone).circuitMeta(4).outputItems(entry.polishedStone).duration(80).EUt(1L).save(provider);
        }
        if (entry.crackedStone != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_hammer", new ItemStack((ItemLike)entry.crackedStone), "h", "S", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + entry.stoneName + "_into_cracked").inputItems(entry.stone).outputItems(entry.crackedStone).duration(12).EUt(4L).save(provider);
        }
        if (entry.smeltStone != null) {
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + entry.stoneName + "_into_" + String.valueOf(entry.smeltStone), entry.stone, entry.smeltStone, 0.1f);
        }
        if (entry.slab != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_slab_saw", new ItemStack((ItemLike)entry.slab), "sS", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + entry.stoneName + "_into_slab").inputItems(entry.stone).outputItems(entry.slab, 2).duration(40).EUt(8L).addMaterialInfo(true).save(provider);
            if (entry.chiselStone != null) {
                if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                    VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_polished_hammer", new ItemStack((ItemLike)entry.chiselStone), "mSd", " S ", Character.valueOf('S'), entry.slab);
                }
                GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("form_" + entry.stoneName + "_slab_into_pillar").inputItems(entry.slab, 2).outputItems(entry.chiselStone).duration(80).EUt(8L).save(provider);
            }
        }
        if (entry.pressurePlate != null) {
            if (ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes && entry.slab != null) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_pressure_plate", new ItemStack((ItemLike)entry.pressurePlate, 2), "ShS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), entry.slab, Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron));
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(entry.stoneName + "_pressure_plate").inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(entry.stone, 2).outputItems(entry.pressurePlate, 2).duration(100).EUt(GTValues.VA[0]).save(provider);
            } else if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                // empty if block
            }
        }
        if (entry.button != null) {
            if (ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes && entry.pressurePlate != null) {
                VanillaRecipeHelper.addShapedRecipe(provider, "stone_button", new ItemStack((ItemLike)entry.button, 6), "sP", Character.valueOf('P'), entry.pressurePlate);
            }
            if (entry.pressurePlate != null) {
                GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + entry.stoneName + "slab_into_button").inputItems(entry.pressurePlate).outputItems(entry.button, 3).duration(60).EUt(8L).save(provider);
            } else {
                GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("cut_" + entry.stoneName + "_into_button").inputItems(entry.stone).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_NUGGET).outputItems(entry.button, 6).duration(60).EUt(8L).save(provider);
            }
        }
        if (entry.stair != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_stair_saw", new ItemStack((ItemLike)entry.stair, 3), "Ss ", "SS ", "SSS", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + entry.stoneName + "_into_stair").inputItems(entry.stone, 3).circuitMeta(7).outputItems(entry.stair, 4).duration(80).EUt(8L).addMaterialInfo(true).save(provider);
        }
        if (entry.wall != null) {
            if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, entry.stoneName + "_wall_saw", new ItemStack((ItemLike)entry.wall, 2), "sS", " S", " S", Character.valueOf('S'), entry.stone);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + entry.stoneName + "_into_wall").inputItems(entry.stone).circuitMeta(13).outputItems(entry.wall).duration(100).EUt(8L).addMaterialInfo(true).save(provider);
        }
    }
}

