/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.emi.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.integration.emi.recipe.GTEmiRecipe;
import com.lowdragmc.lowdraglib.emi.IGui2Renderable;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class GTRecipeEMICategory
extends EmiRecipeCategory {
    public static final Function<GTRecipeCategory, GTRecipeEMICategory> CATEGORIES = Util.m_143827_(GTRecipeEMICategory::new);
    private final GTRecipeCategory category;
    public static Comparator<MachineDefinition> sortDefinition = (a, b) -> {
        boolean isAMulti = a instanceof MultiblockMachineDefinition;
        boolean isBMulti = b instanceof MultiblockMachineDefinition;
        if (isAMulti && !isBMulti) {
            return 1;
        }
        if (!isAMulti && isBMulti) {
            return -1;
        }
        return a.getTier() - b.getTier();
    };

    private GTRecipeEMICategory(GTRecipeCategory category) {
        super(category.registryKey, IGui2Renderable.toDrawable((IGuiTexture)category.getIcon(), (int)16, (int)16));
        this.category = category;
    }

    public static void registerDisplays(EmiRegistry registry) {
        EmiRecipeCategory emiCategory;
        GTRecipeType type;
        ArrayList<GTRecipeCategory> subCategories = new ArrayList<GTRecipeCategory>();
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            if (!category.shouldRegisterDisplays()) continue;
            type = category.getRecipeType();
            if (category != type.getCategory()) {
                subCategories.add(category);
                continue;
            }
            type.buildRepresentativeRecipes();
            emiCategory = CATEGORIES.apply(category);
            type.getRecipesInCategory(category).stream().map(recipe -> new GTEmiRecipe((GTRecipe)recipe, emiCategory)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        }
        for (GTRecipeCategory subCategory : subCategories) {
            if (!subCategory.shouldRegisterDisplays()) continue;
            type = subCategory.getRecipeType();
            emiCategory = CATEGORIES.apply(subCategory);
            type.getRecipesInCategory(subCategory).stream().map(recipe -> new GTEmiRecipe((GTRecipe)recipe, emiCategory)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        }
    }

    public static void registerWorkStations(EmiRegistry registry) {
        for (MachineDefinition machine : GTRegistries.MACHINES.values().stream().sorted(sortDefinition).toList()) {
            for (GTRecipeType type : machine.getRecipeTypes()) {
                for (GTRecipeCategory category : type.getCategories()) {
                    if (!category.isXEIVisible() && !GTCEu.isDev()) continue;
                    registry.addWorkstation(GTRecipeEMICategory.machineCategory(category), (EmiIngredient)EmiStack.of((ItemStack)machine.asStack()));
                }
            }
        }
    }

    public static EmiRecipeCategory machineCategory(GTRecipeCategory category) {
        if (category == GTRecipeTypes.FURNACE_RECIPES.getCategory()) {
            return VanillaEmiRecipeCategories.SMELTING;
        }
        return CATEGORIES.apply(category);
    }

    public Component getName() {
        return Component.m_237115_((String)this.category.getLanguageKey());
    }
}

