/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public abstract class BlockInfoProvider<C>
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public final ResourceLocation uid;

    protected BlockInfoProvider(ResourceLocation uid) {
        this.uid = uid;
    }

    @Nullable
    protected abstract C getCapability(Level var1, BlockPos var2);

    protected abstract void write(CompoundTag var1, C var2, BlockAccessor var3);

    protected abstract void addTooltip(CompoundTag var1, ITooltip var2, Player var3, BlockAccessor var4, BlockEntity var5, IPluginConfig var6);

    protected boolean allowDisplaying(C capability) {
        return true;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor block, IPluginConfig config) {
        BlockEntity be = block.getBlockEntity();
        if (be != null) {
            CompoundTag capData = block.getServerData().m_128469_(this.uid.toString());
            this.addTooltip(capData, tooltip, block.getPlayer(), block, be, config);
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        CompoundTag capData = data.m_128469_(this.uid.toString());
        C capability = this.getCapability(blockAccessor.getLevel(), blockAccessor.getPosition());
        if (capability != null && this.allowDisplaying(capability)) {
            this.write(capData, capability, blockAccessor);
        }
        data.m_128365_(this.uid.toString(), (Tag)capData);
    }

    @Generated
    public ResourceLocation getUid() {
        return this.uid;
    }
}

