/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe.components;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.InputReplacement;
import dev.latvian.mods.kubejs.recipe.OutputReplacement;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import java.util.HashMap;
import java.util.Map;

public record JavaMapRecipeComponent<K, V>(RecipeComponent<K> key, RecipeComponent<V> component) implements RecipeComponent<Map<K, V>>
{
    public String componentType() {
        return "map";
    }

    public TypeDescJS constructorDescription(DescriptionContext ctx) {
        return this.component.constructorDescription(ctx).asMap(this.key.constructorDescription(ctx));
    }

    public ComponentRole role() {
        return this.component.role();
    }

    public Class<?> componentClass() {
        return Map.class;
    }

    public JsonObject write(RecipeJS recipe, Map<K, V> value) {
        JsonObject json = new JsonObject();
        for (Map.Entry<K, V> entry : value.entrySet()) {
            json.add(this.key.write(recipe, entry.getKey()).getAsString(), this.component.write(recipe, entry.getValue()));
        }
        return json;
    }

    public Map<K, V> read(RecipeJS recipe, Object from) {
        if (from instanceof Map) {
            Map map = (Map)from;
            return map;
        }
        if (from instanceof JsonObject) {
            JsonObject o = (JsonObject)from;
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            boolean i = false;
            for (Map.Entry entry : o.entrySet()) {
                Object k = this.key.read(recipe, entry.getKey());
                Object v = this.component.read(recipe, entry.getValue());
                map.put(k, v);
            }
            return map;
        }
        throw new IllegalArgumentException("Expected JSON object!");
    }

    public boolean isInput(RecipeJS recipe, Map<K, V> value, ReplacementMatch match) {
        for (Map.Entry<K, V> entry : value.entrySet()) {
            if (!this.component.isInput(recipe, entry.getValue(), match)) continue;
            return true;
        }
        return false;
    }

    public Map<K, V> replaceInput(RecipeJS recipe, Map<K, V> original, ReplacementMatch match, InputReplacement with) {
        Map<K, Object> map = original;
        for (Map.Entry<K, V> entry : original.entrySet()) {
            Object r = this.component.replaceInput(recipe, entry.getValue(), match, with);
            if (r == entry.getValue()) continue;
            if (map == original) {
                map = new HashMap<K, V>(original);
            }
            map.put(entry.getKey(), r);
        }
        return map;
    }

    public boolean isOutput(RecipeJS recipe, Map<K, V> value, ReplacementMatch match) {
        for (Map.Entry<K, V> entry : value.entrySet()) {
            if (!this.component.isOutput(recipe, entry.getValue(), match)) continue;
            return true;
        }
        return false;
    }

    public Map<K, V> replaceOutput(RecipeJS recipe, Map<K, V> original, ReplacementMatch match, OutputReplacement with) {
        Map<K, Object> map = original;
        for (Map.Entry<K, V> entry : original.entrySet()) {
            Object r = this.component.replaceOutput(recipe, entry.getValue(), match, with);
            if (r == entry.getValue()) continue;
            if (map == original) {
                map = new HashMap<K, V>(original);
            }
            map.put(entry.getKey(), r);
        }
        return map;
    }

    @Override
    public String toString() {
        return "java_map{" + String.valueOf(this.key) + ":" + String.valueOf(this.component) + "}";
    }
}

