/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ParallelProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return GTCEu.id("parallel");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        BlockEntity blockEntity = level.m_7702_(iProbeHitData.getPos());
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity machineBlockEntity = (MetaMachineBlockEntity)blockEntity;
            int parallel = 0;
            int batch = 0;
            int subtickParallel = 0;
            int totalRuns = 0;
            boolean exact = false;
            MetaMachine metaMachine = machineBlockEntity.getMetaMachine();
            if (metaMachine instanceof IParallelHatch) {
                IParallelHatch parallelHatch = (IParallelHatch)((Object)metaMachine);
                parallel = parallelHatch.getCurrentParallel();
            } else {
                metaMachine = machineBlockEntity.getMetaMachine();
                if (metaMachine instanceof IMultiController) {
                    IRecipeLogicMachine rlm;
                    IMultiController controller = (IMultiController)((Object)metaMachine);
                    if (controller instanceof IRecipeLogicMachine && (rlm = (IRecipeLogicMachine)((Object)controller)).getRecipeLogic().isActive() && rlm.getRecipeLogic().getLastRecipe() != null) {
                        parallel = rlm.getRecipeLogic().getLastRecipe().parallels;
                        batch = rlm.getRecipeLogic().getLastRecipe().batchParallels;
                        subtickParallel = rlm.getRecipeLogic().getLastRecipe().subtickParallels;
                        totalRuns = rlm.getRecipeLogic().getLastRecipe().getTotalRuns();
                        exact = true;
                    } else {
                        parallel = controller.getParallelHatch().map(IParallelHatch::getCurrentParallel).orElse(0);
                    }
                }
            }
            if (!exact && parallel > 1) {
                MutableComponent parallels = Component.m_237113_((String)FormattingUtil.formatNumbers(parallel)).m_130940_(ChatFormatting.DARK_PURPLE);
                key = "gtceu.multiblock.parallel";
                iProbeInfo.text((Component)Component.m_237110_((String)key, (Object[])new Object[]{parallels}));
            } else if (totalRuns > 1) {
                MutableComponent runs = Component.m_237113_((String)FormattingUtil.formatNumbers(totalRuns)).m_130940_(ChatFormatting.DARK_PURPLE);
                key = "gtceu.multiblock.total_runs";
                iProbeInfo.text((Component)Component.m_237110_((String)key, (Object[])new Object[]{runs}));
                if (parallel > 1) {
                    MutableComponent parallels = Component.m_237113_((String)FormattingUtil.formatNumbers(parallel)).m_130940_(ChatFormatting.DARK_PURPLE);
                    String keyParallel = "gtceu.multiblock.parallel.exact";
                    iProbeInfo.text((Component)Component.m_237110_((String)keyParallel, (Object[])new Object[]{parallels}));
                }
                if (batch > 1) {
                    MutableComponent batches = Component.m_237113_((String)FormattingUtil.formatNumbers(batch)).m_130940_(ChatFormatting.DARK_PURPLE);
                    String keyBatch = "gtceu.multiblock.batch_enabled";
                    iProbeInfo.text((Component)Component.m_237110_((String)keyBatch, (Object[])new Object[]{batches}));
                }
                if (subtickParallel > 1) {
                    MutableComponent subticks = Component.m_237113_((String)FormattingUtil.formatNumbers(subtickParallel)).m_130940_(ChatFormatting.DARK_PURPLE);
                    String keySubtick = "gtceu.multiblock.subtick_parallels";
                    iProbeInfo.text((Component)Component.m_237110_((String)keySubtick, (Object[])new Object[]{subticks}));
                }
            }
        }
    }
}

